/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.bc.user.search;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.bc.JiraServiceContext;
import com.atlassian.jira.bc.user.search.UserMatcherPredicate;
import com.atlassian.jira.bc.user.search.UserPickerSearchService;
import com.atlassian.jira.bc.user.search.UserSearchParams;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.issue.comparator.UserCachingComparator;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.security.groups.GroupManager;
import com.atlassian.jira.security.roles.ProjectRole;
import com.atlassian.jira.security.roles.ProjectRoleManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.UserFilter;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.jira.util.StopWatch;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class DefaultUserPickerSearchService
implements UserPickerSearchService {
    private static final Logger log = Logger.getLogger(DefaultUserPickerSearchService.class);
    private final UserManager userManager;
    private final ApplicationProperties applicationProperties;
    private final JiraAuthenticationContext authenticationContext;
    private final PermissionManager permissionManager;
    private final GroupManager groupManager;
    private final ProjectManager projectManager;
    private final ProjectRoleManager projectRoleManager;
    private static final String VISIBILITY_PUBLIC = "show";
    private static final String VISIBILITY_USER = "user";
    private static final String VISIBILITY_MASKED = "mask";

    public DefaultUserPickerSearchService(UserManager userManager, ApplicationProperties applicationProperties, JiraAuthenticationContext authenticationContext, PermissionManager permissionManager, GroupManager groupManager, ProjectManager projectManager, ProjectRoleManager projectRoleManager) {
        this.userManager = userManager;
        this.applicationProperties = applicationProperties;
        this.authenticationContext = authenticationContext;
        this.permissionManager = permissionManager;
        this.groupManager = groupManager;
        this.projectManager = projectManager;
        this.projectRoleManager = projectRoleManager;
    }

    public List<User> findUsers(JiraServiceContext jiraServiceContext, String query) {
        if (StringUtils.isBlank((String)query)) {
            return Collections.emptyList();
        }
        return this.findUsers(jiraServiceContext, query, UserSearchParams.ACTIVE_USERS_IGNORE_EMPTY_QUERY);
    }

    public User getUserByName(JiraServiceContext jiraServiceContext, String query) {
        return this.userManager.getUser(query);
    }

    public List<User> findUsersAllowEmptyQuery(JiraServiceContext jiraServiceContext, String query) {
        return this.findUsers(jiraServiceContext, query, UserSearchParams.ACTIVE_USERS_ALLOW_EMPTY_QUERY);
    }

    public List<User> findUsers(JiraServiceContext jiraServiceContext, String query, UserSearchParams userSearchParams) {
        if (!this.canPerformAjaxSearch(jiraServiceContext)) {
            return Collections.emptyList();
        }
        return this.findUsers(query, UserSearchParams.builder((UserSearchParams)userSearchParams).canMatchEmail(this.canShowEmailAddresses(jiraServiceContext)).build());
    }

    public List<User> findUsers(String query, UserSearchParams userSearchParams) {
        return this.findUsers(query, null, userSearchParams);
    }

    public List<User> findUsers(String nameQuery, String emailQuery, UserSearchParams userSearchParams) {
        if (this.areQueriesNotAllowed(nameQuery, emailQuery, userSearchParams)) {
            return Collections.emptyList();
        }
        StopWatch stopWatch = new StopWatch();
        String convertedQuery = this.convertQuery(nameQuery);
        String convertedEmailQuery = this.convertQuery(emailQuery);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Running user-picker search: '" + convertedQuery + "', emailQuery '" + convertedEmailQuery + "'"));
        }
        ArrayList<User> returnUsers = new ArrayList<User>();
        Collection allUsers = this.getUsersByUserFilter(userSearchParams.getUserFilter(), userSearchParams.getProjectIds());
        if (allUsers == null) {
            allUsers = this.userManager.getUsers();
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Found all " + allUsers.size() + " users in " + stopWatch.getIntervalTime() + "ms"));
        }
        UserMatcherPredicate userMatcher = new UserMatcherPredicate(convertedQuery, convertedEmailQuery, userSearchParams.canMatchEmail());
        for (User user : allUsers) {
            if (!this.userMatchesQueries(user, userSearchParams, userMatcher)) continue;
            returnUsers.add(user);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Matched " + returnUsers.size() + " users in " + stopWatch.getIntervalTime() + "ms"));
        }
        Collections.sort(returnUsers, new UserCachingComparator(this.authenticationContext.getLocale()));
        if (log.isDebugEnabled()) {
            log.debug((Object)("Sorted top " + returnUsers.size() + " users in " + stopWatch.getIntervalTime() + "ms"));
            log.debug((Object)("User-picker search completed in " + stopWatch.getTotalTime() + "ms"));
        }
        return returnUsers;
    }

    private Collection<User> getUsersByUserFilter(UserFilter userFilter, Set<Long> projectIds) {
        if (userFilter == null || !userFilter.isEnabled()) {
            return null;
        }
        Collection<User> allUsers = this.getUsersByGroups(userFilter.getGroups(), null);
        allUsers = this.getUsersByRoles(userFilter.getRoleIds(), projectIds, allUsers);
        return allUsers == null ? Lists.newArrayList() : allUsers;
    }

    private Collection<User> getUsersByRoles(Set<Long> roleIds, Set<Long> projectIds, Collection<User> existingUsers) {
        if (CollectionUtils.isEmpty(projectIds) || CollectionUtils.isEmpty(roleIds)) {
            return existingUsers;
        }
        Collection<Object> allUsers = existingUsers == null ? Sets.newHashSet() : existingUsers;
        for (Project project : this.getProjects(projectIds)) {
            for (long roleId : roleIds) {
                ProjectRole projectRole = this.projectRoleManager.getProjectRole(Long.valueOf(roleId));
                if (projectRole == null) continue;
                allUsers.addAll(this.projectRoleManager.getProjectRoleActors(projectRole, project).getUsers());
            }
        }
        return allUsers;
    }

    private Collection<User> getUsersByGroups(Set<String> groupNames, Collection<User> existingUsers) {
        if (CollectionUtils.isEmpty(groupNames)) {
            return existingUsers;
        }
        Collection<Object> allUsers = existingUsers == null ? Sets.newHashSet() : existingUsers;
        for (String groupName : groupNames) {
            allUsers.addAll(this.groupManager.getUsersInGroup(groupName));
        }
        return allUsers;
    }

    private boolean userMatches(ApplicationUser user, String nameQuery, String emailQuery, UserSearchParams userSearchParams) {
        if (user == null) {
            return false;
        }
        if (this.areQueriesNotAllowed(nameQuery, emailQuery, userSearchParams)) {
            return false;
        }
        UserMatcherPredicate userMatcher = new UserMatcherPredicate(this.convertQuery(nameQuery), this.convertQuery(emailQuery), userSearchParams.canMatchEmail());
        if (!this.userMatchesQueries(user.getDirectoryUser(), userSearchParams, userMatcher)) {
            return false;
        }
        return this.userMatchesByUserFilter(user, userSearchParams.getUserFilter(), userSearchParams.getProjectIds());
    }

    public boolean userMatches(ApplicationUser user, UserSearchParams userSearchParams) {
        UserSearchParams allowEmptyQueryParams = userSearchParams.allowEmptyQuery() ? userSearchParams : UserSearchParams.builder((UserSearchParams)userSearchParams).allowEmptyQuery(true).build();
        return this.userMatches(user, null, null, allowEmptyQueryParams);
    }

    private boolean userMatchesByUserFilter(ApplicationUser user, UserFilter userFilter, Set<Long> projectIds) {
        return userFilter == null || !userFilter.isEnabled() || this.userMatchesByGroups(user, userFilter.getGroups()) || this.userMatchesByRoles(user, userFilter.getRoleIds(), projectIds);
    }

    private boolean userMatchesByRoles(ApplicationUser user, Set<Long> roleIds, Set<Long> projectIds) {
        if (CollectionUtils.isEmpty(roleIds)) {
            return false;
        }
        for (Project project : this.getProjects(projectIds)) {
            for (long roleId : roleIds) {
                ProjectRole projectRole = this.projectRoleManager.getProjectRole(Long.valueOf(roleId));
                if (projectRole == null || !this.projectRoleManager.isUserInProjectRole(user, projectRole, project)) continue;
                return true;
            }
        }
        return false;
    }

    private Collection<Project> getProjects(final Set<Long> projectIds) {
        if (CollectionUtils.isEmpty(projectIds)) {
            return ImmutableList.of();
        }
        if (projectIds.size() == 1) {
            Project project = this.projectManager.getProjectObj(projectIds.iterator().next());
            return project == null ? ImmutableList.of() : ImmutableList.of((Object)project);
        }
        List projects = this.projectManager.getProjectObjects();
        return Collections2.filter((Collection)projects, (Predicate)new Predicate<Project>(){

            public boolean apply(@Nullable Project input) {
                return input != null && projectIds.contains(input.getId());
            }
        });
    }

    private boolean userMatchesByGroups(ApplicationUser user, Set<String> groupNames) {
        if (CollectionUtils.isEmpty(groupNames)) {
            return false;
        }
        Collection groupsUser = this.groupManager.getGroupNamesForUser(user.getDirectoryUser());
        for (String groupUser : groupsUser) {
            if (!groupNames.contains(groupUser)) continue;
            return true;
        }
        return false;
    }

    private String convertQuery(String nameQuery) {
        return nameQuery == null ? "" : nameQuery.toLowerCase().trim();
    }

    private boolean areQueriesNotAllowed(String nameQuery, String emailQuery, UserSearchParams userSearchParams) {
        return !userSearchParams.allowEmptyQuery() && StringUtils.isBlank((String)nameQuery) && (!userSearchParams.canMatchEmail() || StringUtils.isBlank((String)emailQuery));
    }

    private boolean userMatchesQueries(User user, UserSearchParams userSearchParams, Predicate<User> userMatcher) {
        return (user.isActive() ? userSearchParams.includeActive() : userSearchParams.includeInactive()) && userMatcher.apply((Object)user);
    }

    public boolean canShowEmailAddresses(JiraServiceContext jiraServiceContext) {
        String emailVisibility;
        return this.canPerformAjaxSearch(jiraServiceContext) && (VISIBILITY_PUBLIC.equals(emailVisibility = this.applicationProperties.getDefaultBackedString("jira.option.emailvisible")) || VISIBILITY_MASKED.equals(emailVisibility) || VISIBILITY_USER.equals(emailVisibility) && jiraServiceContext.getLoggedInApplicationUser() != null);
    }

    public boolean canPerformAjaxSearch(JiraServiceContext jiraServiceContext) {
        ApplicationUser loggedInUser = jiraServiceContext != null ? jiraServiceContext.getLoggedInApplicationUser() : null;
        return this.canPerformAjaxSearch(loggedInUser);
    }

    public boolean canPerformAjaxSearch(User user) {
        return this.permissionManager.hasPermission(27, user);
    }

    public boolean canPerformAjaxSearch(ApplicationUser user) {
        return this.permissionManager.hasPermission(27, user);
    }
}

