/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.bc.project.component;

import com.atlassian.cache.Cache;
import com.atlassian.cache.CacheLoader;
import com.atlassian.cache.CacheManager;
import com.atlassian.cache.CacheSettingsBuilder;
import com.atlassian.event.api.EventListener;
import com.atlassian.jira.EventComponent;
import com.atlassian.jira.bc.EntityNotFoundException;
import com.atlassian.jira.bc.project.component.MutableProjectComponent;
import com.atlassian.jira.bc.project.component.ProjectComponent;
import com.atlassian.jira.bc.project.component.ProjectComponentComparator;
import com.atlassian.jira.bc.project.component.ProjectComponentStore;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.event.ClearCacheEvent;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.jira.util.map.CacheObject;
import com.atlassian.util.concurrent.NotNull;
import com.opensymphony.util.TextUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;

@EventComponent
public class CachingProjectComponentStore
implements ProjectComponentStore {
    private static final Logger log = Logger.getLogger(CachingProjectComponentStore.class);
    private final Cache<Long, CacheObject<ProjectComponent>> componentIdToComponentMap;
    private final Cache<Long, Collection<ProjectComponent>> projectIdToComponentsMap;
    private final ProjectComponentStore delegateStore;

    public CachingProjectComponentStore(ProjectComponentStore delegateStore, CacheManager cacheManager) {
        this.delegateStore = delegateStore;
        this.componentIdToComponentMap = cacheManager.getCache(CachingProjectComponentStore.class.getName() + ".componentIdToComponentMap", (CacheLoader)new ComponentByIdCacheLoader(), new CacheSettingsBuilder().expireAfterAccess(30L, TimeUnit.MINUTES).build());
        this.projectIdToComponentsMap = cacheManager.getCache(CachingProjectComponentStore.class.getName() + ".projectIdToComponentsMap", (CacheLoader)new ComponentByProjectCacheLoader(), new CacheSettingsBuilder().expireAfterAccess(30L, TimeUnit.MINUTES).build());
    }

    @EventListener
    public void onClearCache(ClearCacheEvent event) {
        this.projectIdToComponentsMap.removeAll();
        this.componentIdToComponentMap.removeAll();
    }

    @Override
    public MutableProjectComponent find(Long id) throws EntityNotFoundException {
        Assertions.notNull((String)"id", (Object)id);
        ProjectComponent component = (ProjectComponent)((CacheObject)this.componentIdToComponentMap.get((Object)id)).getValue();
        if (component == null) {
            throw new EntityNotFoundException("The component with id '" + id + "' does not exist.");
        }
        return MutableProjectComponent.copy((ProjectComponent)component);
    }

    @Override
    public Collection<MutableProjectComponent> findAllForProject(Long projectId) {
        Collection components = (Collection)this.projectIdToComponentsMap.get((Object)projectId);
        return MutableProjectComponent.copy((Collection)components);
    }

    @Override
    public MutableProjectComponent findByComponentName(Long projectId, String componentName) throws EntityNotFoundException {
        Collection<MutableProjectComponent> components = this.findAllForProject(projectId);
        for (MutableProjectComponent c : components) {
            if (!c.getName().equals(componentName)) continue;
            return c;
        }
        throw new EntityNotFoundException("The project with id '" + projectId + "' is not associated with a component with the name '" + componentName + "'.");
    }

    @Override
    public Collection<MutableProjectComponent> findByComponentNameCaseInSensitive(String componentName) {
        Collection components = this.findAll();
        ArrayList<MutableProjectComponent> matchingComponents = new ArrayList<MutableProjectComponent>();
        for (MutableProjectComponent component : components) {
            if (!component.getName().equalsIgnoreCase(componentName)) continue;
            matchingComponents.add(component);
        }
        return matchingComponents;
    }

    @Override
    public Long findProjectIdForComponent(Long componentId) throws EntityNotFoundException {
        ProjectComponent component = (ProjectComponent)((CacheObject)this.componentIdToComponentMap.get((Object)componentId)).getValue();
        if (component == null) {
            throw new EntityNotFoundException("The component with the id '" + componentId + "' does not exist.");
        }
        return component.getProjectId();
    }

    @Override
    public boolean containsName(String name, Long projectId) {
        if (projectId == null) {
            throw new IllegalArgumentException("Component project ID can not be null!");
        }
        if (name == null) {
            throw new IllegalArgumentException("Component name can not be null!");
        }
        Collection components = (Collection)this.projectIdToComponentsMap.get((Object)projectId);
        return CachingProjectComponentStore.containsNameIgnoreCase(components, name);
    }

    static boolean containsNameIgnoreCase(Collection<ProjectComponent> components, String name) {
        boolean containsName = false;
        if (components != null) {
            for (ProjectComponent component : components) {
                String componentName = component.getName();
                if (!name.equalsIgnoreCase(componentName)) continue;
                containsName = true;
            }
        }
        return containsName;
    }

    @Override
    public MutableProjectComponent store(MutableProjectComponent component) throws EntityNotFoundException, DataAccessException {
        MutableProjectComponent copy = MutableProjectComponent.copy((ProjectComponent)component);
        MutableProjectComponent newComponent = copy.getId() == null ? this.insert(copy) : this.update(copy);
        return newComponent;
    }

    @Override
    public void delete(Long componentId) throws EntityNotFoundException {
        MutableProjectComponent component = null;
        if (componentId != null) {
            component = this.delegateStore.find(componentId);
        }
        this.delegateStore.delete(componentId);
        this.componentIdToComponentMap.remove((Object)componentId);
        if (component != null) {
            this.projectIdToComponentsMap.remove((Object)component.getProjectId());
        }
    }

    @Override
    public Collection findComponentsBylead(String userKey) {
        ArrayList<MutableProjectComponent> leadComponents = new ArrayList<MutableProjectComponent>();
        Collection components = this.findAll();
        for (Object component : components) {
            MutableProjectComponent projectComponent = (MutableProjectComponent)component;
            if (projectComponent == null || !TextUtils.stringSet((String)projectComponent.getLead()) || !projectComponent.getLead().equals(userKey)) continue;
            leadComponents.add(projectComponent);
        }
        return leadComponents;
    }

    @Override
    public Collection findAll() {
        ProjectManager projectManager = ComponentAccessor.getProjectManager();
        ArrayList components = new ArrayList();
        List allProjects = projectManager.getProjectObjects();
        for (Project project : allProjects) {
            components.addAll((Collection)this.projectIdToComponentsMap.get((Object)project.getId()));
        }
        return components;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized MutableProjectComponent insert(MutableProjectComponent component) {
        String name = component.getName();
        if (this.containsName(name, component.getProjectId())) {
            throw this.createIllegalArgumentExceptionForName(name);
        }
        try {
            MutableProjectComponent mutableProjectComponent = component = this.delegateStore.store(component);
            return mutableProjectComponent;
        }
        catch (EntityNotFoundException e) {
            MutableProjectComponent mutableProjectComponent = null;
            return mutableProjectComponent;
        }
        finally {
            this.componentIdToComponentMap.remove((Object)component.getId());
            this.projectIdToComponentsMap.remove((Object)component.getProjectId());
        }
    }

    private synchronized MutableProjectComponent update(MutableProjectComponent component) throws EntityNotFoundException, DataAccessException {
        MutableProjectComponent old = this.find(component.getId());
        if (!old.equalsName(component) && this.containsName(component.getName(), component.getProjectId())) {
            throw new IllegalArgumentException("New component name '" + component.getName() + "' is not unique!");
        }
        this.delegateStore.store(component);
        this.updateCache((ProjectComponent)component);
        return component;
    }

    private synchronized void updateCache(ProjectComponent component) {
        Long id = component.getId();
        Long projectId = component.getProjectId();
        this.componentIdToComponentMap.remove((Object)id);
        this.projectIdToComponentsMap.remove((Object)projectId);
    }

    private IllegalArgumentException createIllegalArgumentExceptionForName(String name) {
        return new IllegalArgumentException("Component name = '" + name + "' is not unique");
    }

    private Collection<ProjectComponent> sortByComponentNames(Collection<ProjectComponent> components) {
        ArrayList<ProjectComponent> componentList = new ArrayList<ProjectComponent>(components);
        Collections.sort(componentList, ProjectComponentComparator.INSTANCE);
        return componentList;
    }

    private class ComponentByProjectCacheLoader
    implements CacheLoader<Long, Collection<ProjectComponent>> {
        private ComponentByProjectCacheLoader() {
        }

        public Collection<ProjectComponent> load(@NotNull Long projectId) {
            return CachingProjectComponentStore.this.sortByComponentNames(CachingProjectComponentStore.this.delegateStore.findAllForProject(projectId));
        }
    }

    private class ComponentByIdCacheLoader
    implements CacheLoader<Long, CacheObject<ProjectComponent>> {
        private ComponentByIdCacheLoader() {
        }

        public CacheObject<ProjectComponent> load(@NotNull Long id) {
            try {
                return new CacheObject<MutableProjectComponent>(CachingProjectComponentStore.this.delegateStore.find(id));
            }
            catch (EntityNotFoundException e) {
                return CacheObject.NULL();
            }
        }
    }
}

