/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.bc.project;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.association.NodeAssociationStore;
import com.atlassian.jira.avatar.Avatar;
import com.atlassian.jira.avatar.AvatarManager;
import com.atlassian.jira.bc.EntityNotFoundException;
import com.atlassian.jira.bc.JiraServiceContext;
import com.atlassian.jira.bc.JiraServiceContextImpl;
import com.atlassian.jira.bc.ServiceOutcome;
import com.atlassian.jira.bc.ServiceOutcomeImpl;
import com.atlassian.jira.bc.ServiceResult;
import com.atlassian.jira.bc.ServiceResultImpl;
import com.atlassian.jira.bc.project.ProjectAction;
import com.atlassian.jira.bc.project.ProjectNameValidator;
import com.atlassian.jira.bc.project.ProjectService;
import com.atlassian.jira.bc.project.component.ProjectComponent;
import com.atlassian.jira.bc.project.component.ProjectComponentManager;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.event.project.ProjectEventManager;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.exception.RemoveException;
import com.atlassian.jira.issue.CustomFieldManager;
import com.atlassian.jira.issue.fields.screen.issuetype.IssueTypeScreenScheme;
import com.atlassian.jira.issue.fields.screen.issuetype.IssueTypeScreenSchemeManager;
import com.atlassian.jira.issue.security.IssueSecuritySchemeManager;
import com.atlassian.jira.notification.NotificationSchemeManager;
import com.atlassian.jira.permission.PermissionSchemeManager;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectAssigneeTypes;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.project.util.ProjectKeyStore;
import com.atlassian.jira.project.version.Version;
import com.atlassian.jira.project.version.VersionManager;
import com.atlassian.jira.scheme.Scheme;
import com.atlassian.jira.scheme.SchemeFactory;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.sharing.SharePermissionDeleteUtils;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.ApplicationUsers;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.JiraKeyUtils;
import com.atlassian.jira.util.SimpleErrorCollection;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.jira.workflow.WorkflowManager;
import com.atlassian.jira.workflow.WorkflowSchemeManager;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.opensymphony.util.TextUtils;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;

public class DefaultProjectService
implements ProjectService {
    private static final int MAX_FIELD_LENGTH = 255;
    private static final int DEFAULT_KEY_LENGTH = 10;
    private static final Logger log = Logger.getLogger(DefaultProjectService.class);
    private final JiraAuthenticationContext jiraAuthenticationContext;
    private final ProjectManager projectManager;
    private final ApplicationProperties applicationProperties;
    private final PermissionManager permissionManager;
    private final PermissionSchemeManager permissionSchemeManager;
    private final NotificationSchemeManager notificationSchemeManager;
    private final IssueSecuritySchemeManager issueSecuritySchemeManager;
    private final SchemeFactory schemeFactory;
    private final WorkflowSchemeManager workflowSchemeManager;
    private final IssueTypeScreenSchemeManager issueTypeScreenSchemeManager;
    private final CustomFieldManager customFieldManager;
    private final NodeAssociationStore nodeAssociationStore;
    private final VersionManager versionManager;
    private final ProjectComponentManager projectComponentManager;
    private final SharePermissionDeleteUtils sharePermissionDeleteUtils;
    private final AvatarManager avatarManager;
    private final I18nHelper.BeanFactory i18nFactory;
    private final WorkflowManager workflowManager;
    private UserManager userManager;
    private final ProjectEventManager projectEventManager;
    private final ProjectKeyStore projectKeyStore;
    private final ProjectNameValidator projectNameValidator;

    public DefaultProjectService(JiraAuthenticationContext jiraAuthenticationContext, ProjectManager projectManager, ApplicationProperties applicationProperties, PermissionManager permissionManager, PermissionSchemeManager permissionSchemeManager, NotificationSchemeManager notificationSchemeManager, IssueSecuritySchemeManager issueSecuritySchemeManager, SchemeFactory schemeFactory, WorkflowSchemeManager workflowSchemeManager, IssueTypeScreenSchemeManager issueTypeScreenSchemeManager, CustomFieldManager customFieldManager, NodeAssociationStore nodeAssociationStore, VersionManager versionManager, ProjectComponentManager projectComponentManager, SharePermissionDeleteUtils sharePermissionDeleteUtils, AvatarManager avatarManager, I18nHelper.BeanFactory i18nFactory, WorkflowManager workflowManager, UserManager userManager, ProjectEventManager projectEventManager, ProjectKeyStore projectKeyStore) {
        this.jiraAuthenticationContext = jiraAuthenticationContext;
        this.projectManager = projectManager;
        this.applicationProperties = applicationProperties;
        this.permissionManager = permissionManager;
        this.permissionSchemeManager = permissionSchemeManager;
        this.notificationSchemeManager = notificationSchemeManager;
        this.issueSecuritySchemeManager = issueSecuritySchemeManager;
        this.schemeFactory = schemeFactory;
        this.workflowSchemeManager = workflowSchemeManager;
        this.issueTypeScreenSchemeManager = issueTypeScreenSchemeManager;
        this.customFieldManager = customFieldManager;
        this.nodeAssociationStore = nodeAssociationStore;
        this.versionManager = versionManager;
        this.projectComponentManager = projectComponentManager;
        this.sharePermissionDeleteUtils = sharePermissionDeleteUtils;
        this.avatarManager = avatarManager;
        this.i18nFactory = i18nFactory;
        this.workflowManager = workflowManager;
        this.userManager = userManager;
        this.projectEventManager = projectEventManager;
        this.projectKeyStore = projectKeyStore;
        this.projectNameValidator = new ProjectNameValidator(this, projectManager);
    }

    public ProjectService.CreateProjectValidationResult validateCreateProject(User user, String name, String key, String description, String leadName, String url, Long assigneeType) {
        return this.validateCreateProject(user, name, key, description, leadName, url, assigneeType, null);
    }

    public ServiceResult validateUpdateProject(ApplicationUser user, String key) {
        return this.validateUpdateProject(ApplicationUsers.toDirectoryUser((ApplicationUser)user), key);
    }

    public ProjectService.UpdateProjectValidationResult validateUpdateProject(ApplicationUser user, String name, String key, String description, ApplicationUser lead, String url, Long assigneeType) {
        return this.validateUpdateProject(ApplicationUsers.toDirectoryUser((ApplicationUser)user), name, key, description, this.nameFor(lead), url, assigneeType);
    }

    public ProjectService.UpdateProjectValidationResult validateUpdateProject(ApplicationUser user, String name, String key, String description, ApplicationUser lead, String url, Long assigneeType, Long avatarId) {
        return this.validateUpdateProject(ApplicationUsers.toDirectoryUser((ApplicationUser)user), name, key, description, this.nameFor(lead), url, assigneeType, avatarId);
    }

    public ProjectService.DeleteProjectValidationResult validateDeleteProject(ApplicationUser user, String key) {
        return this.validateDeleteProject(ApplicationUsers.toDirectoryUser((ApplicationUser)user), key);
    }

    public ProjectService.DeleteProjectResult deleteProject(ApplicationUser user, ProjectService.DeleteProjectValidationResult deleteProjectValidationResult) {
        return this.deleteProject(ApplicationUsers.toDirectoryUser((ApplicationUser)user), deleteProjectValidationResult);
    }

    public ProjectService.UpdateProjectSchemesValidationResult validateUpdateProjectSchemes(ApplicationUser user, Long permissionSchemeId, Long notificationSchemeId, Long issueSecuritySchemeId) {
        return this.validateUpdateProjectSchemes(ApplicationUsers.toDirectoryUser((ApplicationUser)user), permissionSchemeId, notificationSchemeId, issueSecuritySchemeId);
    }

    public ProjectService.GetProjectResult getProjectById(ApplicationUser user, Long id) {
        return this.getProjectById(ApplicationUsers.toDirectoryUser((ApplicationUser)user), id);
    }

    public ProjectService.GetProjectResult getProjectByIdForAction(ApplicationUser user, Long id, ProjectAction action) {
        return this.getProjectByIdForAction(ApplicationUsers.toDirectoryUser((ApplicationUser)user), id, action);
    }

    public ProjectService.GetProjectResult getProjectByKey(ApplicationUser user, String key) {
        return this.getProjectByKey(ApplicationUsers.toDirectoryUser((ApplicationUser)user), key);
    }

    public ProjectService.GetProjectResult getProjectByKeyForAction(ApplicationUser user, String key, ProjectAction action) {
        return this.getProjectByKeyForAction(ApplicationUsers.toDirectoryUser((ApplicationUser)user), key, action);
    }

    public ServiceOutcome<List<Project>> getAllProjects(ApplicationUser user) {
        return this.getAllProjects(ApplicationUsers.toDirectoryUser((ApplicationUser)user));
    }

    public ServiceOutcome<List<Project>> getAllProjectsForAction(ApplicationUser user, ProjectAction action) {
        return this.getAllProjectsForAction(ApplicationUsers.toDirectoryUser((ApplicationUser)user), action);
    }

    public ProjectService.CreateProjectValidationResult validateCreateProject(User user, String name, String key, String description, String leadName, String url, Long assigneeType, Long avatarId) {
        JiraServiceContext serviceContext = this.getServiceContext(user, (ErrorCollection)new SimpleErrorCollection());
        I18nHelper i18nBean = this.getI18nBean(user);
        if (!this.permissionManager.hasPermission(0, user)) {
            serviceContext.getErrorCollection().addErrorMessage(i18nBean.getText("admin.projects.service.error.no.admin.permission"));
            return new ProjectService.CreateProjectValidationResult(serviceContext.getErrorCollection());
        }
        this.isValidAllProjectData(serviceContext, name, key, leadName, url, assigneeType, avatarId);
        if (serviceContext.getErrorCollection().hasAnyErrors()) {
            return new ProjectService.CreateProjectValidationResult(serviceContext.getErrorCollection());
        }
        return new ProjectService.CreateProjectValidationResult(serviceContext.getErrorCollection(), name, key, description, leadName, url, assigneeType, avatarId, ApplicationUsers.from((User)user));
    }

    protected JiraServiceContext getServiceContext(User user, ErrorCollection errorCollection) {
        return new JiraServiceContextImpl(user, errorCollection);
    }

    public Project createProject(ProjectService.CreateProjectValidationResult result) {
        if (result == null) {
            throw new IllegalArgumentException("You can not create a project with a null validation result.");
        }
        if (!result.isValid()) {
            throw new IllegalStateException("You can not create a project with an invalid validation result.");
        }
        Project newProject = this.projectManager.createProject(result.getName(), result.getKey().toUpperCase(), result.getDescription(), this.keyFor(result.getLeadUsername()), result.getUrl(), this.effectiveAssigneeType(result.getAssigneeType()), result.getAvatarId());
        this.associateWithDefaultSchemes(newProject);
        this.workflowSchemeManager.clearWorkflowCache();
        this.projectEventManager.dispatchProjectCreated(result.getUser(), newProject);
        return newProject;
    }

    private void associateWithDefaultSchemes(Project newProject) {
        this.issueTypeScreenSchemeManager.associateWithDefaultScheme(newProject);
        this.notificationSchemeManager.addDefaultSchemeToProject(newProject);
        this.permissionSchemeManager.addDefaultSchemeToProject(newProject);
    }

    public ProjectService.UpdateProjectValidationResult validateUpdateProject(User user, String name, String key, String description, String leadName, String url, Long assigneeType) {
        return this.validateUpdateProject(user, name, key, description, leadName, url, assigneeType, null);
    }

    public ServiceResult validateUpdateProject(User user, String key) {
        SimpleErrorCollection errorCollection = new SimpleErrorCollection();
        ProjectService.GetProjectResult oldProjectResult = this.getProjectByKeyForAction(user, key, ProjectAction.EDIT_PROJECT_CONFIG);
        if (!oldProjectResult.isValid() || oldProjectResult.getProject() == null) {
            errorCollection.addErrorCollection(oldProjectResult.getErrorCollection());
            return new ServiceResultImpl((ErrorCollection)errorCollection);
        }
        return new ServiceResultImpl((ErrorCollection)errorCollection);
    }

    public ProjectService.UpdateProjectValidationResult validateUpdateProject(ApplicationUser user, Project originalProject, String name, String key, String description, ApplicationUser lead, String url, Long assigneeType, Long avatarId) {
        User directoryUser = ApplicationUsers.toDirectoryUser((ApplicationUser)user);
        SimpleErrorCollection errorCollection = new SimpleErrorCollection();
        I18nHelper i18nBean = this.getI18nBean(directoryUser);
        ProjectService.GetProjectResult oldProjectResult = this.getProjectByKeyForAction(user, originalProject.getKey(), ProjectAction.EDIT_PROJECT_CONFIG);
        if (!oldProjectResult.isValid() || oldProjectResult.getProject() == null) {
            errorCollection.addErrorCollection(oldProjectResult.getErrorCollection());
            return new ProjectService.UpdateProjectValidationResult((ErrorCollection)errorCollection);
        }
        if (!StringUtils.equals((CharSequence)oldProjectResult.getProject().getKey(), (CharSequence)key) && !this.checkActionPermission(directoryUser, oldProjectResult.getProject(), ProjectAction.EDIT_PROJECT_KEY)) {
            errorCollection.addError("projectKey", i18nBean.getText(ProjectAction.EDIT_PROJECT_KEY.getErrorKey()));
            return new ProjectService.UpdateProjectValidationResult((ErrorCollection)errorCollection);
        }
        this.validateProjectKey(oldProjectResult.getProject(), key, (ErrorCollection)errorCollection, i18nBean);
        if (errorCollection.hasAnyErrors()) {
            return new ProjectService.UpdateProjectValidationResult((ErrorCollection)errorCollection);
        }
        ServiceResult validateUserAndKey = this.validateUpdateProject(user, oldProjectResult.getProject().getKey());
        if (!validateUserAndKey.isValid()) {
            return new ProjectService.UpdateProjectValidationResult(validateUserAndKey.getErrorCollection());
        }
        ErrorCollection validationErrors = this.validateUpdateProjectData(directoryUser, name, oldProjectResult.getProject(), ApplicationUsers.getKeyFor((ApplicationUser)lead), url, assigneeType, avatarId);
        if (validationErrors.hasAnyErrors()) {
            return new ProjectService.UpdateProjectValidationResult(validationErrors);
        }
        return new ProjectService.UpdateProjectValidationResult((ErrorCollection)errorCollection, name, key, description, ApplicationUsers.getKeyFor((ApplicationUser)lead), url, assigneeType, avatarId, oldProjectResult.getProject(), !key.equals(oldProjectResult.getProject().getKey()), user);
    }

    public ProjectService.UpdateProjectValidationResult validateUpdateProject(User user, String name, String key, String description, String leadName, String url, Long assigneeType, Long avatarId) {
        ServiceResult validateUserAndKey = this.validateUpdateProject(user, key);
        if (!validateUserAndKey.isValid()) {
            return new ProjectService.UpdateProjectValidationResult(validateUserAndKey.getErrorCollection());
        }
        SimpleErrorCollection errorCollection = new SimpleErrorCollection();
        ProjectService.GetProjectResult oldProjectResult = this.getProjectByKeyForAction(user, key, ProjectAction.EDIT_PROJECT_CONFIG);
        ErrorCollection validationErrors = this.validateUpdateProjectData(user, name, oldProjectResult.getProject(), leadName, url, assigneeType, avatarId);
        if (validationErrors.hasAnyErrors()) {
            return new ProjectService.UpdateProjectValidationResult(validationErrors);
        }
        return new ProjectService.UpdateProjectValidationResult((ErrorCollection)errorCollection, name, null, description, leadName, url, assigneeType, avatarId, oldProjectResult.getProject(), false, ApplicationUsers.from((User)user));
    }

    public Project updateProject(ProjectService.UpdateProjectValidationResult result) {
        if (result == null) {
            throw new IllegalArgumentException("You can not update a project with a null validation result.");
        }
        if (!result.isValid()) {
            throw new IllegalStateException("You can not update a project with an invalid validation result.");
        }
        Project newProject = this.projectManager.updateProject(result.getOriginalProject(), result.getName(), result.getDescription(), this.keyFor(result.getLeadUsername()), result.getUrl(), result.getAssigneeType(), result.getAvatarId(), result.getKey());
        this.projectEventManager.dispatchProjectUpdated(result.getUser(), newProject, result.getOriginalProject());
        return newProject;
    }

    public ProjectService.UpdateProjectSchemesValidationResult validateUpdateProjectSchemes(User user, Long permissionSchemeId, Long notificationSchemeId, Long issueSecuritySchemeId) {
        GenericValue scheme;
        SimpleErrorCollection errorCollection = new SimpleErrorCollection();
        I18nHelper i18nBean = this.getI18nBean(user);
        if (!this.permissionManager.hasPermission(0, user)) {
            errorCollection.addErrorMessage(i18nBean.getText("admin.projects.service.error.no.admin.permission"));
            return new ProjectService.UpdateProjectSchemesValidationResult((ErrorCollection)errorCollection);
        }
        if (permissionSchemeId != null && !new Long(-1L).equals(permissionSchemeId)) {
            try {
                scheme = this.permissionSchemeManager.getScheme(permissionSchemeId);
                if (scheme == null) {
                    errorCollection.addErrorMessage(i18nBean.getText("admin.errors.project.validation.permission.scheme.not.retrieved"));
                }
            }
            catch (GenericEntityException e) {
                errorCollection.addErrorMessage(i18nBean.getText("admin.errors.project.validation.permission.scheme.not.retrieved.error", e.getMessage()));
            }
        }
        if (notificationSchemeId != null && !new Long(-1L).equals(notificationSchemeId)) {
            try {
                scheme = this.notificationSchemeManager.getScheme(notificationSchemeId);
                if (scheme == null) {
                    errorCollection.addErrorMessage(i18nBean.getText("admin.errors.project.validation.notification.scheme.not.retrieved"));
                }
            }
            catch (GenericEntityException e) {
                errorCollection.addErrorMessage(i18nBean.getText("admin.errors.project.validation.notification.scheme.not.retrieved.error", e.getMessage()));
            }
        }
        if (issueSecuritySchemeId != null && !new Long(-1L).equals(issueSecuritySchemeId) && (scheme = this.issueSecuritySchemeManager.getIssueSecurityLevelScheme(issueSecuritySchemeId)) == null) {
            errorCollection.addErrorMessage(i18nBean.getText("admin.errors.project.validation.issuesecurity.scheme.not.retrieved"));
        }
        if (errorCollection.hasAnyErrors()) {
            return new ProjectService.UpdateProjectSchemesValidationResult((ErrorCollection)errorCollection);
        }
        return new ProjectService.UpdateProjectSchemesValidationResult((ErrorCollection)errorCollection, permissionSchemeId, notificationSchemeId, issueSecuritySchemeId);
    }

    public void updateProjectSchemes(ProjectService.UpdateProjectSchemesValidationResult result, Project project) {
        if (result == null) {
            throw new IllegalArgumentException("You can not update project schemes with a null validation result.");
        }
        if (!result.isValid()) {
            throw new IllegalStateException("You can not update project schemes with an invalid validation result.");
        }
        if (project == null) {
            throw new IllegalArgumentException("You can not update project schemes for a null project.");
        }
        Long permissionSchemeId = result.getPermissionSchemeId();
        Long notificationSchemeId = result.getNotificationSchemeId();
        Long issueSecuritySchemeId = result.getIssueSecuritySchemeId();
        try {
            Scheme currentIssueSecurityScheme;
            Scheme currentPermissionScheme;
            Scheme currentNotificationScheme = this.notificationSchemeManager.getSchemeFor(project);
            if (currentNotificationScheme == null || !currentNotificationScheme.getId().equals(notificationSchemeId)) {
                this.notificationSchemeManager.removeSchemesFromProject(project);
                if (notificationSchemeId != null && !new Long(-1L).equals(notificationSchemeId)) {
                    GenericValue scheme = this.notificationSchemeManager.getScheme(notificationSchemeId);
                    this.notificationSchemeManager.addSchemeToProject(project, this.schemeFactory.getScheme(scheme));
                }
            }
            if (!((currentPermissionScheme = this.permissionSchemeManager.getSchemeFor(project)) != null && currentPermissionScheme.getId().equals(permissionSchemeId) || permissionSchemeId == null || new Long(-1L).equals(permissionSchemeId))) {
                this.permissionSchemeManager.removeSchemesFromProject(project);
                GenericValue scheme = this.permissionSchemeManager.getScheme(permissionSchemeId);
                this.permissionSchemeManager.addSchemeToProject(project, this.schemeFactory.getScheme(scheme));
            }
            if ((currentIssueSecurityScheme = this.issueSecuritySchemeManager.getSchemeFor(project)) == null || !currentIssueSecurityScheme.getId().equals(issueSecuritySchemeId)) {
                if (new Long(-1L).equals(issueSecuritySchemeId)) {
                    issueSecuritySchemeId = null;
                }
                this.issueSecuritySchemeManager.setSchemeForProject(project, issueSecuritySchemeId);
            }
        }
        catch (GenericEntityException e) {
            throw new DataAccessException((Throwable)e);
        }
    }

    public boolean isValidAllProjectData(JiraServiceContext serviceContext, String name, String key, String leadName, String url, Long assigneeType) {
        return this.isValidAllProjectData(serviceContext, name, key, leadName, url, assigneeType, null);
    }

    public boolean isValidAllProjectData(JiraServiceContext serviceContext, String name, String key, String leadName, String url, Long assigneeType, Long avatarId) {
        SimpleErrorCollection errorCollection = new SimpleErrorCollection();
        I18nHelper i18nHelper = serviceContext.getI18nBean();
        this.isValidRequiredProjectData(this.getServiceContext(serviceContext.getLoggedInUser(), (ErrorCollection)errorCollection), name, key, leadName);
        this.validateProjectUrl(url, (ErrorCollection)errorCollection, i18nHelper);
        this.validateProjectAssigneeType(assigneeType, (ErrorCollection)errorCollection, i18nHelper);
        this.validateAvatarId(avatarId, this.projectManager.getProjectObjByKey(key), (ErrorCollection)errorCollection, i18nHelper);
        if (errorCollection.hasAnyErrors()) {
            serviceContext.getErrorCollection().addErrorCollection((ErrorCollection)errorCollection);
            return false;
        }
        return true;
    }

    public boolean isValidRequiredProjectData(JiraServiceContext serviceContext, String name, String key, String leadName) {
        SimpleErrorCollection errorCollection = new SimpleErrorCollection();
        I18nHelper i18nBean = serviceContext.getI18nBean();
        this.validateProjectName(name, (ErrorCollection)errorCollection, i18nBean);
        this.validateProjectKey(null, key, (ErrorCollection)errorCollection, i18nBean);
        this.validateProjectLead(leadName, (ErrorCollection)errorCollection, i18nBean);
        if (errorCollection.hasAnyErrors()) {
            serviceContext.getErrorCollection().addErrorCollection((ErrorCollection)errorCollection);
            return false;
        }
        return true;
    }

    public boolean isValidProjectKey(JiraServiceContext serviceContext, String key) {
        SimpleErrorCollection errorCollection = new SimpleErrorCollection();
        I18nHelper i18nBean = serviceContext.getI18nBean();
        this.validateProjectKey(null, key, (ErrorCollection)errorCollection, i18nBean);
        if (errorCollection.hasAnyErrors()) {
            serviceContext.getErrorCollection().addErrorCollection((ErrorCollection)errorCollection);
            return false;
        }
        return true;
    }

    private ErrorCollection validateUpdateProjectData(User user, String name, Project oldProject, String leadName, String url, Long assigneeType, Long avatarId) {
        SimpleErrorCollection errorCollection = new SimpleErrorCollection();
        I18nHelper i18nHelper = this.getI18nBean(user);
        this.validateProjectNameForUpdate(name, oldProject.getKey(), (ErrorCollection)errorCollection, i18nHelper);
        this.validateProjectLead(leadName, (ErrorCollection)errorCollection, i18nHelper);
        this.validateProjectUrl(url, (ErrorCollection)errorCollection, i18nHelper);
        this.validateProjectAssigneeType(assigneeType, (ErrorCollection)errorCollection, i18nHelper);
        this.validateAvatarId(avatarId, oldProject, (ErrorCollection)errorCollection, i18nHelper);
        return errorCollection;
    }

    public String getProjectKeyDescription() {
        String projectKeyDescription = this.applicationProperties.getDefaultBackedString("jira.projectkey.description");
        I18nHelper i18nBean = this.jiraAuthenticationContext.getI18nHelper();
        if (TextUtils.stringSet((String)projectKeyDescription)) {
            return i18nBean.getText(projectKeyDescription);
        }
        return i18nBean.getText("admin.projects.key.description");
    }

    public ProjectService.GetProjectResult getProjectByIdForAction(User user, Long id, ProjectAction action) {
        Project project = this.projectManager.getProjectObj(id);
        if (project == null || !this.checkActionPermission(user, project, ProjectAction.VIEW_PROJECT)) {
            return new ProjectNotFoundResult(user, "admin.errors.project.not.found.for.id", String.valueOf(id));
        }
        if (!this.checkActionPermission(user, project, action)) {
            return new PermissionErrorResult(user, action);
        }
        return new ProjectService.GetProjectResult(project);
    }

    public ProjectService.GetProjectResult getProjectById(User user, Long id) {
        return this.getProjectByIdForAction(user, id, ProjectAction.VIEW_ISSUES);
    }

    public ProjectService.GetProjectResult getProjectByKey(User user, String key) {
        return this.getProjectByKeyForAction(user, key, ProjectAction.VIEW_ISSUES);
    }

    public ProjectService.GetProjectResult getProjectByKeyForAction(User user, String key, ProjectAction action) {
        Assertions.notNull((String)"action", (Object)action);
        Project project = this.projectManager.getProjectObjByKey(key);
        if (project == null || !this.checkActionPermission(user, project, ProjectAction.VIEW_PROJECT)) {
            return new ProjectNotFoundResult(user, "admin.errors.project.not.found.for.key", key);
        }
        if (!this.checkActionPermission(user, project, action)) {
            return new PermissionErrorResult(user, action);
        }
        return new ProjectService.GetProjectResult(project);
    }

    public int getMaximumNameLength() {
        String maxStr = this.applicationProperties.getDefaultBackedString("jira.projectname.maxlength");
        try {
            return Integer.parseInt(maxStr);
        }
        catch (NumberFormatException e) {
            log.error((Object)("Unable to read the MaximalProjectNameLength value '" + maxStr + "'.  Defaulting to " + 80 + "."));
            return 80;
        }
    }

    public int getMaximumKeyLength() {
        String maxStr = this.applicationProperties.getDefaultBackedString("jira.projectkey.maxlength");
        try {
            return Integer.parseInt(maxStr);
        }
        catch (NumberFormatException e) {
            log.error((Object)("Unable to read the MaximalProjectKeyLength value '" + maxStr + "'.  Defaulting to " + 10 + "."));
            return 10;
        }
    }

    public long getProjectCount() {
        return this.projectManager.getProjectCount();
    }

    public ServiceOutcome<List<Project>> getAllProjects(User user) {
        return this.getAllProjectsForAction(user, ProjectAction.VIEW_ISSUES);
    }

    public ServiceOutcome<List<Project>> getAllProjectsForAction(final User user, final ProjectAction action) {
        Iterable projects = Iterables.filter((Iterable)this.projectManager.getProjectObjects(), (Predicate)new Predicate<Project>(){

            public boolean apply(@Nullable Project input) {
                return input != null && DefaultProjectService.this.checkActionPermission(user, input, action);
            }
        });
        return new ServiceOutcomeImpl<List<Project>>((ErrorCollection)new SimpleErrorCollection(), Lists.newArrayList((Iterable)projects));
    }

    public ProjectService.DeleteProjectValidationResult validateDeleteProject(User user, String key) {
        SimpleErrorCollection errorCollection = new SimpleErrorCollection();
        I18nHelper i18nBean = this.getI18nBean(user);
        if (!this.permissionManager.hasPermission(0, user)) {
            errorCollection.addErrorMessage(i18nBean.getText("admin.projects.service.error.no.admin.permission"));
            return new ProjectService.DeleteProjectValidationResult((ErrorCollection)errorCollection);
        }
        ProjectService.GetProjectResult oldProjectResult = this.getProjectByKeyForAction(user, key, ProjectAction.EDIT_PROJECT_CONFIG);
        if (!oldProjectResult.isValid() || oldProjectResult.getProject() == null) {
            errorCollection.addErrorCollection(oldProjectResult.getErrorCollection());
            return new ProjectService.DeleteProjectValidationResult((ErrorCollection)errorCollection);
        }
        return new ProjectService.DeleteProjectValidationResult((ErrorCollection)errorCollection, oldProjectResult.getProject());
    }

    public ProjectService.DeleteProjectResult deleteProject(User user, ProjectService.DeleteProjectValidationResult result) {
        SimpleErrorCollection errorCollection = new SimpleErrorCollection();
        JiraServiceContext serviceContext = this.getServiceContext(user, (ErrorCollection)errorCollection);
        I18nHelper i18nBean = this.getI18nBean(user);
        if (result == null) {
            throw new IllegalArgumentException("You can not delete a project with a null validation result.");
        }
        if (!result.isValid()) {
            throw new IllegalStateException("You can not delete a project with an invalid validation result.");
        }
        Project project = result.getProject();
        try {
            this.projectManager.removeProjectIssues(project);
        }
        catch (RemoveException e) {
            errorCollection.addErrorMessage(i18nBean.getText("admin.errors.project.exception.removing", e.getMessage()));
            return new ProjectService.DeleteProjectResult((ErrorCollection)errorCollection);
        }
        this.customFieldManager.removeProjectAssociations(project);
        IssueTypeScreenScheme issueTypeScreenScheme = this.issueTypeScreenSchemeManager.getIssueTypeScreenScheme(project.getGenericValue());
        this.issueTypeScreenSchemeManager.removeSchemeAssociation(project.getGenericValue(), issueTypeScreenScheme);
        Scheme workflowScheme = this.workflowSchemeManager.getSchemeFor(project);
        Iterable workflowsAssociatedToProject = this.workflowManager.getWorkflowsFromScheme(workflowScheme);
        try {
            this.nodeAssociationStore.removeAssociationsFromSource(project.getGenericValue());
            List allVersions = this.versionManager.getVersions(project.getId());
            for (Version version : allVersions) {
                this.versionManager.deleteVersion(version);
            }
            Collection components = this.projectComponentManager.findAllForProject(project.getId());
            for (ProjectComponent component : components) {
                this.projectComponentManager.delete(component.getId());
            }
        }
        catch (DataAccessException e) {
            errorCollection.addErrorMessage(i18nBean.getText("admin.errors.project.exception.removing", e.getMessage()));
            return new ProjectService.DeleteProjectResult((ErrorCollection)errorCollection);
        }
        catch (EntityNotFoundException e) {
            errorCollection.addErrorMessage(i18nBean.getText("admin.errors.project.exception.removing", e.getMessage()));
            return new ProjectService.DeleteProjectResult((ErrorCollection)errorCollection);
        }
        this.sharePermissionDeleteUtils.deleteProjectSharePermissions(project.getId());
        this.workflowSchemeManager.cleanUpSchemeDraft(project, user);
        this.projectManager.removeProject(project);
        this.projectManager.refresh();
        this.workflowSchemeManager.clearWorkflowCache();
        this.workflowManager.copyAndDeleteDraftsForInactiveWorkflowsIn(user, workflowsAssociatedToProject);
        this.projectEventManager.dispatchProjectDeleted(ApplicationUsers.from((User)user), project);
        return new ProjectService.DeleteProjectResult((ErrorCollection)errorCollection);
    }

    private void validateProjectAssigneeType(Long assigneeType, ErrorCollection errorCollection, I18nHelper i18nHelper) {
        if (assigneeType != null && !ProjectAssigneeTypes.isValidType((Long)assigneeType)) {
            errorCollection.addErrorMessage(i18nHelper.getText("admin.errors.invalid.default.assignee"));
        }
    }

    private void validateAvatarId(Long avatarId, Project oldProject, ErrorCollection errorCollection, I18nHelper i18nHelper) {
        if (avatarId == null) {
            return;
        }
        Avatar avatar = this.avatarManager.getById(avatarId);
        if (avatar != null && !avatar.isSystemAvatar() && !oldProject.getId().toString().equals(avatar.getOwner())) {
            errorCollection.addErrorMessage(i18nHelper.getText("admin.errors.invalid.avatar"));
        }
    }

    private void validateProjectUrl(String url, ErrorCollection errorCollection, I18nHelper i18nBean) {
        if (TextUtils.stringSet((String)url)) {
            if (url.length() > 255) {
                errorCollection.addError("projectUrl", i18nBean.getText("admin.errors.project.url.too.long"));
            } else if (!TextUtils.verifyUrl((String)url)) {
                errorCollection.addError("projectUrl", i18nBean.getText("admin.errors.url.specified.is.not.valid"));
            }
        }
    }

    private void validateProjectKey(Project oldProject, String key, ErrorCollection errorCollection, I18nHelper i18nBean) {
        if (!this.isProjectKeyValid(key)) {
            String projectKeyWarning = this.applicationProperties.getDefaultBackedString("jira.projectkey.warning");
            if (TextUtils.stringSet((String)projectKeyWarning)) {
                errorCollection.addError("projectKey", i18nBean.getText(projectKeyWarning));
            } else {
                errorCollection.addError("projectKey", i18nBean.getText("admin.errors.must.specify.unique.project.key"));
            }
        } else if (this.isReservedKeyword(key)) {
            errorCollection.addError("projectKey", i18nBean.getText("admin.errors.project.keyword.invalid"));
        } else if (key.length() > this.getMaximumKeyLength()) {
            errorCollection.addError("projectKey", i18nBean.getText("admin.errors.project.key.too.long", (Object)this.getMaximumKeyLength()));
        } else {
            Project projectByNewKey = this.projectManager.getProjectObjByKey(key);
            if (projectByNewKey != null) {
                if (oldProject == null || !oldProject.getId().equals(projectByNewKey.getId())) {
                    errorCollection.addError("projectKey", i18nBean.getText("admin.errors.project.with.that.key.already.exists", projectByNewKey.getName()));
                }
            } else {
                Long projectId = this.projectKeyStore.getProjectId(key);
                if (projectId != null) {
                    errorCollection.addError("projectKey", i18nBean.getText("admin.errors.project.with.that.key.already.exists.unknown"));
                }
            }
        }
    }

    private void validateProjectLead(String leadName, ErrorCollection errorCollection, I18nHelper i18nBean) {
        if (!TextUtils.stringSet((String)leadName)) {
            errorCollection.addError("projectLead", i18nBean.getText("admin.errors.must.specify.project.lead"));
        } else if (!this.checkUserExists(leadName)) {
            errorCollection.addError("projectLead", i18nBean.getText("admin.errors.not.a.valid.user"));
        }
    }

    private void validateProjectName(String name, ErrorCollection errorCollection, I18nHelper i18nBean) {
        this.projectNameValidator.validateForCreate(name, errorCollection, i18nBean);
    }

    private void validateProjectNameForUpdate(String name, String key, ErrorCollection errorCollection, I18nHelper i18nBean) {
        this.projectNameValidator.validateForUpdate(name, key, errorCollection, i18nBean);
    }

    @Deprecated
    protected final I18nHelper getI18nBean(User user) {
        return this.i18nFactory.getInstance(user);
    }

    protected final I18nHelper getI18nBean(ApplicationUser user) {
        return this.i18nFactory.getInstance(user);
    }

    boolean checkUserExists(String leadName) {
        return this.userManager.getUserByName(leadName) != null;
    }

    boolean isReservedKeyword(String key) {
        return JiraKeyUtils.isReservedKeyword((String)key);
    }

    boolean isProjectKeyValid(String key) {
        return JiraKeyUtils.validProjectKey((String)key);
    }

    @Deprecated
    boolean checkActionPermission(User user, Project project, ProjectAction action) {
        return action.hasPermission(this.permissionManager, user, project);
    }

    boolean checkActionPermission(ApplicationUser user, Project project, ProjectAction action) {
        return action.hasPermission(this.permissionManager, user, project);
    }

    @Deprecated
    protected final ErrorCollection makeErrorCollection(User user, String i18nKey, ErrorCollection.Reason reason, String ... params) {
        SimpleErrorCollection errors = new SimpleErrorCollection();
        errors.addErrorMessage(this.getI18nBean(user).getText(i18nKey, (Object)params), reason);
        if (reason == ErrorCollection.Reason.FORBIDDEN && user == null) {
            errors.addErrorMessage(this.getI18nBean(user).getText("common.forms.ajax.unauthorised.alert"), ErrorCollection.Reason.NOT_LOGGED_IN);
        }
        return errors;
    }

    protected final ErrorCollection makeErrorCollection(ApplicationUser user, String i18nKey, ErrorCollection.Reason reason, String ... params) {
        SimpleErrorCollection errors = new SimpleErrorCollection();
        errors.addErrorMessage(this.getI18nBean(user).getText(i18nKey, (Object)params), reason);
        if (reason == ErrorCollection.Reason.FORBIDDEN && user == null) {
            errors.addErrorMessage(this.getI18nBean(user).getText("common.forms.ajax.unauthorised.alert"), ErrorCollection.Reason.NOT_LOGGED_IN);
        }
        return errors;
    }

    private Long effectiveAssigneeType(Long requestedAssigneeType) {
        if (requestedAssigneeType != null) {
            return requestedAssigneeType;
        }
        if (this.applicationProperties.getOption("jira.option.allowunassigned")) {
            return 3L;
        }
        return 2L;
    }

    private String keyFor(String username) {
        return ApplicationUsers.getKeyFor((ApplicationUser)this.userManager.getUserByName(username));
    }

    private String nameFor(ApplicationUser user) {
        return user != null ? user.getUsername() : null;
    }

    protected class PermissionErrorResult
    extends ProjectService.GetProjectResult {
        protected PermissionErrorResult(User user, ProjectAction action) {
            super(DefaultProjectService.this.makeErrorCollection(user, action.getErrorKey(), ErrorCollection.Reason.FORBIDDEN, new String[0]));
        }
    }

    protected class ProjectNotFoundResult
    extends ProjectService.GetProjectResult {
        protected ProjectNotFoundResult(User user, String i18nKey, String ... params) {
            super(DefaultProjectService.this.makeErrorCollection(user, i18nKey, ErrorCollection.Reason.NOT_FOUND, params));
        }
    }
}

