/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.bc.issue.comment.property;

import com.atlassian.fugue.Function2;
import com.atlassian.fugue.Option;
import com.atlassian.jira.entity.property.EntityProperty;
import com.atlassian.jira.entity.property.EntityPropertyHelper;
import com.atlassian.jira.entity.property.EntityPropertyType;
import com.atlassian.jira.event.issue.comment.property.CommentPropertyDeletedEvent;
import com.atlassian.jira.event.issue.comment.property.CommentPropertySetEvent;
import com.atlassian.jira.issue.comments.Comment;
import com.atlassian.jira.issue.comments.CommentManager;
import com.atlassian.jira.issue.comments.CommentPermissionManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.SimpleErrorCollection;
import com.google.common.base.Function;

public class CommentPropertyHelper
implements EntityPropertyHelper<Comment> {
    private final CommentPermissionManager commentPermissionManager;
    private final I18nHelper i18n;
    private final CommentManager commentManager;
    private final EntityPropertyHelper.CheckPermissionFunction<Comment> hasEditPermissionFunction = new EntityPropertyHelper.CheckPermissionFunction<Comment>(){

        public ErrorCollection apply(ApplicationUser applicationUser, Comment comment) {
            SimpleErrorCollection errorCollection = new SimpleErrorCollection();
            if (!CommentPropertyHelper.this.commentPermissionManager.hasEditPermission(applicationUser, comment)) {
                ErrorCollection.Reason reason = applicationUser == null ? ErrorCollection.Reason.NOT_LOGGED_IN : ErrorCollection.Reason.FORBIDDEN;
                errorCollection.addErrorMessage(CommentPropertyHelper.this.i18n.getText("comment.service.error.no.comment.visibility.no.user"), reason);
            }
            return errorCollection;
        }
    };
    private final EntityPropertyHelper.CheckPermissionFunction<Comment> hasReadPermissionFunction = new EntityPropertyHelper.CheckPermissionFunction<Comment>(){

        public ErrorCollection apply(ApplicationUser applicationUser, Comment comment) {
            SimpleErrorCollection errorCollection = new SimpleErrorCollection();
            if (!CommentPropertyHelper.this.commentPermissionManager.hasBrowsePermission(applicationUser, comment)) {
                ErrorCollection.Reason reason = applicationUser == null ? ErrorCollection.Reason.NOT_LOGGED_IN : ErrorCollection.Reason.FORBIDDEN;
                errorCollection.addErrorMessage(CommentPropertyHelper.this.i18n.getText("comment.service.error.no.edit.permission.no.user"), reason);
            }
            return errorCollection;
        }
    };
    private final Function<Long, Option<Comment>> entityByIdFunction = new Function<Long, Option<Comment>>(){

        public Option<Comment> apply(Long id) {
            return Option.option((Object)CommentPropertyHelper.this.commentManager.getCommentById(id));
        }
    };
    private final Function2<ApplicationUser, EntityProperty, CommentPropertySetEvent> setPropertyEventFunction = new Function2<ApplicationUser, EntityProperty, CommentPropertySetEvent>(){

        public CommentPropertySetEvent apply(ApplicationUser user, EntityProperty entityProperty) {
            return new CommentPropertySetEvent(entityProperty, user);
        }
    };
    private final Function2<ApplicationUser, EntityProperty, CommentPropertyDeletedEvent> deletePropertyEventFunction = new Function2<ApplicationUser, EntityProperty, CommentPropertyDeletedEvent>(){

        public CommentPropertyDeletedEvent apply(ApplicationUser user, EntityProperty entityProperty) {
            return new CommentPropertyDeletedEvent(entityProperty, user);
        }
    };

    public CommentPropertyHelper(CommentPermissionManager commentPermissionManager, I18nHelper i18n, CommentManager commentManager) {
        this.commentPermissionManager = commentPermissionManager;
        this.i18n = i18n;
        this.commentManager = commentManager;
    }

    public EntityPropertyHelper.CheckPermissionFunction<Comment> hasEditPermissionFunction() {
        return this.hasEditPermissionFunction;
    }

    public EntityPropertyHelper.CheckPermissionFunction<Comment> hasReadPermissionFunction() {
        return this.hasReadPermissionFunction;
    }

    public Function<Long, Option<Comment>> getEntityByIdFunction() {
        return this.entityByIdFunction;
    }

    public Function2<ApplicationUser, EntityProperty, CommentPropertySetEvent> createSetPropertyEventFunction() {
        return this.setPropertyEventFunction;
    }

    public Function2<ApplicationUser, EntityProperty, CommentPropertyDeletedEvent> createDeletePropertyEventFunction() {
        return this.deletePropertyEventFunction;
    }

    public EntityPropertyType getEntityPropertyType() {
        return EntityPropertyType.COMMENT_PROPERTY;
    }
}

