/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.bc.dataimport.ha;

import com.atlassian.event.api.EventListener;
import com.atlassian.jira.EventComponent;
import com.atlassian.jira.bc.dataimport.ImportCompletedEvent;
import com.atlassian.jira.bc.dataimport.ImportStartedEvent;
import com.atlassian.jira.bc.dataimport.ha.ClusterImportService;
import com.atlassian.jira.bc.dataimport.ha.RemoteImportCompletedEvent;
import com.atlassian.jira.cluster.Message;
import com.atlassian.jira.cluster.MessageHandler;
import com.atlassian.johnson.event.Event;
import com.atlassian.johnson.event.EventLevel;
import com.atlassian.johnson.event.EventType;

@EventComponent
public class ClusterImportListener {
    private final MessageHandler messageHandler;
    private final ClusterImportService clusterImportService;
    private final Event importEvent = new Event(EventType.get((String)"import"), "JIRA is currently being restored from backup", EventLevel.get((String)"warning"));

    public ClusterImportListener(MessageHandler messageHandler, ClusterImportService clusterImportService) {
        this.messageHandler = messageHandler;
        this.clusterImportService = clusterImportService;
    }

    @EventListener
    public void onImportStarted(ImportStartedEvent importStartedEvent) {
        this.messageHandler.sendMessage("ALL", Message.importStartedMessage());
    }

    @EventListener
    public void onImportCompleted(ImportCompletedEvent importCompletedEvent) {
        this.clusterImportService.prepareImport();
        this.messageHandler.sendMessage("ALL", Message.importFinishedMessage(importCompletedEvent.isImportSuccessful()));
    }

    @EventListener
    public void onRemoteImportCompleted(RemoteImportCompletedEvent remoteImportCompletedEvent) {
        if (remoteImportCompletedEvent.isImportSuccessful()) {
            this.clusterImportService.doImport();
        }
    }
}

