/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.bc.dataimport;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.ManagerFactory;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.event.ClearCacheEvent;
import com.atlassian.jira.mail.settings.MailSettings;
import com.atlassian.jira.plugin.scheduler.LifecycleAwarePluginScheduler;
import com.atlassian.jira.upgrade.ConsistencyCheckImpl;
import com.atlassian.jira.upgrade.ConsistencyChecker;
import com.atlassian.jira.upgrade.UpgradeManager;
import com.atlassian.jira.util.index.IndexLifecycleManager;
import com.atlassian.plugin.ModuleDescriptor;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.PluginController;
import com.atlassian.plugin.event.PluginEventManager;
import com.atlassian.plugin.manager.PluginPersistentState;
import com.atlassian.plugin.manager.PluginPersistentStateStore;
import com.atlassian.sal.api.scheduling.PluginScheduler;
import com.atlassian.sal.api.upgrade.PluginUpgradeManager;
import java.util.Collection;
import org.apache.log4j.Logger;
import org.quartz.Scheduler;

public class DataImportProductionDependencies {
    private static final Logger log = Logger.getLogger(DataImportProductionDependencies.class);

    IndexLifecycleManager getIndexLifecycleManager() {
        return (IndexLifecycleManager)ComponentAccessor.getComponentOfType(IndexLifecycleManager.class);
    }

    ConsistencyChecker getConsistencyChecker() {
        return new ConsistencyCheckImpl();
    }

    UpgradeManager getUpgradeManager() {
        return (UpgradeManager)ComponentAccessor.getComponentOfType(UpgradeManager.class);
    }

    Scheduler getScheduler() {
        return ComponentAccessor.getScheduler();
    }

    PluginEventManager getPluginEventManager() {
        return ComponentAccessor.getPluginEventManager();
    }

    PluginUpgradeManager getPluginUpgradeManager() {
        return (PluginUpgradeManager)ComponentAccessor.getOSGiComponentInstanceOfType(PluginUpgradeManager.class);
    }

    MailSettings getMailSettings() {
        return (MailSettings)ComponentAccessor.getComponent(MailSettings.class);
    }

    LifecycleAwarePluginScheduler getJiraPluginScheduler() {
        return (LifecycleAwarePluginScheduler)ComponentAccessor.getOSGiComponentInstanceOfType(PluginScheduler.class);
    }

    void globalRefresh(boolean quickImport) {
        if (quickImport) {
            log.warn((Object)"QuickImport is on, doing a fast refresh.");
            PluginPersistentStateStore pluginPersistentStateStore = (PluginPersistentStateStore)ComponentAccessor.getComponentOfType(PluginPersistentStateStore.class);
            PluginPersistentState oldState = pluginPersistentStateStore.load();
            ComponentAccessor.getApplicationProperties().refresh();
            ((EventPublisher)ComponentAccessor.getComponentOfType(EventPublisher.class)).publish((Object)ClearCacheEvent.INSTANCE);
            this.syncPluginStateWithNewData(pluginPersistentStateStore, oldState);
        } else {
            ManagerFactory.globalRefresh();
        }
    }

    private void syncPluginStateWithNewData(PluginPersistentStateStore pluginPersistentStateStore, PluginPersistentState oldState) {
        PluginPersistentState state = pluginPersistentStateStore.load();
        PluginAccessor pluginAccessor = ComponentAccessor.getPluginAccessor();
        PluginController pluginController = ComponentAccessor.getPluginController();
        Collection plugins = pluginAccessor.getPlugins();
        for (Plugin plugin : plugins) {
            boolean enabledInOldSystem = oldState.isEnabled(plugin);
            boolean enabledInNewSystem = state.isEnabled(plugin);
            if (!enabledInOldSystem && enabledInNewSystem) {
                pluginController.enablePlugins(new String[]{plugin.getKey()});
            } else if (enabledInOldSystem && !enabledInNewSystem) {
                pluginController.disablePlugin(plugin.getKey());
            }
            Collection moduleDescriptors = plugin.getModuleDescriptors();
            for (ModuleDescriptor moduleDescriptor : moduleDescriptors) {
                boolean moduleEnabledInOldSystem = oldState.isEnabled(moduleDescriptor);
                boolean moduleEnabledInNewSystem = state.isEnabled(moduleDescriptor);
                if (!moduleEnabledInOldSystem && moduleEnabledInNewSystem) {
                    pluginController.enablePluginModule(moduleDescriptor.getCompleteKey());
                    continue;
                }
                if (!moduleEnabledInOldSystem || moduleEnabledInNewSystem) continue;
                pluginController.disablePluginModule(moduleDescriptor.getCompleteKey());
            }
        }
    }

    void refreshSequencer() {
        ComponentAccessor.getOfBizDelegator().refreshSequencer();
    }
}

