/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.bc.config;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.bc.ServiceOutcome;
import com.atlassian.jira.bc.ServiceOutcomeImpl;
import com.atlassian.jira.bc.config.ConstantsService;
import com.atlassian.jira.config.ConstantsManager;
import com.atlassian.jira.config.StatusCategoryManager;
import com.atlassian.jira.issue.fields.config.manager.IssueTypeSchemeManager;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.issue.status.Status;
import com.atlassian.jira.issue.status.category.StatusCategory;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.workflow.JiraWorkflow;
import com.atlassian.jira.workflow.WorkflowManager;
import com.atlassian.jira.workflow.WorkflowSchemeManager;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.opensymphony.workflow.loader.StepDescriptor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;

public class DefaultConstantsService
implements ConstantsService {
    private final I18nHelper.BeanFactory i18n;
    private final ConstantsManager constantsMgr;
    private final PermissionManager permissionMgr;
    private final WorkflowSchemeManager workflowSchemeMgr;
    private final WorkflowManager workflowMgr;
    private final IssueTypeSchemeManager issueTypeSchemeMgr;
    private final StatusCategoryManager statusCategoryManager;

    public DefaultConstantsService(I18nHelper.BeanFactory i18n, ConstantsManager constantsManager, PermissionManager permissionManager, WorkflowSchemeManager workflowSchemeMgr, WorkflowManager workflowMgr, IssueTypeSchemeManager issueTypeSchemeMgr, StatusCategoryManager statusCategoryManager) {
        this.constantsMgr = constantsManager;
        this.permissionMgr = permissionManager;
        this.workflowSchemeMgr = workflowSchemeMgr;
        this.workflowMgr = workflowMgr;
        this.i18n = i18n;
        this.issueTypeSchemeMgr = issueTypeSchemeMgr;
        this.statusCategoryManager = statusCategoryManager;
    }

    public ServiceOutcome<Status> getStatusById(User user, String statusId) {
        Status status = this.constantsMgr.getStatusObject(statusId);
        if (status != null && this.isStatusVisible(user, status)) {
            return ServiceOutcomeImpl.ok(status);
        }
        return ServiceOutcomeImpl.error(this.i18n.getInstance(user).getText("constants.service.status.not.found", statusId));
    }

    public ServiceOutcome<Status> getStatusByName(User user, String statusName) {
        Status status = this.constantsMgr.getStatusByName(statusName);
        if (status != null && this.isStatusVisible(user, status)) {
            return ServiceOutcomeImpl.ok(status);
        }
        return ServiceOutcomeImpl.error(this.i18n.getInstance(user).getText("constants.service.status.not.found", statusName));
    }

    public ServiceOutcome<Status> getStatusByTranslatedName(User user, String statusName) {
        Status status = this.constantsMgr.getStatusByTranslatedName(statusName);
        if (status != null && this.isStatusVisible(user, status)) {
            return ServiceOutcomeImpl.ok(status);
        }
        return ServiceOutcomeImpl.error(this.i18n.getInstance(user).getText("constants.service.status.not.found", statusName));
    }

    private boolean isStatusVisible(User user, Status status) {
        return new IsStatusVisible(user, this.permissionMgr, this.workflowMgr, this.workflowSchemeMgr).apply(status);
    }

    public ServiceOutcome<Collection<Status>> getAllStatuses(User user) {
        return ServiceOutcomeImpl.ok(Collections2.filter((Collection)this.constantsMgr.getStatusObjects(), (Predicate)new IsStatusVisible(user, this.permissionMgr, this.workflowMgr, this.workflowSchemeMgr)));
    }

    public ServiceOutcome<Collection<IssueType>> getAllIssueTypes(User user) {
        HashSet<IssueType> visibleIssueTypes = new HashSet<IssueType>();
        Collection visibleProjects = this.permissionMgr.getProjectObjects(10, user);
        for (Project project : visibleProjects) {
            for (IssueType visibleType : this.issueTypeSchemeMgr.getIssueTypesForProject(project)) {
                visibleIssueTypes.add(visibleType);
            }
        }
        return ServiceOutcomeImpl.ok(visibleIssueTypes);
    }

    public ServiceOutcome<IssueType> getIssueTypeById(User user, String issueTypeId) {
        IssueType issueType = this.constantsMgr.getIssueTypeObject(issueTypeId);
        if (issueType != null) {
            Collection visibleProjects = this.permissionMgr.getProjectObjects(10, user);
            for (Project project : visibleProjects) {
                for (IssueType visibleType : this.issueTypeSchemeMgr.getIssueTypesForProject(project)) {
                    if (!issueTypeId.equals(visibleType.getId())) continue;
                    return ServiceOutcomeImpl.ok(issueType);
                }
            }
        }
        return ServiceOutcomeImpl.error(this.i18n.getInstance(user).getText("constants.service.issuetype.not.found", issueTypeId));
    }

    public ServiceOutcome<Collection<StatusCategory>> getAllStatusCategories(User user) {
        if (!this.isStatusAsLozengeEnabled()) {
            return ServiceOutcomeImpl.error(this.i18n.getInstance(user).getText("constants.service.status.category.not.found.any"));
        }
        return ServiceOutcomeImpl.ok(this.statusCategoryManager.getStatusCategories());
    }

    public ServiceOutcome<Collection<StatusCategory>> getUserVisibleStatusCategories(User user) {
        if (!this.isStatusAsLozengeEnabled()) {
            return ServiceOutcomeImpl.error(this.i18n.getInstance(user).getText("constants.service.status.category.not.found.any"));
        }
        return ServiceOutcomeImpl.ok(this.statusCategoryManager.getUserVisibleStatusCategories());
    }

    public ServiceOutcome<StatusCategory> getStatusCategoryById(User user, String id) {
        Long longId;
        if (!this.isStatusAsLozengeEnabled()) {
            return ServiceOutcomeImpl.error(this.i18n.getInstance(user).getText("constants.service.status.category.not.found.id", id));
        }
        try {
            longId = Long.parseLong(id);
        }
        catch (NumberFormatException e) {
            return ServiceOutcomeImpl.error(this.i18n.getInstance(user).getText("constants.service.status.category.not.found.id", id));
        }
        StatusCategory statusCategory = this.statusCategoryManager.getStatusCategory(longId);
        if (statusCategory != null) {
            return ServiceOutcomeImpl.ok(statusCategory);
        }
        return ServiceOutcomeImpl.error(this.i18n.getInstance(user).getText("constants.service.status.category.not.found.id", id));
    }

    public ServiceOutcome<StatusCategory> getStatusCategoryByKey(User user, String key) {
        if (!this.isStatusAsLozengeEnabled()) {
            return ServiceOutcomeImpl.error(this.i18n.getInstance(user).getText("constants.service.status.category.not.found.key", key));
        }
        StatusCategory statusCategory = this.statusCategoryManager.getStatusCategoryByKey(key);
        if (statusCategory != null) {
            return ServiceOutcomeImpl.ok(statusCategory);
        }
        return ServiceOutcomeImpl.error(this.i18n.getInstance(user).getText("constants.service.status.category.not.found.key", key));
    }

    public ServiceOutcome<StatusCategory> getDefaultStatusCategory(User user) {
        StatusCategory statusCategory = this.statusCategoryManager.getDefaultStatusCategory();
        if (statusCategory != null) {
            return ServiceOutcomeImpl.ok(statusCategory);
        }
        return ServiceOutcomeImpl.error(this.i18n.getInstance(user).getText("constants.service.status.category.not.found.default"));
    }

    public boolean isStatusAsLozengeEnabled() {
        return this.statusCategoryManager.isStatusAsLozengeEnabled();
    }

    static class IsStatusVisible
    implements Predicate<Status> {
        final Set<String> seenStatusIds = new HashSet<String>();
        final HashSet<String> seenWorkflowNames = new HashSet();
        final LinkedList<String> pendingWorkflowNames = new LinkedList();
        final Iterator<Project> projects;
        private final PermissionManager permissionManager;
        private final WorkflowManager workflowManager;
        private final WorkflowFetcher workflowFetcher;

        IsStatusVisible(User user, PermissionManager permissionManager, WorkflowManager workflowManager, final WorkflowSchemeManager workflowSchemeManager) {
            this(user, permissionManager, workflowManager, new WorkflowFetcher(){

                @Override
                public List<String> getWorkflowNames(Project project) {
                    try {
                        GenericValue workflowScheme = workflowSchemeManager.getWorkflowScheme(project.getGenericValue());
                        if (workflowScheme == null) {
                            return Collections.singletonList("jira");
                        }
                        ArrayList<String> workflowNames = new ArrayList<String>(128);
                        GenericValue defaultEntity = workflowSchemeManager.getDefaultEntity(workflowScheme);
                        if (defaultEntity != null) {
                            workflowNames.add(defaultEntity.getString("workflow"));
                        }
                        for (GenericValue entity : workflowSchemeManager.getNonDefaultEntities(workflowScheme)) {
                            workflowNames.add(entity.getString("workflow"));
                        }
                        return workflowNames;
                    }
                    catch (GenericEntityException e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        IsStatusVisible(User user, PermissionManager permissionManager, WorkflowManager workflowManager, WorkflowFetcher workflowFetcher) {
            this.permissionManager = permissionManager;
            this.workflowManager = workflowManager;
            this.projects = this.permissionManager.getProjectObjects(10, user).iterator();
            this.workflowFetcher = workflowFetcher;
        }

        public boolean apply(Status input) {
            do {
                if (!this.seenStatusIds.contains(input.getId())) continue;
                return true;
            } while (this.findMoreStatuses());
            return false;
        }

        private boolean findMoreStatuses() {
            boolean changed = false;
            while (!changed && this.hasMoreWorkflows()) {
                JiraWorkflow workflow = this.workflowManager.getWorkflow(this.pendingWorkflowNames.removeFirst());
                List steps = workflow.getDescriptor().getSteps();
                for (StepDescriptor step : steps) {
                    String linkedStatusId = (String)step.getMetaAttributes().get("jira.status.id");
                    changed |= this.seenStatusIds.add(linkedStatusId);
                }
            }
            return changed;
        }

        private boolean hasMoreWorkflows() {
            while (this.pendingWorkflowNames.isEmpty()) {
                if (!this.projects.hasNext()) {
                    return false;
                }
                for (String workflowName : this.workflowFetcher.getWorkflowNames(this.projects.next())) {
                    if (!this.seenWorkflowNames.add(workflowName)) continue;
                    this.pendingWorkflowNames.addLast(workflowName);
                }
            }
            return true;
        }

        static interface WorkflowFetcher {
            public List<String> getWorkflowNames(Project var1);
        }
    }
}

