/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.bc.admin;

import com.atlassian.core.util.StringUtils;
import com.atlassian.jira.issue.link.LinkCollectionImpl;
import com.atlassian.validation.Failure;
import com.atlassian.validation.Success;
import com.atlassian.validation.Validator;
import com.google.common.base.Supplier;
import java.util.ArrayList;
import java.util.Collection;

public final class LinkSortFieldListValidator
implements Validator {
    private Supplier<Collection<String>> linkSortFields;

    public LinkSortFieldListValidator() {
        this(new Supplier<Collection<String>>(){

            public Collection<String> get() {
                return LinkCollectionImpl.getSortableFields();
            }
        });
    }

    LinkSortFieldListValidator(Supplier<Collection<String>> linkSortFields) {
        this.linkSortFields = linkSortFields;
    }

    @Override
    public Validator.Result validate(String value) {
        String[] fields = value.split(",");
        ArrayList<String> badFields = new ArrayList<String>();
        Collection allowableFields = (Collection)this.linkSortFields.get();
        for (String f : fields) {
            String field = f.trim();
            if (allowableFields.contains(field)) continue;
            badFields.add(field);
        }
        if (badFields.isEmpty()) {
            return new Success(value);
        }
        String csv = StringUtils.createCommaSeperatedString((Iterable)allowableFields);
        return new Failure("Only the following fields are allowed: " + csv);
    }
}

