/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.bc.admin;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.bc.admin.ApplicationPropertiesService;
import com.atlassian.jira.bc.admin.ApplicationProperty;
import com.atlassian.jira.bc.admin.ApplicationPropertyMetadata;
import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.config.properties.ApplicationPropertiesStore;
import com.atlassian.jira.event.config.ApplicationPropertyChangeEvent;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.validation.Validated;
import com.atlassian.validation.Validator;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.log4j.Logger;

public class ApplicationPropertiesServiceImpl
implements ApplicationPropertiesService {
    private static final Logger log = Logger.getLogger(ApplicationPropertiesServiceImpl.class);
    private final ApplicationPropertiesStore applicationPropertiesStore;
    private EventPublisher eventPublisher;
    private PermissionManager permissionManager;
    private JiraAuthenticationContext authenticationContext;
    private final Predicate<ApplicationProperty> featurePredicate;
    private FeatureManager featureManager;

    public ApplicationPropertiesServiceImpl(ApplicationPropertiesStore applicationPropertiesStore, EventPublisher eventPublisher, PermissionManager permissionManager, JiraAuthenticationContext authenticationContext, FeatureManager featureManager) {
        this.applicationPropertiesStore = applicationPropertiesStore;
        this.eventPublisher = eventPublisher;
        this.permissionManager = permissionManager;
        this.authenticationContext = authenticationContext;
        this.featureManager = featureManager;
        this.featurePredicate = new Predicate<ApplicationProperty>(){

            public boolean apply(@Nullable ApplicationProperty input) {
                if (input.getMetadata().getRequiredFeatureKey() == null) {
                    return true;
                }
                if (((Boolean)input.getMetadata().getRequiredFeatureKey().second()).booleanValue()) {
                    return ApplicationPropertiesServiceImpl.this.featureManager.isEnabled((String)input.getMetadata().getRequiredFeatureKey().first());
                }
                return !ApplicationPropertiesServiceImpl.this.featureManager.isEnabled((String)input.getMetadata().getRequiredFeatureKey().first());
            }
        };
    }

    @Override
    public List<ApplicationProperty> getEditableApplicationProperties(String permissionLevel, String keyFilter) {
        if (permissionLevel == null || permissionLevel.isEmpty()) {
            if (this.permissionManager.hasPermission(44, this.authenticationContext.getUser())) {
                return this.getEditableApplicationProperties(ApplicationPropertiesService.EditPermissionLevel.SYSADMIN, keyFilter);
            }
            if (this.permissionManager.hasPermission(0, this.authenticationContext.getUser())) {
                return this.getEditableApplicationProperties(ApplicationPropertiesService.EditPermissionLevel.ADMIN, keyFilter);
            }
            return null;
        }
        ApplicationPropertiesService.EditPermissionLevel editPermission = null;
        try {
            editPermission = ApplicationPropertiesService.EditPermissionLevel.valueOf(permissionLevel.toUpperCase());
        }
        catch (IllegalArgumentException iae) {
            return null;
        }
        return this.getEditableApplicationProperties(editPermission, keyFilter);
    }

    @Override
    public boolean hasPermissionForLevel(String permissionLevel) {
        if (permissionLevel == null || permissionLevel.isEmpty()) {
            return this.permissionManager.hasPermission(44, this.authenticationContext.getUser()) || this.permissionManager.hasPermission(0, this.authenticationContext.getUser());
        }
        ApplicationPropertiesService.EditPermissionLevel editPermission = null;
        try {
            editPermission = ApplicationPropertiesService.EditPermissionLevel.valueOf(permissionLevel.toUpperCase());
        }
        catch (IllegalArgumentException iae) {
            return false;
        }
        if (editPermission == ApplicationPropertiesService.EditPermissionLevel.SYSADMIN || editPermission == ApplicationPropertiesService.EditPermissionLevel.SYSADMIN_ONLY) {
            return this.permissionManager.hasPermission(44, this.authenticationContext.getUser());
        }
        if (editPermission == ApplicationPropertiesService.EditPermissionLevel.ADMIN) {
            return this.permissionManager.hasPermission(0, this.authenticationContext.getUser()) || this.permissionManager.hasPermission(44, this.authenticationContext.getUser());
        }
        return false;
    }

    @Override
    public List<ApplicationProperty> getEditableApplicationProperties(ApplicationPropertiesService.EditPermissionLevel permissionLevel, String keyFilter) throws DataAccessException {
        return Lists.newArrayList((Iterable)Iterables.filter(this.applicationPropertiesStore.getEditableApplicationProperties(permissionLevel, keyFilter), this.featurePredicate));
    }

    @Override
    public ApplicationProperty getApplicationProperty(String key) {
        return this.applicationPropertiesStore.getApplicationPropertyFromKey(key);
    }

    @Override
    public Validated<ApplicationProperty> setApplicationProperty(String key, String value) {
        ApplicationProperty applicationProperty = this.applicationPropertiesStore.getApplicationPropertyFromKey(key);
        String oldValue = applicationProperty.getCurrentValue();
        log.debug((Object)("validating value: " + value));
        ApplicationPropertyMetadata metadata = applicationProperty.getMetadata();
        Validator.Result result = metadata.validate(value);
        if (result.isValid()) {
            applicationProperty = this.applicationPropertiesStore.setApplicationProperty(key, value);
            this.eventPublisher.publish((Object)this.createEvent(metadata, oldValue, value));
        }
        return new Validated<ApplicationProperty>(result, applicationProperty);
    }

    protected ApplicationPropertyChangeEvent createEvent(ApplicationPropertyMetadata metadata, String oldValue, String newValue) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("metadata", Assertions.notNull((String)"metadata", (Object)metadata));
        params.put("oldValue", oldValue);
        params.put("newValue", newValue);
        return new ApplicationPropertyChangeEvent(params);
    }
}

