/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.auditing.handlers;

import com.atlassian.crowd.event.user.AutoUserUpdatedEvent;
import com.atlassian.crowd.event.user.ResetPasswordEvent;
import com.atlassian.crowd.event.user.UserAttributeDeletedEvent;
import com.atlassian.crowd.event.user.UserAttributeStoredEvent;
import com.atlassian.crowd.event.user.UserCreatedEvent;
import com.atlassian.crowd.event.user.UserCredentialUpdatedEvent;
import com.atlassian.crowd.event.user.UserDeletedEvent;
import com.atlassian.crowd.event.user.UserEditedEvent;
import com.atlassian.crowd.event.user.UserRenamedEvent;
import com.atlassian.crowd.event.user.UserUpdatedEvent;
import com.atlassian.crowd.model.user.User;
import com.atlassian.fugue.Option;
import com.atlassian.jira.auditing.AffectedUser;
import com.atlassian.jira.auditing.AssociatedItem;
import com.atlassian.jira.auditing.AuditingCategory;
import com.atlassian.jira.auditing.ChangedValue;
import com.atlassian.jira.auditing.RecordRequest;
import com.atlassian.jira.auditing.handlers.ChangedValuesBuilder;
import com.atlassian.jira.auditing.handlers.HandlerUtils;
import com.atlassian.jira.auditing.handlers.UserEventHandler;
import com.atlassian.jira.component.ComponentAccessor;
import com.google.common.base.Function;
import java.util.List;

public class UserEventHandlerImpl
implements UserEventHandler {
    @Override
    public Option<RecordRequest> handleUserUpdatedEvent(UserUpdatedEvent event) {
        if (event instanceof AutoUserUpdatedEvent) {
            return this.onAutoUserUpdatedEvent((AutoUserUpdatedEvent)event);
        }
        if (event instanceof ResetPasswordEvent) {
            return Option.option((Object)this.onResetPasswordEvent((ResetPasswordEvent)event));
        }
        if (event instanceof UserRenamedEvent) {
            return Option.option((Object)this.onUserRenamedEvent((UserRenamedEvent)event));
        }
        if (event instanceof UserAttributeStoredEvent || event instanceof UserAttributeDeletedEvent) {
            return Option.none();
        }
        if (event instanceof UserEditedEvent) {
            return this.onUserEditedEvent((UserEditedEvent)event);
        }
        throw new RuntimeException("Unsupported event: " + event.getClass().getName());
    }

    private Option<RecordRequest> onAutoUserUpdatedEvent(AutoUserUpdatedEvent event) {
        return this.userUpdated(event.getOriginalUser(), event.getUser());
    }

    private Option<RecordRequest> onUserEditedEvent(UserEditedEvent event) {
        return this.userUpdated(event.getOriginalUser(), event.getUser());
    }

    private Option<RecordRequest> userUpdated(User originalUser, final User user) {
        return HandlerUtils.requestIfThereAreAnyValues(this.buildChangedValues(originalUser, user), new Function<List<ChangedValue>, RecordRequest>(){

            public RecordRequest apply(List<ChangedValue> changedValues) {
                return new RecordRequest(AuditingCategory.USER_MANAGEMENT, "jira.auditing.user.updated").withChangedValues(changedValues).forObject((AssociatedItem)new AffectedUser(user));
            }
        });
    }

    private RecordRequest onResetPasswordEvent(ResetPasswordEvent event) {
        return new RecordRequest(AuditingCategory.USER_MANAGEMENT, "jira.auditing.user.password.reset").forObject((AssociatedItem)new AffectedUser(event.getUser()));
    }

    private RecordRequest onUserRenamedEvent(UserRenamedEvent event) {
        return new RecordRequest(AuditingCategory.USER_MANAGEMENT, "jira.auditing.user.renamed").withChangedValues(new ChangedValuesBuilder().addIfDifferent("common.words.username", event.getOldUsername(), event.getUser().getName()).build()).forObject((AssociatedItem)new AffectedUser(event.getUser()));
    }

    private List<ChangedValue> buildChangedValues(User originalUser, User currentUser) {
        ChangedValuesBuilder changedValues = new ChangedValuesBuilder();
        changedValues.addIfDifferent("common.words.username", originalUser == null ? null : originalUser.getName(), currentUser.getName()).addIfDifferent("common.words.fullname", originalUser == null ? null : originalUser.getDisplayName(), currentUser.getDisplayName()).addIfDifferent("common.words.email", originalUser == null ? null : originalUser.getEmailAddress(), currentUser.getEmailAddress()).addIfDifferent("admin.common.phrases.active.inactive", originalUser == null ? null : this.stringBooleanToActiveInactive(originalUser.isActive()), this.stringBooleanToActiveInactive(currentUser.isActive()));
        return changedValues.build();
    }

    private String stringBooleanToActiveInactive(Boolean tBoolean) {
        if (tBoolean == null) {
            return "";
        }
        return tBoolean.equals(Boolean.TRUE) ? "Active" : "Inactive";
    }

    @Override
    public RecordRequest handleUserCreatedEvent(UserCreatedEvent event) {
        User user = event.getUser();
        return new RecordRequest(AuditingCategory.USER_MANAGEMENT, "jira.auditing.user.created").withChangedValues(this.buildChangedValues(user)).forObject((AssociatedItem)new AffectedUser(user));
    }

    @Override
    public RecordRequest handleUserDeletedEvent(UserDeletedEvent event) {
        String userKey = ComponentAccessor.getUserKeyService().getKeyForUsername(event.getUsername());
        return new RecordRequest(AuditingCategory.USER_MANAGEMENT, "jira.auditing.user.deleted").forObject((AssociatedItem)new AffectedUser(event.getUsername(), userKey, event.getDirectory()));
    }

    @Override
    public RecordRequest handleUserCredentialUpdatedEvent(UserCredentialUpdatedEvent event) {
        String userKey = ComponentAccessor.getUserKeyService().getKeyForUsername(event.getUsername());
        return new RecordRequest(AuditingCategory.USER_MANAGEMENT, "jira.auditing.user.password.changed").forObject((AssociatedItem)new AffectedUser(event.getUsername(), userKey, event.getDirectory()));
    }

    private List<ChangedValue> buildChangedValues(User currentUser) {
        return this.buildChangedValues(null, currentUser);
    }
}

