/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.auditing.handlers;

import com.atlassian.jira.auditing.AffectedScheme;
import com.atlassian.jira.auditing.AssociatedItem;
import com.atlassian.jira.auditing.AuditingCategory;
import com.atlassian.jira.auditing.ChangedValue;
import com.atlassian.jira.auditing.RecordRequest;
import com.atlassian.jira.auditing.handlers.ChangedValuesBuilder;
import com.atlassian.jira.auditing.handlers.SchemeEventHandler;
import com.atlassian.jira.event.fields.layout.FieldLayoutSchemeAddedToProjectEvent;
import com.atlassian.jira.event.fields.layout.FieldLayoutSchemeCopiedEvent;
import com.atlassian.jira.event.fields.layout.FieldLayoutSchemeCreatedEvent;
import com.atlassian.jira.event.fields.layout.FieldLayoutSchemeDeletedEvent;
import com.atlassian.jira.event.fields.layout.FieldLayoutSchemeRemovedFromProjectEvent;
import com.atlassian.jira.event.fields.layout.FieldLayoutSchemeUpdatedEvent;
import com.atlassian.jira.event.notification.NotificationSchemeDeletedEvent;
import com.atlassian.jira.event.permission.PermissionSchemeDeletedEvent;
import com.atlassian.jira.event.scheme.AbstractSchemeAddedToProjectEvent;
import com.atlassian.jira.event.scheme.AbstractSchemeCopiedEvent;
import com.atlassian.jira.event.scheme.AbstractSchemeEvent;
import com.atlassian.jira.event.scheme.AbstractSchemeRemovedFromProjectEvent;
import com.atlassian.jira.event.scheme.AbstractSchemeUpdatedEvent;
import com.atlassian.jira.event.workflow.WorkflowSchemeDeletedEvent;
import com.atlassian.jira.util.NamedWithDescription;
import com.atlassian.jira.util.NamedWithId;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.List;

public class SchemeEventHandlerImpl
implements SchemeEventHandler {
    private final ImmutableMap<String, SchemeDetail> schemeDetails = ImmutableMap.builder().put((Object)"WorkflowScheme", (Object)SchemeDetail.WORKFLOW).put((Object)"PermissionScheme", (Object)SchemeDetail.PERMISSION).put((Object)"NotificationScheme", (Object)SchemeDetail.NOTIFICATION).put((Object)"IssueSecurityScheme", (Object)SchemeDetail.ISSUE_SECURITY).build();

    @Override
    public RecordRequest onSchemeCreatedEvent(AbstractSchemeEvent event) {
        Preconditions.checkNotNull((Object)event.getScheme());
        SchemeDetail scheme = (SchemeDetail)((Object)this.schemeDetails.get((Object)event.getScheme().getType()));
        Preconditions.checkNotNull((Object)((Object)scheme));
        return new RecordRequest(scheme.category, scheme.createdSummary).forObject(AssociatedItem.Type.SCHEME, event.getScheme().getName(), Long.toString(event.getId())).withChangedValues(SchemeEventHandlerImpl.computeChangedValues((NamedWithDescription)event.getScheme()));
    }

    @Override
    public RecordRequest onSchemeCopiedEvent(AbstractSchemeCopiedEvent event) {
        Preconditions.checkNotNull((Object)event.getScheme());
        SchemeDetail scheme = (SchemeDetail)((Object)this.schemeDetails.get((Object)event.getScheme().getType()));
        Preconditions.checkNotNull((Object)((Object)scheme));
        return new RecordRequest(scheme.category, scheme.copiedSummary).forObject(AssociatedItem.Type.SCHEME, event.getScheme().getName(), Long.toString(event.getId())).thatAffects(new AssociatedItem[]{new AffectedScheme((NamedWithId)event.getFromScheme())}).withChangedValues(SchemeEventHandlerImpl.computeChangedValues((NamedWithDescription)event.getScheme()));
    }

    @Override
    public RecordRequest onSchemeCopiedEvent(FieldLayoutSchemeCopiedEvent event) {
        Preconditions.checkNotNull((Object)event.getScheme());
        SchemeDetail scheme = SchemeDetail.FIELDS;
        return new RecordRequest(scheme.category, scheme.copiedSummary).forObject(AssociatedItem.Type.SCHEME, event.getScheme().getName(), Long.toString(event.getScheme().getId())).thatAffects(new AssociatedItem[]{new AffectedScheme((NamedWithId)event.getFromScheme())}).withChangedValues(SchemeEventHandlerImpl.computeChangedValues((NamedWithDescription)event.getScheme()));
    }

    @Override
    public RecordRequest onSchemeDeletedEvent(PermissionSchemeDeletedEvent event) {
        return new RecordRequest(AuditingCategory.PERMISSIONS, "jira.auditing.permission.scheme.deleted").forObject(AssociatedItem.Type.SCHEME, event.getName(), Long.toString(event.getId()));
    }

    @Override
    public RecordRequest onSchemeDeletedEvent(WorkflowSchemeDeletedEvent event) {
        return new RecordRequest(AuditingCategory.WORKFLOWS, "jira.auditing.workflow.scheme.deleted").forObject(AssociatedItem.Type.SCHEME, event.getName(), Long.toString(event.getId()));
    }

    @Override
    public RecordRequest onSchemeDeletedEvent(NotificationSchemeDeletedEvent event) {
        return new RecordRequest(AuditingCategory.NOTIFICATIONS, "jira.auditing.notification.scheme.deleted").forObject(AssociatedItem.Type.SCHEME, event.getName(), Long.toString(event.getId()));
    }

    @Override
    public RecordRequest onSchemeCreatedEvent(FieldLayoutSchemeCreatedEvent event) {
        Preconditions.checkNotNull((Object)event.getScheme());
        SchemeDetail scheme = SchemeDetail.FIELDS;
        return new RecordRequest(scheme.category, scheme.createdSummary).forObject(AssociatedItem.Type.SCHEME, event.getScheme().getName(), Long.toString(event.getScheme().getId())).withChangedValues(SchemeEventHandlerImpl.computeChangedValues((NamedWithDescription)event.getScheme()));
    }

    @Override
    public RecordRequest onSchemeUpdatedEvent(FieldLayoutSchemeUpdatedEvent event) {
        Preconditions.checkNotNull((Object)event.getScheme());
        SchemeDetail scheme = SchemeDetail.FIELDS;
        return new RecordRequest(scheme.category, scheme.updatedSummary).forObject(AssociatedItem.Type.SCHEME, event.getScheme().getName(), Long.toString(event.getScheme().getId())).withChangedValues(SchemeEventHandlerImpl.computeChangedValues((NamedWithDescription)event.getOriginalScheme(), (NamedWithDescription)event.getScheme()));
    }

    @Override
    public RecordRequest onSchemeDeletedEvent(FieldLayoutSchemeDeletedEvent event) {
        return new RecordRequest(AuditingCategory.FIELDS, "jira.auditing.field.layout.scheme.deleted").forObject(AssociatedItem.Type.SCHEME, event.getName(), Long.toString(event.getId()));
    }

    @Override
    public RecordRequest onSchemeAddedToProject(FieldLayoutSchemeAddedToProjectEvent event) {
        Preconditions.checkNotNull((Object)event.getScheme());
        SchemeDetail details = SchemeDetail.FIELDS;
        return new RecordRequest(details.category, details.addedToProject).forObject(AssociatedItem.Type.PROJECT, event.getProjectName(), event.getProjectId().toString()).thatAffects(new AssociatedItem[]{new AffectedScheme((NamedWithId)event.getScheme())});
    }

    @Override
    public RecordRequest onSchemeRemovedFromProject(FieldLayoutSchemeRemovedFromProjectEvent event) {
        Preconditions.checkNotNull((Object)event.getScheme());
        SchemeDetail details = SchemeDetail.FIELDS;
        return new RecordRequest(details.category, details.removedFromProject).forObject(AssociatedItem.Type.PROJECT, event.getProjectName(), event.getProjectId().toString()).thatAffects(new AssociatedItem[]{new AffectedScheme((NamedWithId)event.getScheme())});
    }

    @Override
    public RecordRequest onSchemeUpdatedEvent(AbstractSchemeUpdatedEvent event) {
        Preconditions.checkNotNull((Object)event.getScheme());
        SchemeDetail scheme = (SchemeDetail)((Object)this.schemeDetails.get((Object)event.getScheme().getType()));
        Preconditions.checkNotNull((Object)((Object)scheme));
        return new RecordRequest(scheme.category, scheme.updatedSummary).forObject(AssociatedItem.Type.SCHEME, event.getScheme().getName(), Long.toString(event.getId())).withChangedValues(SchemeEventHandlerImpl.computeChangedValues((NamedWithDescription)event.getOriginalScheme(), (NamedWithDescription)event.getScheme()));
    }

    @Override
    public RecordRequest onSchemeAddedToProject(AbstractSchemeAddedToProjectEvent event) {
        Preconditions.checkNotNull((Object)event.getScheme());
        SchemeDetail details = (SchemeDetail)((Object)this.schemeDetails.get((Object)event.getScheme().getType()));
        Preconditions.checkNotNull((Object)((Object)details));
        return new RecordRequest(details.category, details.addedToProject).forObject(AssociatedItem.Type.PROJECT, event.getProjectName(), event.getProjectId().toString()).thatAffects(new AssociatedItem[]{new AffectedScheme((NamedWithId)event.getScheme())});
    }

    @Override
    public RecordRequest onSchemeRemovedFromProject(AbstractSchemeRemovedFromProjectEvent event) {
        Preconditions.checkNotNull((Object)event.getScheme());
        SchemeDetail details = (SchemeDetail)((Object)this.schemeDetails.get((Object)event.getScheme().getType()));
        Preconditions.checkNotNull((Object)((Object)details));
        return new RecordRequest(details.category, details.removedFromProject).forObject(AssociatedItem.Type.PROJECT, event.getProjectName(), event.getProjectId().toString()).thatAffects(new AssociatedItem[]{new AffectedScheme((NamedWithId)event.getScheme())});
    }

    protected static List<ChangedValue> computeChangedValues(NamedWithDescription currentScheme) {
        return SchemeEventHandlerImpl.computeChangedValues(null, currentScheme);
    }

    protected static List<ChangedValue> computeChangedValues(NamedWithDescription originalScheme, NamedWithDescription currentScheme) {
        ChangedValuesBuilder changedValues = new ChangedValuesBuilder();
        changedValues.addIfDifferent("common.words.name", originalScheme == null ? null : originalScheme.getName(), currentScheme.getName()).addIfDifferent("common.words.description", originalScheme == null ? null : originalScheme.getDescription(), currentScheme.getDescription());
        return changedValues.build();
    }

    static enum SchemeDetail {
        WORKFLOW(AuditingCategory.WORKFLOWS, "jira.auditing.workflow.scheme.created", "jira.auditing.workflow.scheme.updated", "jira.auditing.workflow.scheme.copied", "jira.auditing.workflow.scheme.added.to.project", "jira.auditing.workflow.scheme.removed.from.project"),
        PERMISSION(AuditingCategory.PERMISSIONS, "jira.auditing.permission.scheme.created", "jira.auditing.permission.scheme.updated", "jira.auditing.permission.scheme.copied", "jira.auditing.permission.scheme.added.to.project", "jira.auditing.permission.scheme.removed.from.project"),
        NOTIFICATION(AuditingCategory.NOTIFICATIONS, "jira.auditing.notification.scheme.created", "jira.auditing.notification.scheme.updated", "jira.auditing.notification.scheme.copied", "jira.auditing.notification.scheme.added.to.project", "jira.auditing.notification.scheme.removed.from.project"),
        FIELDS(AuditingCategory.FIELDS, "jira.auditing.field.layout.scheme.created", "jira.auditing.field.layout.scheme.updated", "jira.auditing.field.layout.scheme.copied", "jira.auditing.field.layout.scheme.added.to.project", "jira.auditing.field.layout.scheme.removed.from.project"),
        ISSUE_SECURITY(AuditingCategory.PERMISSIONS, "jira.auditing.issue.security.scheme.created", "jira.auditing.issue.security.scheme.updated", "jira.auditing.issue.security.scheme.copied", "jira.auditing.issue.security.scheme.added.to.project", "jira.auditing.issue.security.scheme.removed.from.project");

        private final AuditingCategory category;
        private final String createdSummary;
        private final String updatedSummary;
        private final String copiedSummary;
        private final String addedToProject;
        private final String removedFromProject;

        private SchemeDetail(AuditingCategory category, String createdSummary, String updatedSummary, String copiedSummary, String addedToProject, String removedFromProject) {
            this.category = category;
            this.createdSummary = createdSummary;
            this.updatedSummary = updatedSummary;
            this.copiedSummary = copiedSummary;
            this.addedToProject = addedToProject;
            this.removedFromProject = removedFromProject;
        }
    }
}

