/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.auditing.handlers;

import com.atlassian.fugue.Option;
import com.atlassian.jira.auditing.AffectedUser;
import com.atlassian.jira.auditing.AssociatedItem;
import com.atlassian.jira.auditing.AuditingCategory;
import com.atlassian.jira.auditing.ChangedValue;
import com.atlassian.jira.auditing.RecordRequest;
import com.atlassian.jira.auditing.handlers.ChangedValuesBuilder;
import com.atlassian.jira.auditing.handlers.HandlerUtils;
import com.atlassian.jira.auditing.handlers.ProjectEventHandler;
import com.atlassian.jira.event.ProjectCreatedEvent;
import com.atlassian.jira.event.ProjectDeletedEvent;
import com.atlassian.jira.event.ProjectUpdatedEvent;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectAssigneeTypes;
import com.atlassian.jira.util.I18nHelper;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Locale;

public class ProjectEventHandlerImpl
implements ProjectEventHandler {
    private final I18nHelper.BeanFactory i18n;

    public ProjectEventHandlerImpl(I18nHelper.BeanFactory i18n) {
        this.i18n = i18n;
    }

    @Override
    public RecordRequest onProjectCreatedEvent(ProjectCreatedEvent event) {
        return new RecordRequest(AuditingCategory.PROJECTS, "jira.auditing.project.created").forObject(AssociatedItem.Type.PROJECT, event.getProject().getName(), event.getProject().getId().toString()).thatAffects(this.getUserByProjectLeadChange(event.getProject())).withChangedValues(this.buildChangedValues(event.getProject()));
    }

    @Override
    public Option<RecordRequest> onProjectUpdatedEvent(final ProjectUpdatedEvent event) {
        return HandlerUtils.requestIfThereAreAnyValues(this.buildChangedValues(event.getOldProject(), event.getProject()), new Function<List<ChangedValue>, RecordRequest>(){

            public RecordRequest apply(List<ChangedValue> changedValues) {
                return new RecordRequest(AuditingCategory.PROJECTS, "jira.auditing.project.updated").forObject(AssociatedItem.Type.PROJECT, event.getProject().getName(), event.getProject().getId().toString()).thatAffects((Iterable)ProjectEventHandlerImpl.this.getUserByProjectLeadChange(event.getOldProject(), event.getProject())).withChangedValues(changedValues);
            }
        });
    }

    @Override
    public RecordRequest onProjectDeletedEvent(ProjectDeletedEvent event) {
        return new RecordRequest(AuditingCategory.PROJECTS, "jira.auditing.project.deleted").forObject(AssociatedItem.Type.PROJECT, event.getProject().getName(), event.getProject().getId().toString());
    }

    private ImmutableList<AssociatedItem> getUserByProjectLeadChange(Project project) {
        return this.getUserByProjectLeadChange(null, project);
    }

    private ImmutableList<AssociatedItem> getUserByProjectLeadChange(Project oldProject, Project project) {
        if (oldProject == null || !project.getProjectLead().equals(oldProject.getProjectLead())) {
            return ImmutableList.of((Object)new AffectedUser(project.getProjectLead()));
        }
        return ImmutableList.of();
    }

    private List<ChangedValue> buildChangedValues(Project project) {
        return this.buildChangedValues(null, project);
    }

    private List<ChangedValue> buildChangedValues(Project originalProject, Project currentProject) {
        ChangedValuesBuilder changedValues = new ChangedValuesBuilder();
        changedValues.addIfDifferent("common.words.name", originalProject == null ? null : originalProject.getName(), currentProject.getName());
        changedValues.addIfDifferent("common.words.key", originalProject == null ? null : originalProject.getKey(), currentProject.getKey());
        changedValues.addIfDifferent("common.concepts.description", originalProject == null ? null : originalProject.getDescription(), currentProject.getDescription());
        changedValues.addIfDifferent("common.concepts.url", originalProject == null ? null : originalProject.getUrl(), currentProject.getUrl());
        changedValues.addIfDifferent("common.concepts.projectlead", originalProject == null ? null : originalProject.getLeadUserName(), currentProject.getLeadUserName());
        changedValues.addIfDifferent("admin.projects.default.assignee", originalProject == null ? null : this.pre(originalProject.getAssigneeType()), this.pre(currentProject.getAssigneeType()));
        return changedValues.build();
    }

    private String pre(Long assigneeType) {
        return this.getI18n().getText(ProjectAssigneeTypes.getPrettyAssigneeType((Long)assigneeType));
    }

    protected I18nHelper getI18n() {
        return this.i18n.getInstance(Locale.ENGLISH);
    }
}

