/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.auditing.handlers;

import com.atlassian.gzipfilter.org.apache.commons.lang.StringUtils;
import com.atlassian.jira.auditing.AssociatedItem;
import com.atlassian.jira.auditing.AuditingCategory;
import com.atlassian.jira.auditing.ChangedValue;
import com.atlassian.jira.auditing.RecordRequest;
import com.atlassian.jira.auditing.handlers.ChangedValuesBuilder;
import com.atlassian.jira.auditing.handlers.PermissionChangeHandler;
import com.atlassian.jira.event.permission.GlobalPermissionAddedEvent;
import com.atlassian.jira.event.permission.GlobalPermissionDeletedEvent;
import com.atlassian.jira.event.permission.PermissionAddedEvent;
import com.atlassian.jira.event.permission.PermissionDeletedEvent;
import com.atlassian.jira.event.scheme.AbstractSchemeEntityEvent;
import com.atlassian.jira.permission.GlobalPermissionType;
import com.atlassian.jira.permission.PermissionSchemeManager;
import com.atlassian.jira.permission.PermissionTypeManager;
import com.atlassian.jira.permission.SchemePermissions;
import com.atlassian.jira.scheme.Scheme;
import com.atlassian.jira.security.GlobalPermissionManager;
import com.atlassian.jira.security.type.SecurityType;
import com.atlassian.jira.util.I18nHelper;
import java.util.List;
import java.util.Locale;

public class PermissionChangeHandlerImpl
implements PermissionChangeHandler {
    private final PermissionSchemeManager permissionSchemeManager;
    private final SchemePermissions schemePermissions;
    private final PermissionTypeManager permissionTypeManager;
    private final GlobalPermissionManager globalPermissionManager;
    private final I18nHelper.BeanFactory i18n;

    public PermissionChangeHandlerImpl(PermissionSchemeManager permissionSchemeManager, SchemePermissions schemePermissions, PermissionTypeManager permissionTypeManager, GlobalPermissionManager globalPermissionManager, I18nHelper.BeanFactory i18n) {
        this.permissionSchemeManager = permissionSchemeManager;
        this.schemePermissions = schemePermissions;
        this.permissionTypeManager = permissionTypeManager;
        this.globalPermissionManager = globalPermissionManager;
        this.i18n = i18n;
    }

    @Override
    public RecordRequest onPermissionAddedEvent(PermissionAddedEvent event) {
        Scheme scheme = this.permissionSchemeManager.getSchemeObject(event.getSchemeId());
        return new RecordRequest(AuditingCategory.PERMISSIONS, "jira.auditing.permission.scheme.updated").forObject(AssociatedItem.Type.SCHEME, scheme.getName(), Long.toString(scheme.getId())).withChangedValues(this.computeChangedValues((AbstractSchemeEntityEvent)event));
    }

    @Override
    public RecordRequest onPermissionDeletedEvent(PermissionDeletedEvent event) {
        Scheme scheme = this.permissionSchemeManager.getSchemeObject(event.getSchemeId());
        return new RecordRequest(AuditingCategory.PERMISSIONS, "jira.auditing.permission.scheme.updated").forObject(AssociatedItem.Type.SCHEME, scheme.getName(), Long.toString(scheme.getId())).withChangedValues(this.computeChangedValues((AbstractSchemeEntityEvent)event));
    }

    @Override
    public RecordRequest onGlobalPermissionAddedEvent(GlobalPermissionAddedEvent event) {
        String groupName = StringUtils.defaultString((String)event.getGroup(), (String)this.getI18n().getText("admin.common.words.anyone"));
        String permissionName = this.getPermissionName(event.getGlobalPermissionType());
        return new RecordRequest(AuditingCategory.PERMISSIONS, "jira.auditing.global.permission.added").forObject(AssociatedItem.Type.PERMISSIONS, this.getI18n().getText("jira.auditing.global.permissions"), null).withChangedValues(new ChangedValuesBuilder().addIfDifferent("admin.common.words.permission", "", permissionName).addIfDifferent("admin.common.words.group", "", groupName).build());
    }

    @Override
    public RecordRequest onGlobalPermissionDeletedEvent(GlobalPermissionDeletedEvent event) {
        String groupName = StringUtils.defaultString((String)event.getGroup(), (String)this.getI18n().getText("admin.common.words.anyone"));
        String permissionName = this.getPermissionName(event.getGlobalPermissionType());
        return new RecordRequest(AuditingCategory.PERMISSIONS, "jira.auditing.global.permission.deleted").forObject(AssociatedItem.Type.PERMISSIONS, this.getI18n().getText("jira.auditing.global.permissions"), null).withChangedValues(new ChangedValuesBuilder().addIfDifferent("admin.common.words.permission", permissionName, "").addIfDifferent("admin.common.words.group", groupName, "").build());
    }

    private String getPermissionName(GlobalPermissionType globalPermissionType) {
        return this.getI18n().getText(globalPermissionType.getNameI18nKey());
    }

    private List<ChangedValue> computeChangedValues(AbstractSchemeEntityEvent event) {
        SecurityType schemeType = (SecurityType)this.permissionTypeManager.getSchemeType(event.getType());
        Long permissionId = (Long)event.getEntityTypeId();
        String permissionName = this.schemePermissions.getSchemePermissions().get(permissionId.intValue()).getName();
        String receiverType = schemeType.getDisplayName();
        String receiverName = StringUtils.defaultString((String)(event.getParameter() != null ? schemeType.getArgumentDisplay(event.getParameter()) : ""), (String)"");
        if ("group".equals(event.getType()) && StringUtils.isEmpty((String)receiverName)) {
            receiverName = this.getI18n().getText("common.sharing.shared.description.anyone");
        }
        ChangedValuesBuilder builder = new ChangedValuesBuilder();
        if (event instanceof PermissionAddedEvent) {
            builder.addIfDifferent("admin.common.words.permission", "", permissionName).addIfDifferent("admin.common.words.type", "", receiverType).addIfDifferent("admin.common.words.value", "", receiverName);
        } else if (event instanceof PermissionDeletedEvent) {
            builder.addIfDifferent("admin.common.words.permission", permissionName, "").addIfDifferent("admin.common.words.type", receiverType, "").addIfDifferent("admin.common.words.value", receiverName, "");
        } else {
            throw new UnsupportedOperationException("Missing handler for " + event.getClass().getSimpleName());
        }
        return builder.build();
    }

    protected I18nHelper getI18n() {
        return this.i18n.getInstance(Locale.ENGLISH);
    }
}

