/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.auditing.handlers;

import com.atlassian.crowd.embedded.core.FilteredGroupsProvider;
import com.atlassian.crowd.embedded.impl.IdentifierUtils;
import com.atlassian.crowd.event.DirectoryEvent;
import com.atlassian.crowd.event.group.GroupCreatedEvent;
import com.atlassian.crowd.event.group.GroupDeletedEvent;
import com.atlassian.crowd.event.group.GroupMembershipCreatedEvent;
import com.atlassian.crowd.event.group.GroupMembershipDeletedEvent;
import com.atlassian.crowd.model.membership.MembershipType;
import com.atlassian.fugue.Option;
import com.atlassian.jira.auditing.AffectedGroup;
import com.atlassian.jira.auditing.AffectedUser;
import com.atlassian.jira.auditing.AssociatedItem;
import com.atlassian.jira.auditing.AuditingCategory;
import com.atlassian.jira.auditing.RecordRequest;
import com.atlassian.jira.auditing.handlers.GroupEventHandler;
import com.atlassian.jira.component.ComponentAccessor;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;

public class GroupEventHandlerImpl
implements GroupEventHandler {
    final ImmutableSet<String> filteredGroups;

    public GroupEventHandlerImpl(FilteredGroupsProvider filteredGroupsProvider) {
        Preconditions.checkNotNull((Object)filteredGroupsProvider);
        this.filteredGroups = ImmutableSet.copyOf((Collection)Collections2.transform((Collection)filteredGroupsProvider.getGroups(), (Function)IdentifierUtils.TO_LOWER_CASE));
    }

    @Override
    public Option<RecordRequest> onGroupCreatedEvent(GroupCreatedEvent event) {
        return this.ifGroupNotHidden(event, event.getGroup().getName()).map((Function)new Function<GroupCreatedEvent, RecordRequest>(){

            public RecordRequest apply(GroupCreatedEvent event) {
                return new RecordRequest(AuditingCategory.GROUP_MANAGEMENT, "jira.auditing.group.created").forObject((AssociatedItem)new AffectedGroup(event.getGroup().getName()));
            }
        });
    }

    @Override
    public Option<RecordRequest> onGroupDeletedEvent(GroupDeletedEvent event) {
        return this.ifGroupNotHidden(event, event.getGroupName()).map((Function)new Function<GroupDeletedEvent, RecordRequest>(){

            public RecordRequest apply(GroupDeletedEvent event) {
                return new RecordRequest(AuditingCategory.GROUP_MANAGEMENT, "jira.auditing.group.deleted").forObject((AssociatedItem)new AffectedGroup(event.getGroupName()));
            }
        });
    }

    @Override
    public Option<RecordRequest> onGroupMembershipCreatedEvent(GroupMembershipCreatedEvent event) {
        return this.ifGroupNotHidden(event, event.getGroupName()).map((Function)new Function<GroupMembershipCreatedEvent, RecordRequest>(){

            public RecordRequest apply(GroupMembershipCreatedEvent event) {
                if (event.getMembershipType().equals((Object)MembershipType.GROUP_GROUP)) {
                    return new RecordRequest(AuditingCategory.GROUP_MANAGEMENT, "jira.auditing.group.added.to.group").forObject((AssociatedItem)new AffectedGroup(event.getGroupName())).thatAffects(new AssociatedItem[]{new AffectedGroup(event.getEntityName())});
                }
                if (event.getMembershipType().equals((Object)MembershipType.GROUP_USER)) {
                    String userKey = ComponentAccessor.getUserKeyService().getKeyForUsername(event.getEntityName());
                    return new RecordRequest(AuditingCategory.GROUP_MANAGEMENT, "jira.auditing.user.added.to.group").forObject((AssociatedItem)new AffectedGroup(event.getGroupName())).thatAffects(new AssociatedItem[]{new AffectedUser(event.getEntityName(), userKey, event.getDirectory())});
                }
                throw new IllegalArgumentException("Unknown membership type: " + event.getMembershipType());
            }
        });
    }

    @Override
    public Option<RecordRequest> onGroupMembershipDeletedEvent(GroupMembershipDeletedEvent event) {
        return this.ifGroupNotHidden(event, event.getGroupName()).map((Function)new Function<GroupMembershipDeletedEvent, RecordRequest>(){

            public RecordRequest apply(GroupMembershipDeletedEvent event) {
                if (event.getMembershipType().equals((Object)MembershipType.GROUP_GROUP)) {
                    return new RecordRequest(AuditingCategory.GROUP_MANAGEMENT, "jira.auditing.group.removed.from.group").forObject((AssociatedItem)new AffectedGroup(event.getGroupName())).thatAffects(new AssociatedItem[]{new AffectedGroup(event.getEntityName())});
                }
                if (event.getMembershipType().equals((Object)MembershipType.GROUP_USER)) {
                    String userKey = ComponentAccessor.getUserKeyService().getKeyForUsername(event.getEntityName());
                    return new RecordRequest(AuditingCategory.GROUP_MANAGEMENT, "jira.auditing.user.removed.from.group").forObject((AssociatedItem)new AffectedGroup(event.getGroupName())).thatAffects(new AssociatedItem[]{new AffectedUser(event.getEntityName(), userKey, event.getDirectory())});
                }
                throw new IllegalArgumentException("Unknown membership type: " + event.getMembershipType());
            }
        });
    }

    private <T extends DirectoryEvent> Option<T> ifGroupNotHidden(T event, String groupName) {
        if (this.isGroupToBeFiltered(groupName)) {
            return Option.none();
        }
        return Option.some(event);
    }

    private boolean isGroupToBeFiltered(String groupname) {
        return this.filteredGroups.contains((Object)IdentifierUtils.toLowerCase((String)groupname));
    }
}

