/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.auditing;

import com.atlassian.jira.auditing.AssociatedItem;
import com.atlassian.jira.auditing.AssociatedItemImpl;
import com.atlassian.jira.auditing.AuditRecord;
import com.atlassian.jira.auditing.AuditRecordImpl;
import com.atlassian.jira.auditing.AuditingCategory;
import com.atlassian.jira.auditing.AuditingStore;
import com.atlassian.jira.auditing.ChangedValue;
import com.atlassian.jira.auditing.ChangedValueImpl;
import com.atlassian.jira.auditing.Records;
import com.atlassian.jira.auditing.SearchTokenizer;
import com.atlassian.jira.entity.AbstractEntityFactory;
import com.atlassian.jira.entity.Select;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.transaction.Transaction;
import com.atlassian.jira.transaction.TransactionSupport;
import com.atlassian.jira.user.ApplicationUser;
import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.ofbiz.core.entity.EntityCondition;
import org.ofbiz.core.entity.EntityConditionList;
import org.ofbiz.core.entity.EntityExpr;
import org.ofbiz.core.entity.EntityExprList;
import org.ofbiz.core.entity.EntityOperator;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;

public class AuditingStoreImpl
implements AuditingStore {
    public static final long OTHER = 0L;
    public static final long SYSADMIN = 1L;
    public static final int MAX_RESULTS_LIMIT = 10000;
    private static String ENTITY_NAME = "AuditLog";
    private static String ITEMS_ENTITY_NAME = "AuditItem";
    private static String CHANGED_VALUES_ENTITY_NAME = "AuditChangedValue";
    private final OfBizDelegator ofBizDelegator;
    private final TransactionSupport transactionSupport;

    public AuditingStoreImpl(OfBizDelegator ofBizDelegator, TransactionSupport transactionSupport) {
        this.ofBizDelegator = ofBizDelegator;
        this.transactionSupport = transactionSupport;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void storeRecord(@Nonnull AuditingCategory category, String categoryName, @Nonnull String summary, @Nullable ApplicationUser author, @Nullable String remoteAddress, @Nullable AssociatedItem objectItem, @Nullable Iterable<ChangedValue> changedValues, @Nullable Iterable<AssociatedItem> associatedItems, boolean isAuthorSysAdmin) {
        Transaction transaction = this.transactionSupport.begin();
        try {
            HashMap values = Maps.newHashMap();
            values.put("remoteAddress", remoteAddress);
            values.put("created", new Timestamp(System.currentTimeMillis()));
            values.put("authorKey", author != null ? author.getKey() : null);
            values.put("summary", summary);
            values.put("category", category.getId());
            values.put("authorType", isAuthorSysAdmin ? 1L : 0L);
            if (objectItem != null) {
                values.put("objectId", objectItem.getObjectId());
                values.put("objectName", objectItem.getObjectName());
                values.put("objectParentId", objectItem.getParentId());
                values.put("objectParentName", objectItem.getParentName());
                values.put("objectType", objectItem.getObjectType() != null ? objectItem.getObjectType().toString() : null);
            }
            values.put("searchField", AuditingStoreImpl.computeSearchField(summary, objectItem, associatedItems, changedValues, remoteAddress, author, categoryName));
            GenericValue gv = this.ofBizDelegator.createValue(ENTITY_NAME, (Map)values);
            if (associatedItems != null) {
                this.storeAssociatedItems(gv, associatedItems);
            }
            if (changedValues != null) {
                this.storeChangedValues(gv, changedValues);
            }
            transaction.commit();
        }
        finally {
            transaction.finallyRollbackIfNotCommitted();
        }
    }

    public static String computeSearchField(String summary, AssociatedItem objectItem, Iterable<AssociatedItem> associatedItems, Iterable<ChangedValue> changedValues, String remoteAddress, ApplicationUser author, String categoryName) {
        SearchTokenizer tokenizer = new SearchTokenizer();
        if (author != null) {
            tokenizer.put(author.getName());
            tokenizer.put(author.getDisplayName());
        }
        tokenizer.put(remoteAddress);
        tokenizer.put(summary);
        tokenizer.put(categoryName);
        if (objectItem != null) {
            tokenizer.put(objectItem.getObjectName());
            tokenizer.put(objectItem.getParentName());
        }
        if (associatedItems != null) {
            for (AssociatedItem item : associatedItems) {
                tokenizer.put(item.getObjectName());
                tokenizer.put(item.getParentName());
            }
        }
        if (changedValues != null) {
            for (ChangedValue changedValue : changedValues) {
                tokenizer.put(changedValue.getFrom());
                tokenizer.put(changedValue.getTo());
            }
        }
        return tokenizer.getTokenizedString();
    }

    protected void storeChangedValues(@Nonnull GenericValue gv, @Nonnull Iterable<ChangedValue> changedValues) {
        for (ChangedValue changedValue : changedValues) {
            HashMap values = Maps.newHashMap();
            values.put("logId", gv.get("id"));
            values.put("name", changedValue.getName());
            values.put("deltaFrom", changedValue.getFrom());
            values.put("deltaTo", changedValue.getTo());
            this.ofBizDelegator.createValue("AuditChangedValue", (Map)values);
        }
    }

    protected void storeAssociatedItems(@Nonnull GenericValue gv, @Nonnull Iterable<AssociatedItem> associatedItems) {
        for (AssociatedItem item : associatedItems) {
            HashMap values = Maps.newHashMap();
            values.put("logId", gv.getLong("id"));
            values.put("objectId", item.getObjectId());
            values.put("objectName", item.getObjectName());
            values.put("objectParentId", item.getParentId());
            values.put("objectParentName", item.getParentName());
            values.put("objectType", item.getObjectType().toString());
            this.ofBizDelegator.createValue(ITEMS_ENTITY_NAME, (Map)values);
        }
    }

    @Override
    @Nonnull
    public Records getRecords(final @Nullable Long maxId, final @Nullable Long sinceId, final @Nullable String filter, @Nullable Long maxResults, Long page, final Long fromTimestamp, final Long toTimestamp, final boolean includeSysAdminActions) {
        EntityCondition condition = this.getCondition(maxId, sinceId, filter, fromTimestamp, toTimestamp, includeSysAdminActions);
        long limit = maxResults != null && maxResults < 10000L ? maxResults : 10000L;
        long offset = page == null ? 0L : (page - 1L) * limit;
        final List records = (condition != null ? Select.from(ENTITY_NAME).whereCondition(condition) : Select.from(ENTITY_NAME)).orderBy("id desc").limit((int)offset, (int)limit).runWith(this.ofBizDelegator).asList();
        return new Records(){

            public Iterable<AuditRecord> getRecords() {
                return Iterables.transform((Iterable)records, (Function)new Function<GenericValue, AuditRecord>(){

                    public AuditRecord apply(GenericValue input) {
                        try {
                            Iterable items = Iterables.transform((Iterable)input.getRelatedByAnd("Child" + ITEMS_ENTITY_NAME, (Map)ImmutableMap.of((Object)"logId", (Object)input.getLong("id"))), AssociatedItemImpl.from());
                            List<ChangedValue> changedValues = Select.from(AuditingStoreImpl.this.getChangeValueEntityFactory()).whereEqual("logId", input.getLong("id")).orderBy("id asc").runWith(AuditingStoreImpl.this.ofBizDelegator).asList();
                            return new AuditRecordImpl(input, items, changedValues);
                        }
                        catch (GenericEntityException e) {
                            throw new RuntimeException(e);
                        }
                    }
                });
            }

            public long getCount() {
                Long maxIdFromPreviousQuery = maxId != null ? maxId : (records.size() > 0 ? (Long)((GenericValue)records.get(0)).get("id") : null);
                EntityCondition condition = AuditingStoreImpl.this.getCondition(maxIdFromPreviousQuery, sinceId, filter, fromTimestamp, toTimestamp, includeSysAdminActions);
                return (condition != null ? Select.from(ENTITY_NAME).whereCondition(condition).runWith(AuditingStoreImpl.this.ofBizDelegator) : Select.from(ENTITY_NAME).runWith(AuditingStoreImpl.this.ofBizDelegator)).count();
            }

            public int getMaxResults() {
                return 10000;
            }
        };
    }

    @Override
    public long countRecords(@Nullable Long maxId, @Nullable Long sinceId, boolean includeSysAdminActions) {
        EntityCondition condition = this.getCondition(maxId, sinceId, null, null, null, includeSysAdminActions);
        Long count = (condition != null ? Select.from(ENTITY_NAME).whereCondition(condition).runWith(this.ofBizDelegator) : Select.from(ENTITY_NAME).runWith(this.ofBizDelegator)).count();
        return count != null ? count : 0L;
    }

    @Nullable
    protected EntityCondition getCondition(@Nullable Long maxId, @Nullable Long sinceId, String filter, Long fromTimestamp, Long toTimestamp, boolean includeSysAdminActions) {
        ArrayList conditions = Lists.newArrayListWithCapacity((int)6);
        if (!includeSysAdminActions) {
            conditions.add(new EntityExpr("authorType", EntityOperator.NOT_EQUAL, (Object)1L));
        }
        if (maxId != null) {
            conditions.add(new EntityExpr("id", EntityOperator.LESS_THAN_EQUAL_TO, (Object)maxId));
        }
        if (sinceId != null) {
            conditions.add(new EntityExpr("id", EntityOperator.GREATER_THAN_EQUAL_TO, (Object)sinceId));
        }
        if (filter != null) {
            conditions.add(this.getConditionForFilter(filter));
        }
        if (fromTimestamp != null) {
            conditions.add(new EntityExpr("created", EntityOperator.GREATER_THAN_EQUAL_TO, (Object)new Timestamp(fromTimestamp)));
        }
        if (fromTimestamp != null && toTimestamp != null) {
            conditions.add(new EntityExpr("created", EntityOperator.LESS_THAN_EQUAL_TO, (Object)new Timestamp(toTimestamp)));
        }
        if (conditions.isEmpty()) {
            return null;
        }
        return new EntityConditionList((List)conditions, EntityOperator.AND);
    }

    private EntityCondition getConditionForFilter(String filter) {
        Collection conditions = Collections2.transform(SearchTokenizer.tokenize(filter), (Function)new Function<String, EntityExpr>(){

            public EntityExpr apply(String token) {
                return new EntityExpr("searchField", EntityOperator.LIKE, (Object)("%" + token + "%"));
            }
        });
        return new EntityExprList((List)ImmutableList.copyOf((Collection)conditions), EntityOperator.AND);
    }

    private AbstractEntityFactory<ChangedValue> getChangeValueEntityFactory() {
        return new AbstractEntityFactory<ChangedValue>(){

            @Override
            public Map<String, Object> fieldMapFrom(ChangedValue value) {
                throw new UnsupportedOperationException("Not implemented");
            }

            @Override
            public String getEntityName() {
                return CHANGED_VALUES_ENTITY_NAME;
            }

            @Override
            public ChangedValueImpl build(GenericValue genericValue) {
                return new ChangedValueImpl(genericValue.getString("name"), genericValue.getString("deltaFrom"), genericValue.getString("deltaTo"));
            }
        };
    }
}

