/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.auditing;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.auditing.AssociatedItem;
import com.atlassian.jira.auditing.AuditingCategory;
import com.atlassian.jira.auditing.AuditingEventListener;
import com.atlassian.jira.auditing.AuditingManager;
import com.atlassian.jira.auditing.AuditingStore;
import com.atlassian.jira.auditing.ChangedValue;
import com.atlassian.jira.auditing.RecordRequest;
import com.atlassian.jira.auditing.Records;
import com.atlassian.jira.auditing.ZeroRecords;
import com.atlassian.jira.auditing.analytics.AuditingSettingChangedEvent;
import com.atlassian.jira.auditing.handlers.FieldLayoutSchemeChangeHandler;
import com.atlassian.jira.auditing.handlers.GroupEventHandler;
import com.atlassian.jira.auditing.handlers.NotificationChangeHandler;
import com.atlassian.jira.auditing.handlers.PermissionChangeHandler;
import com.atlassian.jira.auditing.handlers.ProjectEventHandler;
import com.atlassian.jira.auditing.handlers.SchemeEventHandler;
import com.atlassian.jira.auditing.handlers.UserEventHandler;
import com.atlassian.jira.auditing.handlers.WorkflowEventHandler;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.concurrent.BarrierFactory;
import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.exception.PermissionException;
import com.atlassian.jira.extension.Startable;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.web.ExecutingHttpRequest;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;

public class AuditingManagerImpl
implements AuditingManager,
Startable {
    private final AuditingStore auditingStore;
    private final ApplicationProperties applicationProperties;
    private final EventPublisher eventPublisher;
    private final FeatureManager featureManager;
    private final AuditingEventListener auditingEventListener;
    private final JiraAuthenticationContext authenticationContext;
    private final PermissionManager permissionManager;
    private final BarrierFactory barrierFactory;

    public AuditingManagerImpl(AuditingStore auditingStore, ApplicationProperties applicationProperties, EventPublisher eventPublisher, FeatureManager featureManager, JiraAuthenticationContext authenticationContext, PermissionManager permissionManager, PermissionChangeHandler permissionChangeHandler, GroupEventHandler groupEventHandler, SchemeEventHandler schemeEventHandler, UserEventHandler userEventHandler, WorkflowEventHandler workflowEventHandler, NotificationChangeHandler notificationChangeHandler, FieldLayoutSchemeChangeHandler fieldLayoutSchemeChangeHandler, ProjectEventHandler projectEventHandler, BarrierFactory barrierFactory) {
        this.auditingStore = auditingStore;
        this.applicationProperties = applicationProperties;
        this.eventPublisher = eventPublisher;
        this.featureManager = featureManager;
        this.authenticationContext = authenticationContext;
        this.permissionManager = permissionManager;
        this.barrierFactory = barrierFactory;
        this.auditingEventListener = new AuditingEventListener(this, permissionChangeHandler, groupEventHandler, schemeEventHandler, userEventHandler, workflowEventHandler, notificationChangeHandler, fieldLayoutSchemeChangeHandler, projectEventHandler);
    }

    public void store(RecordRequest record) {
        if (this.isAuditingEnabled()) {
            ApplicationUser author = record.getAuthor() != null ? record.getAuthor() : this.getLoggedInUser();
            this.auditingStore.storeRecord(record.getCategory(), record.getCategoryName(), record.getSummary(), author, StringUtils.defaultString((String)record.getRemoteAddress(), (String)this.getRemoteAddress()), record.getObjectItem(), (Iterable<ChangedValue>)record.getChangedValues(), (Iterable<AssociatedItem>)record.getAssociatedItems(), this.permissionManager.hasPermission(44, author));
        }
    }

    @Nonnull
    public Records getRecords(@Nullable Long maxId, @Nullable Long sinceId, @Nullable String filter, @Nullable Long count, @Nullable Long page, @Nullable Long fromTimestamp, @Nullable Long toTimestamp) {
        return this.getRecords(maxId, sinceId, filter, count, page, fromTimestamp, toTimestamp, true);
    }

    @Nonnull
    public Records getRecordsWithoutSysAdmin(@Nullable Long maxId, @Nullable Long sinceId, @Nullable String filter, @Nullable Long count, @Nullable Long page, @Nullable Long fromTimestamp, @Nullable Long toTimestamp) {
        return this.getRecords(maxId, sinceId, filter, count, page, fromTimestamp, toTimestamp, false);
    }

    @Nonnull
    public long countRecords(@Nullable Long maxId, @Nullable Long sinceId) {
        return this.countRecords(maxId, sinceId, true);
    }

    @Nonnull
    public long countRecordsWithoutSysAdmin(@Nullable Long maxId, @Nullable Long sinceId) {
        return this.countRecords(maxId, sinceId, false);
    }

    protected Records getRecords(@Nullable Long maxId, @Nullable Long sinceId, @Nullable String filter, @Nullable Long maxResults, Long page, Long fromTimestamp, Long toTimestamp, boolean includeSysAdminActions) {
        this.barrierFactory.getBarrier("auditingGetRecords").await();
        if (this.isAuditingEnabled()) {
            return this.auditingStore.getRecords(maxId, sinceId, filter, maxResults, page, fromTimestamp, toTimestamp, includeSysAdminActions);
        }
        return new ZeroRecords(10000);
    }

    protected long countRecords(@Nullable Long maxId, @Nullable Long sinceId, boolean includeSysAdminActions) {
        if (this.isAuditingEnabled()) {
            return this.auditingStore.countRecords(maxId, sinceId, includeSysAdminActions);
        }
        return 0L;
    }

    public boolean isAuditingEnabled() {
        return Boolean.valueOf(this.applicationProperties.getDefaultBackedString("jira.option.auditing"));
    }

    public void setAuditingEnabled(boolean enable) throws PermissionException {
        ApplicationUser currentUser = this.authenticationContext.getUser();
        if (currentUser == null || !this.permissionManager.hasPermission(0, currentUser)) {
            throw new PermissionException("You don't have permission to manage Auditing state");
        }
        this.setAuditingEnabledNoPermissionCheck(enable);
    }

    protected void setAuditingEnabledNoPermissionCheck(boolean enable) {
        boolean currentlyEnabled = this.isAuditingEnabled();
        if (currentlyEnabled != enable) {
            if (currentlyEnabled) {
                this.eventPublisher.unregister((Object)this.auditingEventListener);
            } else {
                this.eventPublisher.register((Object)this.auditingEventListener);
            }
            this.applicationProperties.setString("jira.option.auditing", Boolean.toString(enable));
            this.auditingStore.storeRecord(AuditingCategory.AUDITING, AuditingManagerImpl.getI18n().getText(AuditingCategory.AUDITING.getNameI18nKey()), AuditingManagerImpl.getI18n().getText(enable ? "jira.auditing.enabled" : "jira.auditing.disabled"), this.getLoggedInUser(), this.getRemoteAddress(), null, null, null, this.permissionManager.hasPermission(44, this.getLoggedInUser()));
            this.eventPublisher.publish((Object)new AuditingSettingChangedEvent(enable));
        }
    }

    @Nullable
    protected String getRemoteAddress() {
        return ExecutingHttpRequest.get() != null ? ExecutingHttpRequest.get().getRemoteAddr() : null;
    }

    protected ApplicationUser getLoggedInUser() {
        return this.authenticationContext.getUser();
    }

    protected static I18nHelper getI18n() {
        return ComponentAccessor.getI18nHelperFactory().getInstance(Locale.ENGLISH);
    }

    public void start() throws Exception {
        if (this.featureManager.isEnabled("auditing")) {
            this.setAuditingEnabledNoPermissionCheck(true);
        }
        if (this.isAuditingEnabled()) {
            this.eventPublisher.register((Object)this.auditingEventListener);
        }
    }
}

