/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.auditing;

import com.atlassian.crowd.event.group.GroupCreatedEvent;
import com.atlassian.crowd.event.group.GroupDeletedEvent;
import com.atlassian.crowd.event.group.GroupMembershipCreatedEvent;
import com.atlassian.crowd.event.group.GroupMembershipDeletedEvent;
import com.atlassian.crowd.event.user.UserCreatedEvent;
import com.atlassian.crowd.event.user.UserCredentialUpdatedEvent;
import com.atlassian.crowd.event.user.UserDeletedEvent;
import com.atlassian.crowd.event.user.UserUpdatedEvent;
import com.atlassian.event.api.EventListener;
import com.atlassian.fugue.Effect;
import com.atlassian.jira.auditing.AuditingManager;
import com.atlassian.jira.auditing.RecordRequest;
import com.atlassian.jira.auditing.handlers.CustomFieldHandler;
import com.atlassian.jira.auditing.handlers.FieldLayoutSchemeChangeHandler;
import com.atlassian.jira.auditing.handlers.GroupEventHandler;
import com.atlassian.jira.auditing.handlers.NotificationChangeHandler;
import com.atlassian.jira.auditing.handlers.PermissionChangeHandler;
import com.atlassian.jira.auditing.handlers.ProjectEventHandler;
import com.atlassian.jira.auditing.handlers.SchemeEventHandler;
import com.atlassian.jira.auditing.handlers.UserEventHandler;
import com.atlassian.jira.auditing.handlers.WorkflowEventHandler;
import com.atlassian.jira.event.DraftWorkflowPublishedEvent;
import com.atlassian.jira.event.ProjectCreatedEvent;
import com.atlassian.jira.event.ProjectDeletedEvent;
import com.atlassian.jira.event.ProjectUpdatedEvent;
import com.atlassian.jira.event.WorkflowCopiedEvent;
import com.atlassian.jira.event.WorkflowCreatedEvent;
import com.atlassian.jira.event.WorkflowDeletedEvent;
import com.atlassian.jira.event.WorkflowRenamedEvent;
import com.atlassian.jira.event.WorkflowUpdatedEvent;
import com.atlassian.jira.event.fields.layout.AbstractFieldLayoutSchemeEntityEvent;
import com.atlassian.jira.event.fields.layout.FieldLayoutSchemeAddedToProjectEvent;
import com.atlassian.jira.event.fields.layout.FieldLayoutSchemeCopiedEvent;
import com.atlassian.jira.event.fields.layout.FieldLayoutSchemeCreatedEvent;
import com.atlassian.jira.event.fields.layout.FieldLayoutSchemeDeletedEvent;
import com.atlassian.jira.event.fields.layout.FieldLayoutSchemeEntityCreatedEvent;
import com.atlassian.jira.event.fields.layout.FieldLayoutSchemeEntityRemovedEvent;
import com.atlassian.jira.event.fields.layout.FieldLayoutSchemeEntityUpdatedEvent;
import com.atlassian.jira.event.fields.layout.FieldLayoutSchemeRemovedFromProjectEvent;
import com.atlassian.jira.event.fields.layout.FieldLayoutSchemeUpdatedEvent;
import com.atlassian.jira.event.issue.field.CustomFieldCreatedEvent;
import com.atlassian.jira.event.issue.field.CustomFieldDeletedEvent;
import com.atlassian.jira.event.issue.field.CustomFieldUpdatedEvent;
import com.atlassian.jira.event.issue.security.IssueSecuritySchemeAddedToProjectEvent;
import com.atlassian.jira.event.issue.security.IssueSecuritySchemeRemovedFromProjectEvent;
import com.atlassian.jira.event.notification.NotificationAddedEvent;
import com.atlassian.jira.event.notification.NotificationDeletedEvent;
import com.atlassian.jira.event.notification.NotificationSchemeAddedToProjectEvent;
import com.atlassian.jira.event.notification.NotificationSchemeCopiedEvent;
import com.atlassian.jira.event.notification.NotificationSchemeCreatedEvent;
import com.atlassian.jira.event.notification.NotificationSchemeDeletedEvent;
import com.atlassian.jira.event.notification.NotificationSchemeRemovedFromProjectEvent;
import com.atlassian.jira.event.notification.NotificationSchemeUpdatedEvent;
import com.atlassian.jira.event.permission.GlobalPermissionAddedEvent;
import com.atlassian.jira.event.permission.GlobalPermissionDeletedEvent;
import com.atlassian.jira.event.permission.PermissionAddedEvent;
import com.atlassian.jira.event.permission.PermissionDeletedEvent;
import com.atlassian.jira.event.permission.PermissionSchemeAddedToProjectEvent;
import com.atlassian.jira.event.permission.PermissionSchemeCopiedEvent;
import com.atlassian.jira.event.permission.PermissionSchemeCreatedEvent;
import com.atlassian.jira.event.permission.PermissionSchemeDeletedEvent;
import com.atlassian.jira.event.permission.PermissionSchemeRemovedFromProjectEvent;
import com.atlassian.jira.event.permission.PermissionSchemeUpdatedEvent;
import com.atlassian.jira.event.scheme.AbstractSchemeAddedToProjectEvent;
import com.atlassian.jira.event.scheme.AbstractSchemeCopiedEvent;
import com.atlassian.jira.event.scheme.AbstractSchemeEvent;
import com.atlassian.jira.event.scheme.AbstractSchemeRemovedFromProjectEvent;
import com.atlassian.jira.event.scheme.AbstractSchemeUpdatedEvent;
import com.atlassian.jira.event.workflow.WorkflowSchemeAddedToProjectEvent;
import com.atlassian.jira.event.workflow.WorkflowSchemeCopiedEvent;
import com.atlassian.jira.event.workflow.WorkflowSchemeCreatedEvent;
import com.atlassian.jira.event.workflow.WorkflowSchemeDeletedEvent;
import com.atlassian.jira.event.workflow.WorkflowSchemeRemovedFromProjectEvent;
import com.atlassian.jira.event.workflow.WorkflowSchemeUpdatedEvent;

public class AuditingEventListener {
    private final AuditingManager auditingManager;
    private final PermissionChangeHandler permissionChangeHandler;
    private final GroupEventHandler groupEventHandler;
    private final SchemeEventHandler schemeEventHandler;
    private final UserEventHandler userEventHandler;
    private final WorkflowEventHandler workflowEventHandler;
    private final NotificationChangeHandler notificationChangeHandler;
    private final FieldLayoutSchemeChangeHandler fieldLayoutSchemeChangeHandler;
    private final ProjectEventHandler projectEventHandler;

    public AuditingEventListener(AuditingManager auditingManager, PermissionChangeHandler permissionChangeHandler, GroupEventHandler groupEventHandler, SchemeEventHandler schemeEventHandler, UserEventHandler userEventHandler, WorkflowEventHandler workflowEventHandler, NotificationChangeHandler notificationChangeHandler, FieldLayoutSchemeChangeHandler fieldLayoutSchemeChangeHandler, ProjectEventHandler projectEventHandler) {
        this.auditingManager = auditingManager;
        this.permissionChangeHandler = permissionChangeHandler;
        this.groupEventHandler = groupEventHandler;
        this.schemeEventHandler = schemeEventHandler;
        this.userEventHandler = userEventHandler;
        this.workflowEventHandler = workflowEventHandler;
        this.notificationChangeHandler = notificationChangeHandler;
        this.fieldLayoutSchemeChangeHandler = fieldLayoutSchemeChangeHandler;
        this.projectEventHandler = projectEventHandler;
    }

    @EventListener
    public void onUserCreation(UserCreatedEvent event) {
        this.auditingManager.store(this.userEventHandler.handleUserCreatedEvent(event));
    }

    @EventListener
    public void onUserDeleted(UserDeletedEvent event) {
        this.auditingManager.store(this.userEventHandler.handleUserDeletedEvent(event));
    }

    @EventListener
    public void onUserUpdatedEvent(UserUpdatedEvent event) {
        this.userEventHandler.handleUserUpdatedEvent(event).foreach(this.store());
    }

    @EventListener
    public void onUserCredentialUpdatedEvent(UserCredentialUpdatedEvent event) {
        this.auditingManager.store(this.userEventHandler.handleUserCredentialUpdatedEvent(event));
    }

    @EventListener
    public void onGroupCreatedEvent(GroupCreatedEvent event) {
        this.groupEventHandler.onGroupCreatedEvent(event).foreach(this.store());
    }

    @EventListener
    public void onGroupDeletedEvent(GroupDeletedEvent event) {
        this.groupEventHandler.onGroupDeletedEvent(event).foreach(this.store());
    }

    @EventListener
    public void onGroupMembershipCreatedEvent(GroupMembershipCreatedEvent event) {
        this.groupEventHandler.onGroupMembershipCreatedEvent(event).foreach(this.store());
    }

    @EventListener
    public void onGroupMembershipDeletedEvent(GroupMembershipDeletedEvent event) {
        this.groupEventHandler.onGroupMembershipDeletedEvent(event).foreach(this.store());
    }

    @EventListener
    public void onPermissionSchemeCreated(PermissionSchemeCreatedEvent event) {
        this.auditingManager.store(this.schemeEventHandler.onSchemeCreatedEvent((AbstractSchemeEvent)event));
    }

    @EventListener
    public void onPermissionSchemeCopied(PermissionSchemeCopiedEvent event) {
        this.auditingManager.store(this.schemeEventHandler.onSchemeCopiedEvent((AbstractSchemeCopiedEvent)event));
    }

    @EventListener
    public void onPermissionSchemeDeleted(PermissionSchemeDeletedEvent event) {
        this.auditingManager.store(this.schemeEventHandler.onSchemeDeletedEvent(event));
    }

    @EventListener
    public void onPermissionSchemeUpdated(PermissionSchemeUpdatedEvent event) {
        this.auditingManager.store(this.schemeEventHandler.onSchemeUpdatedEvent((AbstractSchemeUpdatedEvent)event));
    }

    @EventListener
    public void onPermissionAddedEvent(PermissionAddedEvent event) {
        this.auditingManager.store(this.permissionChangeHandler.onPermissionAddedEvent(event));
    }

    @EventListener
    public void onPermissionDeletedEvent(PermissionDeletedEvent event) {
        this.auditingManager.store(this.permissionChangeHandler.onPermissionDeletedEvent(event));
    }

    @EventListener
    public void onGlobalPermissionAdded(GlobalPermissionAddedEvent event) {
        this.auditingManager.store(this.permissionChangeHandler.onGlobalPermissionAddedEvent(event));
    }

    @EventListener
    public void onGlobalPermissionRemoved(GlobalPermissionDeletedEvent event) {
        this.auditingManager.store(this.permissionChangeHandler.onGlobalPermissionDeletedEvent(event));
    }

    @EventListener
    public void onWorkflowSchemeCreatedEvent(WorkflowSchemeCreatedEvent event) {
        this.auditingManager.store(this.schemeEventHandler.onSchemeCreatedEvent((AbstractSchemeEvent)event));
    }

    @EventListener
    public void onWorkflowSchemeCopiedEvent(WorkflowSchemeCopiedEvent event) {
        this.auditingManager.store(this.schemeEventHandler.onSchemeCopiedEvent((AbstractSchemeCopiedEvent)event));
    }

    @EventListener
    public void onWorkflowSchemeDeletedEvent(WorkflowSchemeDeletedEvent event) {
        this.auditingManager.store(this.schemeEventHandler.onSchemeDeletedEvent(event));
    }

    @EventListener
    public void onWorkflowSchemeUpdatedEvent(WorkflowSchemeUpdatedEvent event) {
        this.auditingManager.store(this.schemeEventHandler.onSchemeUpdatedEvent((AbstractSchemeUpdatedEvent)event));
    }

    @EventListener
    public void onWorkflowSchemeAddedToProjectEvent(WorkflowSchemeAddedToProjectEvent event) {
        this.auditingManager.store(this.schemeEventHandler.onSchemeAddedToProject((AbstractSchemeAddedToProjectEvent)event));
    }

    @EventListener
    public void onWorkflowSchemeRemovedFromProjectEvent(WorkflowSchemeRemovedFromProjectEvent event) {
        this.auditingManager.store(this.schemeEventHandler.onSchemeRemovedFromProject((AbstractSchemeRemovedFromProjectEvent)event));
    }

    @EventListener
    public void onWorkflowCreatedEvent(WorkflowCreatedEvent event) {
        this.auditingManager.store(this.workflowEventHandler.onWorkflowCreatedEvent(event));
    }

    @EventListener
    public void onWorkflowCopiedEvent(WorkflowCopiedEvent event) {
        this.auditingManager.store(this.workflowEventHandler.onWorkflowCopiedEvent(event));
    }

    @EventListener
    public void onWorkflowDeletedEvent(WorkflowDeletedEvent event) {
        this.auditingManager.store(this.workflowEventHandler.onWorkflowDeletedEvent(event));
    }

    @EventListener
    public void onWorkflowDeletedEvent(WorkflowUpdatedEvent event) {
        this.workflowEventHandler.onWorkflowUpdatedEvent(event).foreach(this.store());
    }

    @EventListener
    public void onDraftWorkflowPublishedEvent(DraftWorkflowPublishedEvent event) {
        this.auditingManager.store(this.workflowEventHandler.onDraftWorkflowPublishedEvent(event));
    }

    @EventListener
    public void onWorkflowRenamedEvent(WorkflowRenamedEvent event) {
        this.auditingManager.store(this.workflowEventHandler.onWorkflowRenamedEvent(event));
    }

    @EventListener
    public void onNotificationSchemeCreatedEvent(NotificationSchemeCreatedEvent event) {
        this.auditingManager.store(this.schemeEventHandler.onSchemeCreatedEvent((AbstractSchemeEvent)event));
    }

    @EventListener
    public void onNotificationSchemeDeletedEvent(NotificationSchemeDeletedEvent event) {
        this.auditingManager.store(this.schemeEventHandler.onSchemeDeletedEvent(event));
    }

    @EventListener
    public void onNotificationSchemeCopiedEvent(NotificationSchemeCopiedEvent event) {
        this.auditingManager.store(this.schemeEventHandler.onSchemeCopiedEvent((AbstractSchemeCopiedEvent)event));
    }

    @EventListener
    public void onNotificationSchemeUpdatedEvent(NotificationSchemeUpdatedEvent event) {
        this.auditingManager.store(this.schemeEventHandler.onSchemeUpdatedEvent((AbstractSchemeUpdatedEvent)event));
    }

    @EventListener
    public void onNotificationAddedEvent(NotificationAddedEvent event) {
        this.auditingManager.store(this.notificationChangeHandler.onNotificationAddedEvent(event));
    }

    @EventListener
    public void onNotificationDeletedEvent(NotificationDeletedEvent event) {
        this.auditingManager.store(this.notificationChangeHandler.onNotificationDeletedEvent(event));
    }

    @EventListener
    public void onFieldLayoutSchemeCreatedEvent(FieldLayoutSchemeCreatedEvent event) {
        this.auditingManager.store(this.schemeEventHandler.onSchemeCreatedEvent(event));
    }

    @EventListener
    public void onFieldLayoutSchemeCopiedEvent(FieldLayoutSchemeCopiedEvent event) {
        this.auditingManager.store(this.schemeEventHandler.onSchemeCopiedEvent(event));
    }

    @EventListener
    public void onFieldLayoutSchemeUpdatedEvent(FieldLayoutSchemeUpdatedEvent event) {
        this.auditingManager.store(this.schemeEventHandler.onSchemeUpdatedEvent(event));
    }

    @EventListener
    public void onFieldLayoutSchemeDeletedEvent(FieldLayoutSchemeDeletedEvent event) {
        this.auditingManager.store(this.schemeEventHandler.onSchemeDeletedEvent(event));
    }

    @EventListener
    public void onCustomFieldCreatedEvent(CustomFieldCreatedEvent event) {
        this.auditingManager.store(CustomFieldHandler.onCustomFieldCreatedEvent(event));
    }

    @EventListener
    public void onCustomFieldUpdatedEvent(CustomFieldUpdatedEvent event) {
        this.auditingManager.store(CustomFieldHandler.onCustomFieldUpdatedEvent(event));
    }

    @EventListener
    public void onCustomFieldDeletedEvent(CustomFieldDeletedEvent event) {
        this.auditingManager.store(CustomFieldHandler.onCustomFieldDeletedEvent(event));
    }

    @EventListener
    public void onFieldLayoutSchemeEntityCreatedEvent(FieldLayoutSchemeEntityCreatedEvent event) {
        this.auditingManager.store(this.fieldLayoutSchemeChangeHandler.onFieldLayoutSchemeEntityEvent((AbstractFieldLayoutSchemeEntityEvent)event));
    }

    @EventListener
    public void onFieldLayoutSchemeEntityRemovedEvent(FieldLayoutSchemeEntityRemovedEvent event) {
        this.auditingManager.store(this.fieldLayoutSchemeChangeHandler.onFieldLayoutSchemeEntityEvent((AbstractFieldLayoutSchemeEntityEvent)event));
    }

    @EventListener
    public void onFieldLayoutSchemeEntityUpdatedEvent(FieldLayoutSchemeEntityUpdatedEvent event) {
        this.auditingManager.store(this.fieldLayoutSchemeChangeHandler.onFieldLayoutSchemeEntityUpdatedEvent(event));
    }

    private Effect<RecordRequest> store() {
        return new Effect<RecordRequest>(){

            public void apply(RecordRequest recordRequest) {
                AuditingEventListener.this.auditingManager.store(recordRequest);
            }
        };
    }

    @EventListener
    public void onNotificationSchemeAddedToProjectEvent(NotificationSchemeAddedToProjectEvent event) {
        this.auditingManager.store(this.schemeEventHandler.onSchemeAddedToProject((AbstractSchemeAddedToProjectEvent)event));
    }

    @EventListener
    public void onNotificationSchemeRemovedFromProjectEvent(NotificationSchemeRemovedFromProjectEvent event) {
        this.auditingManager.store(this.schemeEventHandler.onSchemeRemovedFromProject((AbstractSchemeRemovedFromProjectEvent)event));
    }

    @EventListener
    public void onIssueSecuritySchemeAddedToProjectEvent(IssueSecuritySchemeAddedToProjectEvent event) {
        this.auditingManager.store(this.schemeEventHandler.onSchemeAddedToProject((AbstractSchemeAddedToProjectEvent)event));
    }

    @EventListener
    public void onIssueSecuritySchemeRemovedFromProjectEvent(IssueSecuritySchemeRemovedFromProjectEvent event) {
        this.auditingManager.store(this.schemeEventHandler.onSchemeRemovedFromProject((AbstractSchemeRemovedFromProjectEvent)event));
    }

    @EventListener
    public void onPermissionSchemeAddedToProjectEvent(PermissionSchemeAddedToProjectEvent event) {
        this.auditingManager.store(this.schemeEventHandler.onSchemeAddedToProject((AbstractSchemeAddedToProjectEvent)event));
    }

    @EventListener
    public void onPermissionSchemeRemovedFromProjectEvent(PermissionSchemeRemovedFromProjectEvent event) {
        this.auditingManager.store(this.schemeEventHandler.onSchemeRemovedFromProject((AbstractSchemeRemovedFromProjectEvent)event));
    }

    @EventListener
    public void onFieldLayoutSchemeAddedToProjectEvent(FieldLayoutSchemeAddedToProjectEvent event) {
        this.auditingManager.store(this.schemeEventHandler.onSchemeAddedToProject(event));
    }

    @EventListener
    public void onFieldLayoutSchemeRemovedFromProjectEvent(FieldLayoutSchemeRemovedFromProjectEvent event) {
        this.auditingManager.store(this.schemeEventHandler.onSchemeRemovedFromProject(event));
    }

    @EventListener
    public void onProjectCreatedEvent(ProjectCreatedEvent event) {
        this.auditingManager.store(this.projectEventHandler.onProjectCreatedEvent(event));
    }

    @EventListener
    public void onProjectUpdatedEvent(ProjectUpdatedEvent event) {
        this.projectEventHandler.onProjectUpdatedEvent(event).foreach(this.store());
    }

    @EventListener
    public void onProjectDeletedEvent(ProjectDeletedEvent event) {
        this.auditingManager.store(this.projectEventHandler.onProjectDeletedEvent(event));
    }
}

