/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.appconsistency.integrity.check;

import com.atlassian.jira.appconsistency.integrity.amendment.DeleteEntityAmendment;
import com.atlassian.jira.appconsistency.integrity.check.BaseFilterSubscriptionsCheck;
import com.atlassian.jira.appconsistency.integrity.exception.IntegrityException;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import org.ofbiz.core.entity.GenericValue;

public class FilterSubscriptionsTriggerCheck
extends BaseFilterSubscriptionsCheck {
    public FilterSubscriptionsTriggerCheck(OfBizDelegator ofBizDelegator, int id) {
        super(ofBizDelegator, id);
    }

    @Override
    public String getDescription() {
        return this.getI18NBean().getText("admin.integrity.check.filter.subscriptions.trigger.desc");
    }

    @Override
    protected void doRealCheck(boolean correct, GenericValue subscription, List<DeleteEntityAmendment> messages) throws IntegrityException {
        GenericValue trigger = this.getTriggerGV(subscription);
        if (trigger == null) {
            if (correct) {
                messages.add(new DeleteEntityAmendment(0, this.getI18NBean().getText("admin.integrity.check.filter.subscriptions.trigger.message", subscription.getString("id")), subscription));
            } else {
                messages.add(new DeleteEntityAmendment(2, this.getI18NBean().getText("admin.integrity.check.filter.subscriptions.trigger.preview", subscription.getString("id")), subscription));
            }
        }
    }

    private GenericValue getTriggerGV(GenericValue subscription) {
        List vals = this.ofBizDelegator.findByAnd("QRTZTriggers", (Map)ImmutableMap.of((Object)"triggerName", (Object)("SUBSCRIPTION_" + subscription.getString("id"))));
        if (vals != null && vals.size() == 1) {
            return (GenericValue)vals.get(0);
        }
        return null;
    }
}

