/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.appconsistency.integrity.check;

import com.atlassian.jira.appconsistency.integrity.amendment.DeleteEntityAmendment;
import com.atlassian.jira.appconsistency.integrity.check.BaseFilterSubscriptionsCheck;
import com.atlassian.jira.appconsistency.integrity.exception.IntegrityException;
import com.atlassian.jira.bc.JiraServiceContext;
import com.atlassian.jira.bc.JiraServiceContextImpl;
import com.atlassian.jira.bc.filter.SearchRequestService;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.issue.search.SearchRequest;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.user.ApplicationUser;
import java.util.List;
import org.apache.log4j.Logger;
import org.ofbiz.core.entity.GenericValue;

public class FilterSubscriptionsSavedFilterCheck
extends BaseFilterSubscriptionsCheck {
    private static final Logger log = Logger.getLogger(FilterSubscriptionsSavedFilterCheck.class);

    public FilterSubscriptionsSavedFilterCheck(OfBizDelegator ofBizDelegator, int id) {
        super(ofBizDelegator, id);
    }

    @Override
    public String getDescription() {
        return this.getI18NBean().getText("admin.integrity.check.filter.subscriptions.trigger.saved.filter.desc");
    }

    @Override
    protected void doRealCheck(boolean correct, GenericValue subscription, List<DeleteEntityAmendment> messages) throws IntegrityException {
        SearchRequest sr = this.getSearchRequest(subscription);
        if (sr == null) {
            if (correct) {
                messages.add(new DeleteEntityAmendment(0, this.getI18NBean().getText("admin.integrity.check.filter.subscriptions.trigger.saved.filter.message", subscription.getString("id")), subscription));
            } else {
                messages.add(new DeleteEntityAmendment(2, this.getI18NBean().getText("admin.integrity.check.filter.subscriptions.trigger.saved.filter.preview", subscription.getString("id")), subscription));
            }
        }
    }

    private SearchRequest getSearchRequest(GenericValue subscription) {
        ApplicationUser subscriptionUser = this.getSubscriptionUser(subscription);
        if (subscriptionUser == null) {
            log.warn((Object)("Problem retreiving user '" + subscription.getString("username") + "' for subscription"));
            return null;
        }
        JiraServiceContextImpl ctx = new JiraServiceContextImpl(subscriptionUser);
        SearchRequest filter = ((SearchRequestService)ComponentAccessor.getComponent(SearchRequestService.class)).getFilter((JiraServiceContext)ctx, subscription.getLong("filterID"));
        if (ctx.getErrorCollection().hasAnyErrors()) {
            if (!ctx.getErrorCollection().getErrorMessages().isEmpty()) {
                log.warn((Object)("Problem retreiving filter for subscription: " + ctx.getErrorCollection().getErrorMessages()));
            }
            if (!ctx.getErrorCollection().getErrors().isEmpty()) {
                log.warn((Object)("Problem retreiving filter for subscription: " + ctx.getErrorCollection().getErrors()));
            }
        }
        return filter;
    }

    private ApplicationUser getSubscriptionUser(GenericValue subscription) {
        return ComponentAccessor.getUserManager().getUserByKey(subscription.getString("username"));
    }
}

