/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.appconsistency.integrity.check;

import com.atlassian.jira.appconsistency.integrity.amendment.Amendment;
import com.atlassian.jira.appconsistency.integrity.check.EntityCheckImpl;
import com.atlassian.jira.appconsistency.integrity.exception.IntegrityException;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.ofbiz.OfBizListIterator;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.log4j.Logger;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;

public abstract class AbstractEntityRelation<T extends Amendment>
extends EntityCheckImpl<T> {
    private final String relationType;
    private final String relationName;
    private static final Logger log = Logger.getLogger(AbstractEntityRelation.class);

    public AbstractEntityRelation(OfBizDelegator ofBizDelegator, int id, String relationType, String relationName) {
        super(ofBizDelegator, id);
        this.relationType = relationType;
        this.relationName = relationName;
    }

    protected String getRelationType() {
        return this.relationType;
    }

    protected String getRelationName() {
        return this.relationName;
    }

    @Override
    public List<T> preview() throws IntegrityException {
        OfBizListIterator allEntities = null;
        ArrayList result = Lists.newArrayList();
        try {
            allEntities = this.getEntities(this.getEntityName());
            GenericValue entity = allEntities.next();
            while (entity != null) {
                try {
                    GenericValue relatedEntity = entity.getRelatedOne(this.getRelationType() + this.getRelationName());
                    if (relatedEntity == null) {
                        result.add(this.previewAmendment(entity));
                    }
                }
                catch (GenericEntityException e) {
                    log.error((Object)e, (Throwable)e);
                }
                entity = allEntities.next();
            }
        }
        catch (Exception e) {
            throw new IntegrityException("Error occurred while performing check.", e);
        }
        finally {
            if (allEntities != null) {
                allEntities.close();
            }
        }
        return result;
    }

    protected abstract T previewAmendment(GenericValue var1);

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }
}

