/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.appconsistency.db;

import com.atlassian.jira.config.properties.JiraSystemProperties;
import com.atlassian.jira.startup.StartupCheck;
import com.google.common.base.Supplier;
import org.apache.log4j.Logger;
import org.ofbiz.core.entity.config.DatasourceInfo;

public class PublicSchemaConfigCheck
implements StartupCheck {
    private static final Logger log = Logger.getLogger(PublicSchemaConfigCheck.class);
    private static final String FIELD_TYPE_NAME_HSQL = "hsql";
    private static final String SCHEMA_PUBLIC = "PUBLIC";
    private static final String KEY_PUBLIC_SCHEMA_CONFIG_DISABLED = "atlassian.jira.dbcheck.publicschemaconfig.disabled";
    private static final String URL_DOCS = "http://www.atlassian.com/software/jira/docs/latest/databases/index.html";
    private Supplier<DatasourceInfo> datasourceInfoSupplier;

    public PublicSchemaConfigCheck(Supplier<DatasourceInfo> datasourceInfoSupplier) {
        this.datasourceInfoSupplier = datasourceInfoSupplier;
    }

    @Override
    public String getName() {
        return "Schema and field-type-name config in entityengine.xml";
    }

    @Override
    public boolean isOk() {
        if (Boolean.valueOf(JiraSystemProperties.getInstance().getProperty(KEY_PUBLIC_SCHEMA_CONFIG_DISABLED)).booleanValue()) {
            log.info((Object)"Disabling public schema config check");
        } else {
            DatasourceInfo dsi = (DatasourceInfo)this.datasourceInfoSupplier.get();
            if (dsi != null) {
                String fieldTypeName = dsi.getFieldTypeName();
                String schemaName = dsi.getSchemaName();
                if (SCHEMA_PUBLIC.equals(schemaName)) {
                    return FIELD_TYPE_NAME_HSQL.equals(fieldTypeName);
                }
            } else {
                log.error((Object)"Could not read the datasource info!");
            }
        }
        return true;
    }

    @Override
    public String getFaultDescription() {
        return "You have an error in your dbconfig.xml file.\nThe schema-name=\"PUBLIC\" only works for a field-type-name of \"hsql\".\nPlease refer to the JIRA database documentation at the following URL: http://www.atlassian.com/software/jira/docs/latest/databases/index.html";
    }

    @Override
    public String getHTMLFaultDescription() {
        return "<p>You have an error in your dbconfig.xml file. The schema-name=\"PUBLIC\" only works for a field-type-name of \"hsql\". Please refer to the <a href=\"http://www.atlassian.com/software/jira/docs/latest/databases/index.html\">JIRA database documentation</a>.</p>";
    }

    @Override
    public void stop() {
    }

    public String toString() {
        return this.getName();
    }
}

