/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.action.admin;

import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.issue.subscription.SendFilterJob;
import com.atlassian.jira.ofbiz.FieldMap;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import java.sql.Timestamp;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;

public class OfBizDowngradeHandler {
    private static final Logger LOG = Logger.getLogger(OfBizDowngradeHandler.class);
    static final String SEND_FILTER_JOB = SendFilterJob.class.getName();
    static final String SEND_SUBSCRIPTION = "SEND_SUBSCRIPTION";
    static final String SUBSCRIPTION_PREFIX = "SUBSCRIPTION_";
    static final String SUBSCRIPTION_JOB_NAME = "com.atlassian.jira.issue.subscription.DefaultSubscriptionManager";
    static final String SUBSCRIPTION_JOB_ID_PREFIX = "com.atlassian.jira.issue.subscription.DefaultSubscriptionManager:";
    static final String JOB_DETAILS_62 = "QRTZJobDetails";
    static final String TRIGGERS_62 = "QRTZTriggers";
    static final String CRON_TRIGGERS_62 = "QRTZCronTriggers";
    static final String SIMPLE_TRIGGERS_62 = "QRTZSimpleTriggers";
    static final String JOB_DETAILS_63 = "JQRTZJobDetails";
    static final String TRIGGERS_63 = "JQRTZTriggers";
    static final String CRON_TRIGGERS_63 = "JQRTZCronTriggers";
    static final String SIMPLE_TRIGGERS_63 = "JQRTZSimpleTriggers";
    static final String TRIGGER_TYPE_CRON = "CRON";
    static final String TRIGGER_TYPE_SIMPLE = "SIMPLE";
    private final OfBizDelegator ofBizDelegator;

    public OfBizDowngradeHandler(OfBizDelegator ofBizDelegator) {
        this.ofBizDelegator = ofBizDelegator;
    }

    public void downgrade() {
        try {
            this.downgradeFilterSubscriptions();
        }
        catch (GenericEntityException gee) {
            throw new DataAccessException((Throwable)gee);
        }
    }

    private void downgradeFilterSubscriptions() throws GenericEntityException {
        if (this.ofBizDelegator.getDelegatorInterface().countAll(JOB_DETAILS_63) == 0) {
            LOG.debug((Object)"No jobs in the new tables; downgrade skipped.");
        } else {
            LOG.info((Object)"Downgrade: filter subscriptions");
            this.cleanOldSubscriptions();
            this.copyNewFilterSubscriptionsToOldTables();
        }
    }

    private void cleanOldSubscriptions() throws GenericEntityException {
        List sendFilterJobs = this.ofBizDelegator.findByAnd(JOB_DETAILS_62, (Map)FieldMap.build((String)"className", (Object)SEND_FILTER_JOB));
        if (sendFilterJobs == null || sendFilterJobs.isEmpty()) {
            return;
        }
        for (GenericValue sendFilterJob : sendFilterJobs) {
            this.cleanOldSubscriptionJob(sendFilterJob);
        }
    }

    private void cleanOldSubscriptionJob(GenericValue sendFilterJob) {
        long jobId = sendFilterJob.getLong("id");
        List sendFilterTriggers = this.ofBizDelegator.findByAnd(TRIGGERS_62, (Map)FieldMap.build((String)"job", (Object)jobId));
        if (sendFilterTriggers != null && !sendFilterTriggers.isEmpty()) {
            for (GenericValue sendFilterTrigger : sendFilterTriggers) {
                this.cleanOldSubscriptionTrigger(sendFilterTrigger);
            }
        }
        this.ofBizDelegator.removeById(JOB_DETAILS_62, Long.valueOf(jobId));
    }

    private void cleanOldSubscriptionTrigger(GenericValue sendFilterTrigger) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Removing old filter subscription '" + sendFilterTrigger.getString("triggerName") + '\''));
        }
        String triggerType = sendFilterTrigger.getString("triggerType");
        Long triggerId = sendFilterTrigger.getLong("id");
        if (TRIGGER_TYPE_CRON.equals(triggerType)) {
            this.ofBizDelegator.removeByAnd(CRON_TRIGGERS_62, (Map)FieldMap.build((String)"trigger", (Object)triggerId));
        } else if (TRIGGER_TYPE_SIMPLE.equals(triggerType)) {
            this.ofBizDelegator.removeByAnd(SIMPLE_TRIGGERS_62, (Map)FieldMap.build((String)"trigger", (Object)triggerId));
        } else {
            LOG.warn((Object)("Old subscription trigger '" + sendFilterTrigger.getString("triggerName") + "' has unexpected trigger type '" + triggerType + '\''));
        }
        this.ofBizDelegator.removeById(TRIGGERS_62, triggerId);
    }

    private void copyNewFilterSubscriptionsToOldTables() {
        Long jobId = this.createSendFilterJob();
        List triggers = this.ofBizDelegator.findByAnd(TRIGGERS_63, (Map)FieldMap.build((String)"jobName", (Object)SUBSCRIPTION_JOB_NAME));
        if (triggers == null || triggers.isEmpty()) {
            LOG.debug((Object)"No triggers to downgrade");
            return;
        }
        for (GenericValue trigger : triggers) {
            String triggerName = trigger.getString("triggerName");
            if (triggerName.startsWith(SUBSCRIPTION_JOB_ID_PREFIX)) {
                this.copyNewFilterSubscriptionToOldTables(trigger, jobId);
                continue;
            }
            LOG.warn((Object)("Subscription trigger '" + triggerName + "' is not named the expected way; ignoring it..."));
        }
    }

    private Long createSendFilterJob() {
        FieldMap fields = new FieldMap().add("jobGroup", (Object)SEND_SUBSCRIPTION).add("jobName", (Object)SEND_SUBSCRIPTION).add("className", (Object)SEND_FILTER_JOB).add("isDurable", (Object)"true").add("isStateful", (Object)"false").add("requestsRecovery", (Object)"false");
        GenericValue job = this.ofBizDelegator.createValue(JOB_DETAILS_62, (Map)fields);
        return job.getLong("id");
    }

    private void copyNewFilterSubscriptionToOldTables(GenericValue triggerTemplate, Long jobId) {
        String triggerType = triggerTemplate.getString("triggerType");
        if (TRIGGER_TYPE_CRON.equals(triggerType)) {
            this.copyNewCronFilterSubscriptionToOldTables(triggerTemplate, jobId);
        } else if (TRIGGER_TYPE_SIMPLE.equals(triggerType)) {
            this.copyNewSimpleFilterSubscriptionToOldTables(triggerTemplate, jobId);
        } else {
            LOG.warn((Object)("Filter subscription '" + triggerTemplate.getString("triggerName") + "' has unexpected trigger type '" + triggerType + '\''));
        }
    }

    private Long createFilterSubscriptionTrigger(GenericValue triggerTemplate, Long jobId) {
        FieldMap values = new FieldMap();
        String copiedTriggerName = triggerTemplate.getString("triggerName");
        String triggerName = SUBSCRIPTION_PREFIX + copiedTriggerName.substring(SUBSCRIPTION_JOB_ID_PREFIX.length());
        values.put((Object)"triggerGroup", (Object)SEND_SUBSCRIPTION);
        values.put((Object)"triggerName", (Object)triggerName);
        values.put((Object)"job", (Object)jobId);
        OfBizDowngradeHandler.putTimestamp(values, "nextFire", triggerTemplate.getLong("nextFireTime"));
        values.put((Object)"triggerState", (Object)triggerTemplate.getString("triggerState"));
        values.put((Object)"triggerType", (Object)triggerTemplate.getString("triggerType"));
        OfBizDowngradeHandler.putTimestamp(values, "startTime", triggerTemplate.getLong("startTime"));
        OfBizDowngradeHandler.putTimestamp(values, "endTime", triggerTemplate.getLong("endTime"));
        values.put((Object)"calendarName", (Object)triggerTemplate.getString("calendarName"));
        values.put((Object)"misfireInstr", (Object)triggerTemplate.getInteger("misfireInstr"));
        return this.ofBizDelegator.createValue(TRIGGERS_62, (Map)values).getLong("id");
    }

    private void copyNewCronFilterSubscriptionToOldTables(GenericValue triggerTemplate, Long jobId) {
        String triggerName = triggerTemplate.getString("triggerName");
        List cronTriggers = this.ofBizDelegator.findByAnd(CRON_TRIGGERS_63, (Map)FieldMap.build((String)"triggerGroup", (Object)triggerTemplate.getString("triggerGroup"), (String)"triggerName", (Object)triggerName));
        if (cronTriggers == null || cronTriggers.isEmpty()) {
            LOG.warn((Object)("Unable to copy cron trigger '" + triggerName + "' because its cron trigger details are missing"));
            return;
        }
        GenericValue cronTrigger = (GenericValue)cronTriggers.get(0);
        Long triggerId = this.createFilterSubscriptionTrigger(triggerTemplate, jobId);
        this.ofBizDelegator.createValue(CRON_TRIGGERS_62, (Map)FieldMap.build((String)"trigger", (Object)triggerId, (String)"cronExpression", (Object)cronTrigger.getString("cronExpression")));
    }

    private void copyNewSimpleFilterSubscriptionToOldTables(GenericValue triggerTemplate, Long jobId) {
        String triggerName = triggerTemplate.getString("triggerName");
        List simpleTriggers = this.ofBizDelegator.findByAnd(SIMPLE_TRIGGERS_63, (Map)FieldMap.build((String)"triggerGroup", (Object)triggerTemplate.getString("triggerGroup"), (String)"triggerName", (Object)triggerName));
        if (simpleTriggers == null || simpleTriggers.isEmpty()) {
            LOG.warn((Object)("Unable to copy simple trigger '" + triggerName + "' because its simple trigger details are missing"));
            return;
        }
        GenericValue simpleTrigger = (GenericValue)simpleTriggers.get(0);
        Long triggerId = this.createFilterSubscriptionTrigger(triggerTemplate, jobId);
        this.ofBizDelegator.createValue(SIMPLE_TRIGGERS_62, (Map)new FieldMap().add("trigger", (Object)triggerId).add("repeatCount", (Object)OfBizDowngradeHandler.toInteger(simpleTrigger.getLong("repeatCount"))).add("repeatInterval", (Object)simpleTrigger.getLong("repeatInterval")).add("timesTriggered", (Object)OfBizDowngradeHandler.toInteger(simpleTrigger.getLong("timesTriggered"))));
    }

    private static Integer toInteger(Long value) {
        return value != null ? Integer.valueOf(value.intValue()) : null;
    }

    private static void putTimestamp(FieldMap values, String key, Long millis) {
        if (millis != null && millis != 0L) {
            values.put((Object)key, (Object)new Timestamp(millis));
        }
    }
}

