/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira;

import com.atlassian.annotations.Internal;
import com.atlassian.core.util.ClassLoaderUtils;
import com.atlassian.crowd.embedded.api.CrowdService;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.BootstrapContainerRegistrar;
import com.atlassian.jira.ComponentContainer;
import com.atlassian.jira.ComponentManagerStateImpl;
import com.atlassian.jira.ContainerRegistrar;
import com.atlassian.jira.EventComponent;
import com.atlassian.jira.InfrastructureException;
import com.atlassian.jira.InitializingComponent;
import com.atlassian.jira.WrappedComponentContainer;
import com.atlassian.jira.avatar.AvatarManager;
import com.atlassian.jira.bc.filter.SearchRequestAdminService;
import com.atlassian.jira.bc.filter.SearchRequestService;
import com.atlassian.jira.bc.issue.IssueService;
import com.atlassian.jira.bc.issue.search.SearchService;
import com.atlassian.jira.bc.portal.PortalPageService;
import com.atlassian.jira.bc.project.component.ProjectComponentManager;
import com.atlassian.jira.bulkedit.BulkOperationManager;
import com.atlassian.jira.config.ConstantsManager;
import com.atlassian.jira.config.SubTaskManager;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.config.util.AttachmentPathManager;
import com.atlassian.jira.config.util.IndexPathManager;
import com.atlassian.jira.diagnostic.PluginDiagnostics;
import com.atlassian.jira.event.ComponentManagerShutdownEvent;
import com.atlassian.jira.event.ComponentManagerStartedEvent;
import com.atlassian.jira.event.type.EventTypeManager;
import com.atlassian.jira.extension.ContainerProvider;
import com.atlassian.jira.extension.Startable;
import com.atlassian.jira.issue.AttachmentManager;
import com.atlassian.jira.issue.CustomFieldManager;
import com.atlassian.jira.issue.IssueFactory;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.RendererManager;
import com.atlassian.jira.issue.changehistory.ChangeHistoryManager;
import com.atlassian.jira.issue.comments.CommentManager;
import com.atlassian.jira.issue.fields.FieldManager;
import com.atlassian.jira.issue.fields.config.manager.IssueTypeSchemeManager;
import com.atlassian.jira.issue.fields.layout.column.ColumnLayoutManager;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutManager;
import com.atlassian.jira.issue.fields.screen.FieldScreenManager;
import com.atlassian.jira.issue.fields.screen.FieldScreenRendererFactory;
import com.atlassian.jira.issue.fields.screen.FieldScreenSchemeManager;
import com.atlassian.jira.issue.fields.screen.issuetype.IssueTypeScreenSchemeManager;
import com.atlassian.jira.issue.index.IssueIndexManager;
import com.atlassian.jira.issue.link.IssueLinkManager;
import com.atlassian.jira.issue.search.SearchProvider;
import com.atlassian.jira.issue.search.SearchRequestFactory;
import com.atlassian.jira.issue.search.SearchRequestManager;
import com.atlassian.jira.issue.util.IssueUpdater;
import com.atlassian.jira.issue.vote.VoteManager;
import com.atlassian.jira.issue.watchers.WatcherManager;
import com.atlassian.jira.issue.worklog.WorklogManager;
import com.atlassian.jira.mail.MailingListCompiler;
import com.atlassian.jira.mail.SubscriptionMailQueueItemFactory;
import com.atlassian.jira.movesubtask.MoveSubTaskOperationManager;
import com.atlassian.jira.permission.PermissionContextFactory;
import com.atlassian.jira.permission.PermissionTypeManager;
import com.atlassian.jira.permission.SchemePermissions;
import com.atlassian.jira.plugin.ComponentClassManager;
import com.atlassian.jira.plugin.JiraOsgiContainerManager;
import com.atlassian.jira.plugin.assignee.AssigneeResolver;
import com.atlassian.jira.plugin.component.ComponentModuleDescriptor;
import com.atlassian.jira.portal.PortalPageManager;
import com.atlassian.jira.project.ProjectFactory;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.project.version.VersionManager;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.startup.JiraStartupChecklist;
import com.atlassian.jira.task.TaskManager;
import com.atlassian.jira.template.TemplateManager;
import com.atlassian.jira.upgrade.UpgradeManager;
import com.atlassian.jira.upgrade.UpgradeManagerImpl;
import com.atlassian.jira.user.UserPropertyManager;
import com.atlassian.jira.user.preferences.UserPreferencesManager;
import com.atlassian.jira.user.util.UserUtil;
import com.atlassian.jira.util.JiraDurationUtils;
import com.atlassian.jira.util.Shutdown;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.jira.util.index.IndexLifecycleManager;
import com.atlassian.jira.web.action.admin.translation.TranslationManager;
import com.atlassian.jira.web.action.issue.IssueCreationHelperBean;
import com.atlassian.jira.web.util.FileIconBean;
import com.atlassian.jira.web.util.JiraLocaleUtils;
import com.atlassian.jira.web.util.OutlookDateManager;
import com.atlassian.jira.workflow.WorkflowManager;
import com.atlassian.jira.workflow.WorkflowSchemeManager;
import com.atlassian.mail.server.MailServerManager;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.PluginController;
import com.atlassian.plugin.PluginSystemLifecycle;
import com.atlassian.plugin.event.NotificationException;
import com.atlassian.plugin.event.PluginEventManager;
import com.atlassian.plugin.osgi.container.OsgiContainerManager;
import com.atlassian.plugin.webresource.WebResourceManager;
import com.atlassian.security.auth.trustedapps.TrustedApplicationsManager;
import com.atlassian.velocity.VelocityManager;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Sets;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.GuardedBy;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.codehaus.jackson.map.type.TypeBindings;
import org.codehaus.jackson.map.type.TypeFactory;
import org.joda.time.DateTime;
import org.osgi.util.tracker.ServiceTracker;
import org.picocontainer.ComponentAdapter;
import org.picocontainer.MutablePicoContainer;
import org.picocontainer.Parameter;
import org.picocontainer.PicoContainer;

@Internal
public class ComponentManager
implements Shutdown {
    public static final String EXTENSION_PROVIDER_PROPERTY = "jira.extension.container.provider";
    private static final Logger log = Logger.getLogger(ComponentManager.class);
    private static final ComponentManager COMPONENT_MANAGER = new ComponentManager();
    private volatile WrappedComponentContainer container;
    private final PluginSystem pluginSystem = new PluginSystem();
    private volatile ComponentManagerStateImpl state = ComponentManagerStateImpl.NOT_STARTED;

    ComponentManager() {
    }

    public void bootstrapInitialise() {
        this.initComponentContainer(true, "BootstrapContainer");
        new BootstrapContainerRegistrar().registerComponents(this.container.getComponentContainer());
        this.changeState(ComponentManagerStateImpl.CONTAINER_INITIALISED);
    }

    @VisibleForTesting
    void initialise(boolean useEagerInitialization) {
        this.registerComponents(useEagerInitialization);
        this.registerExtensions();
        this.runInitializingComponents();
        this.changeState(ComponentManagerStateImpl.CONTAINER_INITIALISED);
    }

    public void initialise() {
        this.initialise(true);
    }

    public synchronized void start() {
        this.quickStart();
        this.eagerlyInstantiate();
    }

    private void quickStart() {
        TypeFactory.instance.constructType(HashMap.class, (TypeBindings)null);
        ComponentManager.getComponent(PluginDiagnostics.class);
        this.pluginSystem.start();
        this.changeState(ComponentManagerStateImpl.PLUGINSYSTEM_STARTED);
        PluginAccessor pluginAccessor = this.getPluginAccessor();
        List funNewComponents = pluginAccessor.getEnabledModuleDescriptorsByClass(ComponentModuleDescriptor.class);
        if (!funNewComponents.isEmpty()) {
            for (ComponentModuleDescriptor componentModuleDescriptor : funNewComponents) {
                componentModuleDescriptor.registerComponents(this.container.getPicoContainer());
            }
        }
        this.container.getPicoContainer().addComponent((Object)pluginAccessor.getClassLoader());
        this.changeState(ComponentManagerStateImpl.COMPONENTS_REGISTERED);
        this.runStartable();
        this.registerEventComponents();
        this.changeState(ComponentManagerStateImpl.STARTED);
        ComponentManager.getComponent(EventPublisher.class).publish((Object)ComponentManagerStartedEvent.INSTANCE);
    }

    private void initComponentContainer(boolean useEagerInitialization, String name) {
        if (this.container != null) {
            throw new IllegalStateException("Component container is already initialized");
        }
        this.container = new WrappedComponentContainer(new ComponentContainer(useEagerInitialization));
        this.container.getPicoContainer().setName(name + "_" + DateTime.now().toString());
    }

    private void registerEventComponents() {
        EventPublisher eventPublisher = ComponentManager.getComponent(EventPublisher.class);
        Set registeredListeners = Sets.newIdentityHashSet();
        Collection componentAdapters = this.getContainer().getComponentAdapters();
        for (ComponentAdapter componentAdapter : componentAdapters) {
            Object instance;
            Class componentKey = componentAdapter.getComponentImplementation();
            if (componentKey.getAnnotation(EventComponent.class) == null || !registeredListeners.add(instance = componentAdapter.getComponentInstance((PicoContainer)this.container.getPicoContainer()))) continue;
            eventPublisher.register(instance);
        }
    }

    private void runInitializingComponents() {
        List components = this.getContainer().getComponents(InitializingComponent.class);
        for (InitializingComponent component : components) {
            try {
                component.afterInstantiation();
            }
            catch (Exception e) {
                log.error((Object)("Error occurred while initializing component '" + component.getClass().getName() + "'."), (Throwable)e);
                throw new InfrastructureException("Error occurred while initializing component '" + component.getClass().getName() + "'.", e);
            }
        }
    }

    private void runStartable() {
        List startables = this.getContainer().getComponents(Startable.class);
        for (Startable startable : startables) {
            try {
                if (startable instanceof PluginSystemLifecycle) continue;
                startable.start();
            }
            catch (Exception e) {
                log.error((Object)("Error occurred while starting component '" + startable.getClass().getName() + "'."), (Throwable)e);
                throw new InfrastructureException("Error occurred while starting component '" + startable.getClass().getName() + "'.", e);
            }
        }
    }

    public synchronized void stop() {
        ComponentManager.getComponent(EventPublisher.class).publish((Object)ComponentManagerShutdownEvent.INSTANCE);
        this.pluginSystem.shutdown();
    }

    public void dispose() {
        PropertyUtils.clearDescriptors();
        this.changeState(ComponentManagerStateImpl.NOT_STARTED);
        if (this.container != null) {
            this.container.dispose();
            this.container = null;
        }
        this.gc();
    }

    public void shutdown() {
        this.stop();
        this.dispose();
    }

    public void gc() {
        int count = 0;
        Object obj = new Object();
        WeakReference<Object> ref = new WeakReference<Object>(obj);
        obj = null;
        while (count < 10 && ref.get() != null) {
            log.debug((Object)("Attempting to do a garbage collection:" + ++count));
            System.gc();
        }
    }

    public State getState() {
        return this.state;
    }

    @GuardedBy(value="this")
    private void eagerlyInstantiate() {
        this.container.getComponentContainer().initializeEagerComponents();
    }

    private void registerExtensions() {
        ApplicationProperties applicationProperties = this.container.getComponentContainer().getComponentInstance(ApplicationProperties.class);
        String extensionClassName = applicationProperties.getDefaultBackedString(EXTENSION_PROVIDER_PROPERTY);
        try {
            if (!StringUtils.isBlank((String)extensionClassName)) {
                this.container.wrapWith((ContainerProvider)ClassLoaderUtils.loadClass((String)extensionClassName, this.getClass()).newInstance());
            }
        }
        catch (Exception extensionClassLoadingException) {
            throw new RuntimeException(String.format("Error loading PICO extension provider container class with name '%s'", extensionClassName), extensionClassLoadingException);
        }
    }

    public PicoContainer getContainer() {
        if (this.container == null) {
            return null;
        }
        return this.container.getPicoContainer();
    }

    public MutablePicoContainer getMutablePicoContainer() {
        if (this.container == null) {
            return null;
        }
        return this.container.getPicoContainer();
    }

    private void registerComponents(boolean useEagerInitialization) {
        this.initComponentContainer(useEagerInitialization, "JIRAContainer");
        new ContainerRegistrar().registerComponents(this.container.getComponentContainer(), JiraStartupChecklist.startupOK());
    }

    private ComponentManagerStateImpl changeState(ComponentManagerStateImpl newState) {
        ComponentManagerStateImpl currentState = this.state;
        if (newState != ComponentManagerStateImpl.NOT_STARTED && newState.ordinal() != currentState.ordinal() + 1) {
            throw new IllegalStateException(String.format("Cannot change ComponentManager status from %s to %s", currentState.name(), newState.name()));
        }
        this.state = newState;
        return currentState;
    }

    public WebResourceManager getWebResourceManager() {
        return (WebResourceManager)this.getContainer().getComponent(WebResourceManager.class);
    }

    public AttachmentManager getAttachmentManager() {
        return (AttachmentManager)this.getContainer().getComponent(AttachmentManager.class);
    }

    public VersionManager getVersionManager() {
        return (VersionManager)this.getContainer().getComponent(VersionManager.class);
    }

    public BulkOperationManager getBulkOperationManager() {
        return (BulkOperationManager)this.getContainer().getComponent(BulkOperationManager.class);
    }

    public MoveSubTaskOperationManager getMoveSubTaskOperationManager() {
        return (MoveSubTaskOperationManager)this.getContainer().getComponent(MoveSubTaskOperationManager.class);
    }

    public static ComponentManager getInstance() {
        return COMPONENT_MANAGER;
    }

    public static <T> T getComponentInstanceOfType(Class<T> clazz) {
        T component = ComponentManager.getComponent(clazz);
        if (component != null) {
            return component;
        }
        component = clazz.cast(ComponentManager.getInstance().getContainer().getComponent(clazz));
        if (component != null) {
            if (log.isDebugEnabled()) {
                try {
                    throw new IllegalArgumentException();
                }
                catch (IllegalArgumentException ex) {
                    log.warn((Object)("Unable to find component with key '" + clazz + "' - eventually found '" + component + "' the slow way."), (Throwable)ex);
                }
            } else {
                log.warn((Object)("Unable to find component with key '" + clazz + "' - eventually found '" + component + "' the slow way."));
            }
        }
        return component;
    }

    public static <T> T getComponent(Class<T> clazz) {
        return clazz.cast(ComponentManager.getInstance().getContainer().getComponent(clazz));
    }

    public static <T> T getOSGiComponentInstanceOfType(Class<T> clazz) {
        Assertions.notNull((String)"class", clazz);
        OsgiContainerManager osgiContainerManager = ComponentManager.getComponentInstanceOfType(OsgiContainerManager.class);
        if (osgiContainerManager != null) {
            if (osgiContainerManager instanceof JiraOsgiContainerManager) {
                return ((JiraOsgiContainerManager)osgiContainerManager).getOsgiComponentOfType(clazz);
            }
            return ComponentManager.getOsgiComponentOfType(clazz, osgiContainerManager);
        }
        return null;
    }

    public static <T> List<T> getComponentsOfType(Class<T> clazz) {
        PicoContainer pico = ComponentManager.getInstance().getContainer();
        List adapters = pico.getComponentAdapters(clazz);
        if (adapters.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<T> returnList = new ArrayList<T>(adapters.size());
        for (ComponentAdapter adapter : adapters) {
            returnList.add(clazz.cast(adapter.getComponentInstance(pico)));
        }
        return Collections.unmodifiableList(returnList);
    }

    public static <T> Map<String, T> getComponentsOfTypeMap(Class<T> iface) {
        PicoContainer picoContainer = ComponentManager.getInstance().getContainer();
        List componentAdaptersOfType = picoContainer.getComponentAdapters(iface);
        HashMap<String, T> implementations = new HashMap<String, T>();
        for (ComponentAdapter componentAdapter : componentAdaptersOfType) {
            T componentInstance = iface.cast(componentAdapter.getComponentInstance(picoContainer));
            implementations.put(String.valueOf(componentAdapter.getComponentKey()), componentInstance);
        }
        return Collections.unmodifiableMap(implementations);
    }

    public IssueUpdater getIssueUpdater() {
        return (IssueUpdater)this.getContainer().getComponent(IssueUpdater.class);
    }

    public IssueCreationHelperBean getIssueCreationHelperBean() {
        return (IssueCreationHelperBean)this.getContainer().getComponent(IssueCreationHelperBean.class);
    }

    public FileIconBean getFileIconBean() {
        return (FileIconBean)this.getContainer().getComponent(FileIconBean.class);
    }

    public IssueManager getIssueManager() {
        return ComponentManager.getComponentInstanceOfType(IssueManager.class);
    }

    public WorkflowManager getWorkflowManager() {
        return (WorkflowManager)this.getContainer().getComponent(WorkflowManager.class);
    }

    public WorklogManager getWorklogManager() {
        return (WorklogManager)this.getContainer().getComponent(WorklogManager.class);
    }

    public IssueFactory getIssueFactory() {
        return (IssueFactory)this.getContainer().getComponent(IssueFactory.class);
    }

    public ProjectFactory getProjectFactory() {
        return (ProjectFactory)this.getContainer().getComponent(ProjectFactory.class);
    }

    public ConstantsManager getConstantsManager() {
        return (ConstantsManager)this.getContainer().getComponent(ConstantsManager.class);
    }

    public FieldManager getFieldManager() {
        return (FieldManager)this.getContainer().getComponent(FieldManager.class);
    }

    public CustomFieldManager getCustomFieldManager() {
        return (CustomFieldManager)this.getContainer().getComponent(CustomFieldManager.class);
    }

    public IssueTypeSchemeManager getIssueTypeSchemeManager() {
        return (IssueTypeSchemeManager)this.getContainer().getComponent(IssueTypeSchemeManager.class);
    }

    public IssueTypeScreenSchemeManager getIssueTypeScreenSchemeManager() {
        return (IssueTypeScreenSchemeManager)this.getContainer().getComponent(IssueTypeScreenSchemeManager.class);
    }

    public SubTaskManager getSubTaskManager() {
        return (SubTaskManager)this.getContainer().getComponent(SubTaskManager.class);
    }

    public IssueLinkManager getIssueLinkManager() {
        return (IssueLinkManager)this.getContainer().getComponent(IssueLinkManager.class);
    }

    public ApplicationProperties getApplicationProperties() {
        return (ApplicationProperties)this.getContainer().getComponent(ApplicationProperties.class);
    }

    public CrowdService getCrowdService() {
        return (CrowdService)this.getContainer().getComponent(CrowdService.class);
    }

    public PermissionManager getPermissionManager() {
        return (PermissionManager)this.getContainer().getComponent(PermissionManager.class);
    }

    public PermissionTypeManager getPermissionTypeManager() {
        return (PermissionTypeManager)this.getContainer().getComponent(PermissionTypeManager.class);
    }

    public FieldLayoutManager getFieldLayoutManager() {
        return (FieldLayoutManager)this.getContainer().getComponent(FieldLayoutManager.class);
    }

    public ColumnLayoutManager getColumnLayoutManager() {
        return (ColumnLayoutManager)this.getContainer().getComponent(ColumnLayoutManager.class);
    }

    public ProjectManager getProjectManager() {
        return (ProjectManager)this.getContainer().getComponent(ProjectManager.class);
    }

    public VoteManager getVoteManager() {
        return (VoteManager)this.getContainer().getComponent(VoteManager.class);
    }

    public JiraLocaleUtils getJiraLocaleUtils() {
        return (JiraLocaleUtils)((Object)this.getContainer().getComponent(JiraLocaleUtils.class));
    }

    public PluginSystemLifecycle getPluginSystemLifecycle() {
        return this.pluginSystem.getPluginSystemLifecycle();
    }

    public PluginAccessor getPluginAccessor() {
        return (PluginAccessor)this.getContainer().getComponent(PluginAccessor.class);
    }

    public PluginEventManager getPluginEventManager() {
        return (PluginEventManager)this.getContainer().getComponent(PluginEventManager.class);
    }

    public ComponentClassManager getComponentClassManager() {
        return (ComponentClassManager)this.getContainer().getComponent(ComponentClassManager.class);
    }

    public PluginController getPluginController() {
        return (PluginController)this.getContainer().getComponent(PluginController.class);
    }

    public UpgradeManager getUpgradeManager() {
        return (UpgradeManager)this.getContainer().getComponent(UpgradeManager.class);
    }

    public RendererManager getRendererManager() {
        return (RendererManager)this.getContainer().getComponent(RendererManager.class);
    }

    public FieldScreenRendererFactory getFieldScreenRendererFactory() {
        return (FieldScreenRendererFactory)this.getContainer().getComponent(FieldScreenRendererFactory.class);
    }

    public WorkflowSchemeManager getWorkflowSchemeManager() {
        return (WorkflowSchemeManager)this.getContainer().getComponent(WorkflowSchemeManager.class);
    }

    public IndexLifecycleManager getIndexLifecycleManager() {
        return (IndexLifecycleManager)this.getContainer().getComponent(IndexLifecycleManager.class);
    }

    public IssueIndexManager getIndexManager() {
        return (IssueIndexManager)this.getContainer().getComponent(IssueIndexManager.class);
    }

    public IssueService getIssueService() {
        return ComponentManager.getComponentInstanceOfType(IssueService.class);
    }

    public IndexPathManager getIndexPathManager() {
        return ComponentManager.getComponentInstanceOfType(IndexPathManager.class);
    }

    public AttachmentPathManager getAttachmentPathManager() {
        return ComponentManager.getComponentInstanceOfType(AttachmentPathManager.class);
    }

    public TranslationManager getTranslationManager() {
        return (TranslationManager)this.getContainer().getComponent(TranslationManager.class);
    }

    public JiraAuthenticationContext getJiraAuthenticationContext() {
        return (JiraAuthenticationContext)this.getContainer().getComponent(JiraAuthenticationContext.class);
    }

    public WatcherManager getWatcherManager() {
        return (WatcherManager)this.getContainer().getComponent(WatcherManager.class);
    }

    public SearchService getSearchService() {
        return (SearchService)this.getContainer().getComponent(SearchService.class);
    }

    public SearchProvider getSearchProvider() {
        return (SearchProvider)this.getContainer().getComponent(SearchProvider.class);
    }

    @Deprecated
    public SearchRequestManager getSearchRequestManager() {
        return (SearchRequestManager)this.getContainer().getComponent(SearchRequestManager.class);
    }

    public SearchRequestService getSearchRequestService() {
        return (SearchRequestService)this.getContainer().getComponent(SearchRequestService.class);
    }

    public SearchRequestAdminService getSearchRequestAdminService() {
        return (SearchRequestAdminService)this.getContainer().getComponent(SearchRequestAdminService.class);
    }

    public SearchRequestFactory getSearchRequestFactory() {
        return (SearchRequestFactory)this.getContainer().getComponent(SearchRequestFactory.class);
    }

    public FieldScreenManager getFieldScreenManager() {
        return (FieldScreenManager)this.getContainer().getComponent(FieldScreenManager.class);
    }

    public FieldScreenSchemeManager getFieldScreenSchemeManager() {
        return (FieldScreenSchemeManager)this.getContainer().getComponent(FieldScreenSchemeManager.class);
    }

    public SchemePermissions getSchemePermissions() {
        return (SchemePermissions)this.getContainer().getComponent(SchemePermissions.class);
    }

    public MailServerManager getMailServerManager() {
        return (MailServerManager)this.getContainer().getComponent(MailServerManager.class);
    }

    public EventTypeManager getEventTypeManager() {
        return (EventTypeManager)this.getContainer().getComponent(EventTypeManager.class);
    }

    public TemplateManager getTemplateManager() {
        return (TemplateManager)this.getContainer().getComponent(TemplateManager.class);
    }

    public UserUtil getUserUtil() {
        return (UserUtil)this.getContainer().getComponent(UserUtil.class);
    }

    public AssigneeResolver getAssigneeResolver() {
        return (AssigneeResolver)this.getContainer().getComponent(AssigneeResolver.class);
    }

    public MailingListCompiler getMailingListCompiler() {
        return (MailingListCompiler)this.getContainer().getComponent(MailingListCompiler.class);
    }

    public SubscriptionMailQueueItemFactory getSubscriptionMailQueueItemFactory() {
        return (SubscriptionMailQueueItemFactory)this.getContainer().getComponent(SubscriptionMailQueueItemFactory.class);
    }

    public VelocityManager getVelocityManager() {
        return (VelocityManager)this.getContainer().getComponent(VelocityManager.class);
    }

    public CommentManager getCommentManager() {
        return (CommentManager)this.getContainer().getComponent(CommentManager.class);
    }

    public void refreshUpgradeManager() {
        this.container.getPicoContainer().removeComponent(UpgradeManager.class);
        this.container.getPicoContainer().addComponent(UpgradeManager.class, UpgradeManagerImpl.class, new Parameter[0]);
    }

    public ProjectComponentManager getProjectComponentManager() {
        return (ProjectComponentManager)this.getContainer().getComponent(ProjectComponentManager.class);
    }

    public ChangeHistoryManager getChangeHistoryManager() {
        return (ChangeHistoryManager)this.getContainer().getComponent(ChangeHistoryManager.class);
    }

    public PermissionContextFactory getPermissionContextFactory() {
        return (PermissionContextFactory)this.getContainer().getComponent(PermissionContextFactory.class);
    }

    public UserPreferencesManager getUserPreferencesManager() {
        return (UserPreferencesManager)this.getContainer().getComponent(UserPreferencesManager.class);
    }

    public UserPropertyManager getUserPropertyManager() {
        return (UserPropertyManager)this.getContainer().getComponent(UserPropertyManager.class);
    }

    public JiraDurationUtils getJiraDurationUtils() {
        return (JiraDurationUtils)this.getContainer().getComponent(JiraDurationUtils.class);
    }

    public TaskManager getTaskManager() {
        return (TaskManager)this.getContainer().getComponent(TaskManager.class);
    }

    public TrustedApplicationsManager getTrustedApplicationsManager() {
        return (TrustedApplicationsManager)this.getContainer().getComponent(TrustedApplicationsManager.class);
    }

    public OutlookDateManager getOutlookDateManager() {
        return (OutlookDateManager)this.getContainer().getComponent(OutlookDateManager.class);
    }

    public PortalPageService getPortalPageService() {
        return (PortalPageService)this.getContainer().getComponent(PortalPageService.class);
    }

    public PortalPageManager getPortalPageManager() {
        return (PortalPageManager)this.getContainer().getComponent(PortalPageManager.class);
    }

    public AvatarManager getAvatarManager() {
        return (AvatarManager)this.getContainer().getComponent(AvatarManager.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T> T getOsgiComponentOfType(@Nonnull Class<T> clazz, @Nonnull OsgiContainerManager osgiContainerManager) {
        ServiceTracker serviceTracker;
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Using slow getOsgiComponentOfType() to get '%s'. COMPONENT MANAGER. Y U NO JiraOsgiContainerManager!?", clazz.getName()), new Throwable());
        }
        if ((serviceTracker = osgiContainerManager.getServiceTracker(clazz.getName())) != null) {
            try {
                T t = clazz.cast(serviceTracker.getService());
                return t;
            }
            finally {
                serviceTracker.close();
            }
        }
        return null;
    }

    public static interface State {
        public boolean isContainerInitialised();

        public boolean isPluginSystemStarted();

        public boolean isComponentsRegistered();

        public boolean isStarted();
    }

    private static class PluginSystem {
        volatile State state = State.NOT_STARTED;

        private PluginSystem() {
        }

        public PluginSystemLifecycle getPluginSystemLifecycle() {
            return ComponentManager.getComponentInstanceOfType(PluginSystemLifecycle.class);
        }

        void start() {
            if (this.state != State.NOT_STARTED) {
                return;
            }
            PluginSystemLifecycle pluginSystemLifecycle = this.getPluginSystemLifecycle();
            if (pluginSystemLifecycle instanceof Startable) {
                Startable startablePluginManager = (Startable)pluginSystemLifecycle;
                try {
                    startablePluginManager.start();
                }
                catch (NotificationException ex) {
                    Throwable cause = ex.getCause();
                    throw new InfrastructureException("Error occurred while starting Plugin Manager. " + cause.getMessage(), cause);
                }
                catch (Exception e) {
                    throw new InfrastructureException("Error occurred while starting Plugin Manager. " + e.getMessage(), e);
                }
            } else {
                throw new InfrastructureException("PluginManager does not implement startable anymore?!");
            }
            this.state = State.STARTED;
        }

        public void shutdown() {
            if (this.state != State.STARTED) {
                return;
            }
            try {
                this.getPluginSystemLifecycle().shutdown();
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
            this.state = State.NOT_STARTED;
        }

        static enum State {
            NOT_STARTED,
            STARTED;

        }
    }
}

