/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira;

import com.atlassian.cache.CacheManager;
import com.atlassian.cache.ehcache.EhCacheManager;
import com.atlassian.cache.memory.MemoryCacheManager;
import com.atlassian.jira.ComponentContainer;
import com.atlassian.jira.cluster.FailoverProperties;
import com.atlassian.jira.config.properties.JiraProperties;
import com.atlassian.jira.config.properties.JiraSystemProperties;
import com.google.common.annotations.VisibleForTesting;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class CacheManagerRegistrar {
    public static final String FORCE_EHCACHE = "atlassian.cache.ehcache";
    @VisibleForTesting
    static final ComponentContainer.Scope SCOPE = ComponentContainer.Scope.PROVIDED;
    @VisibleForTesting
    static final Class<CacheManager> KEY = CacheManager.class;
    private static final Logger LOGGER = LoggerFactory.getLogger(CacheManagerRegistrar.class);

    CacheManagerRegistrar() {
    }

    public static void registerCacheManager(ComponentContainer container) {
        JiraProperties jiraProperties = JiraSystemProperties.getInstance();
        FailoverProperties failoverProperties = container.getComponentInstance(FailoverProperties.class);
        boolean useEhcache = CacheManagerRegistrar.useEhcache(jiraProperties, failoverProperties);
        LOGGER.debug("Using Ehcache = {}", (Object)useEhcache);
        Object cacheManager = useEhcache ? new EhCacheManager() : new MemoryCacheManager();
        container.instance(SCOPE, KEY, cacheManager);
    }

    private static boolean useEhcache(JiraProperties jiraProperties, FailoverProperties failoverProperties) {
        boolean isEhCacheForced = jiraProperties.getBoolean(FORCE_EHCACHE);
        boolean isJiraClustered = failoverProperties.getNodeId() != null;
        return isEhCacheForced || isJiraClustered;
    }
}

