/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.configurable;

import com.atlassian.configurable.ObjectConfiguration;
import com.atlassian.configurable.ObjectConfigurationException;
import com.atlassian.configurable.ObjectConfigurationProperty;
import com.atlassian.configurable.ObjectDescriptor;
import com.opensymphony.util.TextUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.collections.map.ListOrderedMap;

public class ObjectConfigurationImpl
implements ObjectConfiguration {
    private final ObjectDescriptor od;
    private final Map<String, ObjectConfigurationProperty> configProperties = Collections.synchronizedMap(new ListOrderedMap());
    private final Map params = Collections.synchronizedMap(new ListOrderedMap());

    public ObjectConfigurationImpl(Map<String, ObjectConfigurationProperty> configProperties, ObjectDescriptor od) {
        this.configProperties.putAll(configProperties);
        this.od = od;
    }

    public void init(Map params) {
        this.params.clear();
        if (params != null) {
            this.params.putAll(params);
        }
    }

    public String getFieldName(String key) throws ObjectConfigurationException {
        if (this.configProperties.containsKey(key)) {
            return this.configProperties.get(key).getName();
        }
        throw new ObjectConfigurationException("Field with key: " + key + " does not exist.");
    }

    public String getFieldDescription(String key) throws ObjectConfigurationException {
        if (this.configProperties.containsKey(key)) {
            return this.configProperties.get(key).getDescription();
        }
        throw new ObjectConfigurationException("Field with key: " + key + " does not exist.");
    }

    public String getFieldDefault(String key) throws ObjectConfigurationException {
        if (this.configProperties.containsKey(key)) {
            return this.configProperties.get(key).getDefault();
        }
        throw new ObjectConfigurationException("Field with key: " + key + " does not exist.");
    }

    public int getFieldType(String key) throws ObjectConfigurationException {
        if (this.configProperties.containsKey(key)) {
            return new Integer(this.configProperties.get(key).getType());
        }
        throw new ObjectConfigurationException("Field with key: " + key + " does not exist.");
    }

    public Map getFieldValues(String key) throws ObjectConfigurationException {
        if (this.configProperties.containsKey(key)) {
            ObjectConfigurationProperty objectConfigurationProperty = this.configProperties.get(key);
            objectConfigurationProperty.init(this.params);
            return objectConfigurationProperty;
        }
        throw new ObjectConfigurationException("Field with key: " + key + " does not exist.");
    }

    public Map getFieldValuesHtmlEncoded(String key) throws ObjectConfigurationException {
        Map fieldValues = this.getFieldValues(key);
        ListOrderedMap htmlEncodedFieldValues = new ListOrderedMap();
        for (Map.Entry entry : fieldValues.entrySet()) {
            String htmlEncodedKey = TextUtils.htmlEncode((String)entry.getKey().toString());
            String htmlEncodedValue = TextUtils.htmlEncode((String)entry.getValue().toString());
            htmlEncodedFieldValues.put(htmlEncodedKey, htmlEncodedValue);
        }
        return htmlEncodedFieldValues;
    }

    public String[] getFieldKeys() {
        String[] returnValue = new String[this.configProperties.size()];
        int counter = 0;
        Iterator<String> i$ = this.configProperties.keySet().iterator();
        while (i$.hasNext()) {
            String key;
            returnValue[counter] = key = i$.next();
            ++counter;
        }
        return returnValue;
    }

    public String[] getEnabledFieldKeys() {
        ArrayList<String> returnValue = new ArrayList<String>();
        for (Map.Entry<String, ObjectConfigurationProperty> entry : this.configProperties.entrySet()) {
            if (!entry.getValue().isEnabled()) continue;
            returnValue.add(entry.getKey());
        }
        return returnValue.toArray(new String[returnValue.size()]);
    }

    public boolean isEnabled(String key) {
        ObjectConfigurationProperty property = this.configProperties.get(key);
        return property != null && property.isEnabled();
    }

    public String getDescription(Map params) {
        return this.od.getDescription(this.configProperties, params);
    }

    public boolean allFieldsHidden() {
        if (this.configProperties != null) {
            for (ObjectConfigurationProperty ocp : this.configProperties.values()) {
                if (ocp.getType() == 3) continue;
                return false;
            }
        }
        return true;
    }

    public boolean isI18NValues(String key) {
        return this.configProperties.containsKey(key) && this.configProperties.get(key).isI18nValues();
    }
}

