/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.workflow.migration;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.log4j.Logger;
import org.ofbiz.core.entity.GenericValue;

public class WorkflowMigrationMapping {
    private final Map<WorkflowMigrationMappingKey, GenericValue> mappings;
    private final Logger log = Logger.getLogger(this.getClass());
    private final Collection<Long> issuesIdsOnWrongWorkflow;

    public WorkflowMigrationMapping() {
        this.mappings = new HashMap<WorkflowMigrationMappingKey, GenericValue>();
        this.issuesIdsOnWrongWorkflow = new HashSet<Long>();
    }

    public void addMapping(GenericValue issueType, GenericValue oldStatus, GenericValue newStatus) {
        WorkflowMigrationMappingKey mappingKey = new WorkflowMigrationMappingKey(issueType, oldStatus);
        this.log.debug((Object)("Adding (type, oldstatus) -> newstatus mapping: " + mappingKey + " -> " + newStatus.getString("name")));
        this.mappings.put(mappingKey, newStatus);
    }

    public void addIssueIdsOnWorongWorkflow(Collection<Long> issueIds) {
        this.issuesIdsOnWrongWorkflow.addAll(issueIds);
    }

    public boolean isIssueOnWrongWorkflow(Long issueId) {
        return this.issuesIdsOnWrongWorkflow.contains(issueId);
    }

    private GenericValue getTargetStatus(String issueTypeId, String oldStatusId) {
        WorkflowMigrationMappingKey mappingKey = new WorkflowMigrationMappingKey(issueTypeId, oldStatusId);
        GenericValue status = this.mappings.get(mappingKey);
        if (status == null) {
            throw new RuntimeException("Encountered an issue whose status is not allowed in the existing workflow. No mapping from (type, status) = " + mappingKey + " defined.");
        }
        return status;
    }

    public GenericValue getTargetStatus(GenericValue issue) {
        if (issue == null) {
            throw new IllegalArgumentException("Issue cannot be null");
        }
        if (!"Issue".equals(issue.getEntityName())) {
            throw new IllegalArgumentException("The entity passed must be of type issue, not '" + issue.getEntityName() + "'.");
        }
        return this.getTargetStatus(issue.getString("type"), issue.getString("status"));
    }

    private static class WorkflowMigrationMappingKey {
        private final String issueTypeId;
        private final String statusId;

        public WorkflowMigrationMappingKey(GenericValue issueType, GenericValue status) {
            this.issueTypeId = issueType != null ? issueType.getString("id") : null;
            this.statusId = status != null ? status.getString("id") : null;
        }

        public WorkflowMigrationMappingKey(String issueTypeId, String statusId) {
            this.issueTypeId = issueTypeId;
            this.statusId = statusId;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof WorkflowMigrationMappingKey)) {
                return false;
            }
            WorkflowMigrationMappingKey workflowMigrationMappingKey = (WorkflowMigrationMappingKey)o;
            if (this.issueTypeId != null ? !this.issueTypeId.equals(workflowMigrationMappingKey.issueTypeId) : workflowMigrationMappingKey.issueTypeId != null) {
                return false;
            }
            return !(this.statusId != null ? !this.statusId.equals(workflowMigrationMappingKey.statusId) : workflowMigrationMappingKey.statusId != null);
        }

        public int hashCode() {
            int result = this.issueTypeId != null ? this.issueTypeId.hashCode() : 0;
            result = 29 * result + (this.statusId != null ? this.statusId.hashCode() : 0);
            return result;
        }

        public String toString() {
            return "(" + this.issueTypeId + ", " + this.statusId + ")";
        }
    }
}

