/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.workflow.condition;

import com.opensymphony.module.propertyset.PropertySet;
import com.opensymphony.workflow.Condition;
import com.opensymphony.workflow.StoreException;
import com.opensymphony.workflow.spi.Step;
import com.opensymphony.workflow.spi.WorkflowEntry;
import com.opensymphony.workflow.spi.WorkflowStore;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;

public class DisallowIfInStepCondition
implements Condition {
    private static final Logger log = Logger.getLogger(DisallowIfInStepCondition.class);

    public boolean passesCondition(Map transientVars, Map args, PropertySet ps) {
        WorkflowEntry entry = (WorkflowEntry)transientVars.get("entry");
        WorkflowStore store = (WorkflowStore)transientVars.get("store");
        String stepIdsString = (String)args.get("stepIds");
        StringTokenizer st = new StringTokenizer(stepIdsString, ", ");
        HashSet<Integer> stepIds = new HashSet<Integer>();
        while (st.hasMoreTokens()) {
            stepIds.add(new Integer(st.nextToken()));
        }
        List currentSteps = null;
        try {
            currentSteps = store.findCurrentSteps(entry.getId());
        }
        catch (StoreException e) {
            log.error((Object)"Error occurred while retrieving current steps.", (Throwable)e);
            return false;
        }
        for (Object currentStep : currentSteps) {
            Step step = (Step)currentStep;
            Integer stepId = new Integer(step.getStepId());
            if (!stepIds.contains(stepId)) continue;
            return false;
        }
        return true;
    }
}

