/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.util.component;

import com.atlassian.jira.config.component.ProfilingComponentAdapterFactory;
import com.atlassian.jira.workflow.JiraWorkflow;
import com.atlassian.jira.workflow.WorkflowManager;
import com.opensymphony.util.TextUtils;
import com.opensymphony.workflow.loader.ActionDescriptor;
import com.opensymphony.workflow.loader.StepDescriptor;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.picocontainer.PicoContainer;
import org.picocontainer.PicoRegistrationException;
import org.picocontainer.defaults.ComponentAdapterFactory;
import org.picocontainer.defaults.DefaultPicoContainer;
import webwork.action.ServletActionContext;

public class RequestComponentManager {
    private static final Logger log = Logger.getLogger(RequestComponentManager.class);

    public DefaultPicoContainer getContainer(PicoContainer parent) {
        try {
            HttpServletRequest request = ServletActionContext.getRequest();
            if (request != null) {
                return this.injectWorkflow(parent, request);
            }
        }
        catch (PicoRegistrationException e) {
            log.error((Object)e, (Throwable)e);
            if (e.getCause() != null) {
                log.error((Object)("Cause: " + e.getCause()), e.getCause());
            }
            throw e;
        }
        catch (Exception e) {
            log.error((Object)e, (Throwable)e);
        }
        return new DefaultPicoContainer((ComponentAdapterFactory)new ProfilingComponentAdapterFactory(), parent);
    }

    DefaultPicoContainer injectWorkflow(PicoContainer parent, HttpServletRequest request) {
        DefaultPicoContainer requestContainer = new DefaultPicoContainer((ComponentAdapterFactory)new ProfilingComponentAdapterFactory(), parent);
        String workflowName = request.getParameter("workflowName");
        if (StringUtils.isEmpty((String)workflowName)) {
            return requestContainer;
        }
        String workflowMode = request.getParameter("workflowMode");
        if (workflowMode == null) {
            throw new IllegalStateException("Found a 'workflow' in the request parameters, but there is no 'workflowMode'. " + this.getFullRequestUrl(request));
        }
        JiraWorkflow workflow = this.getWorkflow(parent, workflowMode, workflowName, request);
        if (workflow == null) {
            throw new IllegalStateException("No " + workflowMode + " workflow was found for '" + workflowName + "'.");
        }
        requestContainer.registerComponentInstance((Object)workflow);
        String workflowStep = request.getParameter("workflowStep");
        if (TextUtils.stringSet((String)workflowStep)) {
            ActionDescriptor transition;
            StepDescriptor step = workflow.getDescriptor().getStep(Integer.parseInt(workflowStep));
            if (step == null) {
                log.warn((Object)("No workflow step found for '" + workflowStep + "'"));
                return requestContainer;
            }
            requestContainer.registerComponentInstance((Object)step);
            String workflowTransition = request.getParameter("workflowTransition");
            if (TextUtils.stringSet((String)workflowTransition) && (transition = step.getAction(Integer.parseInt(workflowTransition))) != null) {
                requestContainer.registerComponentInstance((Object)transition);
            }
        } else {
            String globalWorkflowTransition = request.getParameter("workflowTransition");
            if (TextUtils.stringSet((String)globalWorkflowTransition)) {
                boolean actionFound = false;
                List globalActions = workflow.getDescriptor().getGlobalActions();
                int globalActionId = Integer.parseInt(globalWorkflowTransition);
                for (Object globalAction1 : globalActions) {
                    ActionDescriptor globalAction = (ActionDescriptor)globalAction1;
                    if (globalAction.getId() != globalActionId) continue;
                    requestContainer.registerComponentInstance((Object)globalAction);
                    actionFound = true;
                }
                if (!actionFound) {
                    List initialActions = workflow.getDescriptor().getInitialActions();
                    int initialActionId = Integer.parseInt(globalWorkflowTransition);
                    for (Object initialAction1 : initialActions) {
                        ActionDescriptor initialAction = (ActionDescriptor)initialAction1;
                        if (initialAction.getId() != initialActionId) continue;
                        requestContainer.registerComponentInstance((Object)initialAction);
                        actionFound = true;
                    }
                }
                if (!actionFound) {
                    log.error((Object)("Could not find any actions matching this workflow transition: " + globalWorkflowTransition));
                }
            }
        }
        return requestContainer;
    }

    private JiraWorkflow getWorkflow(PicoContainer parent, String workflowMode, String workflowName, HttpServletRequest request) {
        JiraWorkflow workflow;
        WorkflowManager workflowManager = (WorkflowManager)parent.getComponentInstanceOfType(WorkflowManager.class);
        if (workflowMode.equals("live")) {
            workflow = workflowManager.getWorkflowClone(workflowName);
        } else if (workflowMode.equals("draft")) {
            workflow = workflowManager.getDraftWorkflow(workflowName);
        } else {
            throw new IllegalStateException("Invalid workflow mode '" + workflowMode + "'. " + this.getFullRequestUrl(request));
        }
        return workflow;
    }

    private String getFullRequestUrl(HttpServletRequest request) {
        StringBuilder url = new StringBuilder(request.getRequestURL().toString());
        if (!StringUtils.isEmpty((String)request.getQueryString())) {
            url.append("?").append(request.getQueryString());
        }
        return url.toString();
    }
}

