/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.util;

import com.atlassian.core.logging.DatedLoggingEvent;
import com.atlassian.core.logging.ThreadLocalErrorCollection;
import com.atlassian.core.ofbiz.util.OFBizPropertyUtils;
import com.atlassian.jira.config.LocaleManager;
import com.atlassian.jira.service.JiraServiceContainer;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.system.ExtendedSystemInfoUtils;
import com.atlassian.jira.web.util.InternalServerErrorExceptionDataSource;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginInformation;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.opensymphony.module.propertyset.PropertySet;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.spi.LoggingEvent;
import org.ofbiz.core.entity.GenericValue;

public class InternalServerErrorDataSource {
    public static final String UNKNOWN = "Unknown";
    private final I18nHelper i18nBean;
    @Nullable
    private final ExtendedSystemInfoUtils extendedSystemInfoUtils;
    private final ServletContext servletContext;
    private final LocaleManager localeManager;
    private final HttpServletRequest request;
    private boolean prepareDataForSoy;

    public InternalServerErrorDataSource(I18nHelper i18nHelper, ExtendedSystemInfoUtils extendedSystemInfoUtils, ServletContext servletContext, LocaleManager localeManager, HttpServletRequest req) {
        this.i18nBean = i18nHelper;
        this.extendedSystemInfoUtils = extendedSystemInfoUtils;
        this.servletContext = servletContext;
        this.localeManager = localeManager;
        this.request = req;
        this.prepareDataForSoy = true;
    }

    public ImmutableMap.Builder<String, Object> appendFullMessageData(ImmutableMap.Builder<String, Object> map, boolean isSysadmin) {
        map.put((Object)"generalInfo", this.getGeneralInfo());
        map.put((Object)"serverInfo", this.arrarify(InternalServerErrorDataSource.translateKeys(this.getServerInfo(), this.i18nBean)));
        map.put((Object)"requestInfo", this.arrarify(InternalServerErrorDataSource.translateKeys(this.getRequestInfo(), this.i18nBean)));
        map.put((Object)"requestAttributes", this.arrarify(InternalServerErrorDataSource.translateKeys(this.getRequestAttributes(), this.i18nBean)));
        map.put((Object)"loggingEvents", this.getLoggingEvents());
        if (this.extendedSystemInfoUtils != null) {
            if (isSysadmin) {
                map.put((Object)"filePaths", this.arrarify(InternalServerErrorDataSource.translateKeys(this.getFilePaths(), this.i18nBean)));
                map.put((Object)"sysInfo", this.arrarify(this.extendedSystemInfoUtils.getProps()));
            } else {
                Map<String, String> sysProps = this.extendedSystemInfoUtils.getProps();
                ImmutableSet sysadminOnlyProps = ImmutableSet.of((Object)this.i18nBean.getText("admin.systeminfo.system.cwd"), (Object)this.i18nBean.getText("admin.systeminfo.jvm.input.arguments"));
                map.put((Object)"sysInfo", this.arrarify(InternalServerErrorDataSource.filterKeys(sysProps, (Set<String>)sysadminOnlyProps, this.i18nBean.getText("system.error.property.not.sysadmin"))));
            }
            map.put((Object)"languageInfo", InternalServerErrorDataSource.translateKeys(this.getLanguageInfo(), this.i18nBean));
            map.put((Object)"listeners", this.getListeners());
            map.put((Object)"services", this.getServices());
            map.put((Object)"buildInfoData", this.arrarify(this.extendedSystemInfoUtils.getBuildStats()));
            map.put((Object)"memInfo", this.arrarify(this.extendedSystemInfoUtils.getJvmStats()));
            map.put((Object)"plugins", this.getPlugins());
        }
        return map;
    }

    public ImmutableMap.Builder<String, Object> appendSimpleMessageData(ImmutableMap.Builder<String, Object> map) {
        map.put((Object)"generalInfo", this.getGeneralInfo());
        return map;
    }

    private Map<String, Object> getGeneralInfo() {
        ImmutableMap.Builder map = ImmutableMap.builder();
        InternalServerErrorExceptionDataSource exceptionInfo = new InternalServerErrorExceptionDataSource((Throwable)this.request.getAttribute("javax.servlet.error.exception"), this.extendedSystemInfoUtils);
        map.put((Object)"interpretedMsg", (Object)exceptionInfo.getInterpretedMessage());
        map.put((Object)"cause", (Object)exceptionInfo.getRootCause());
        map.put((Object)"stacktrace", (Object)exceptionInfo.getStacktrace());
        map.put((Object)"referer", (Object)(this.request.getHeader("Referer") != null ? this.request.getHeader("Referer") : UNKNOWN));
        map.put((Object)"servletErrorMessage", this.request.getAttribute("javax.servlet.error.message") != null ? this.request.getAttribute("javax.servlet.error.message") : "");
        return map.build();
    }

    private Map<String, Object> getLanguageInfo() {
        String defaultLang = this.extendedSystemInfoUtils.getDefaultLanguage();
        if (this.extendedSystemInfoUtils.isUsingSystemLocale()) {
            defaultLang = defaultLang + " - " + this.i18nBean.getText("admin.systeminfo.system.default.locale");
        }
        return ImmutableMap.of((Object)"admin.generalconfiguration.installed.languages", (Object)ImmutableList.copyOf((Iterable)Iterables.transform((Iterable)this.localeManager.getInstalledLocales(), (Function)new Function<Locale, String>(){

            public String apply(@Nullable Locale input) {
                return input.getDisplayName(InternalServerErrorDataSource.this.i18nBean.getLocale());
            }
        })), (Object)"admin.generalconfiguration.default.language", (Object)defaultLang);
    }

    private Map<String, String> getServerInfo() {
        return ImmutableMap.of((Object)"system.error.application.server", (Object)this.servletContext.getServerInfo(), (Object)"system.error.servlet.version", (Object)(this.servletContext.getMajorVersion() + "." + this.servletContext.getMinorVersion()));
    }

    private Map<String, String> getFilePaths() {
        return ImmutableMap.of((Object)"system.error.location.of.log", (Object)this.extendedSystemInfoUtils.getLogPath(), (Object)"system.error.location.of.entityengine", (Object)this.extendedSystemInfoUtils.getEntityEngineXmlPath());
    }

    private Map<String, String> getRequestInfo() {
        HashMap map = Maps.newHashMapWithExpectedSize((int)10);
        map.put("system.error.request.url", this.request.getRequestURL().toString());
        map.put("system.error.scheme", this.request.getScheme());
        map.put("system.error.server", this.request.getServerName());
        map.put("system.error.port", Integer.toString(this.request.getServerPort()));
        map.put("system.error.uri", this.request.getRequestURI());
        map.put("system.error.context.path", this.request.getContextPath());
        map.put("system.error.servlet.path", this.request.getServletPath());
        map.put("system.error.path.info", this.request.getPathInfo());
        map.put("system.error.query.string", this.request.getQueryString());
        return map;
    }

    private Map<String, String> getRequestAttributes() {
        ImmutableMap.Builder map = ImmutableMap.builder();
        Enumeration attributeNames = this.request.getAttributeNames();
        while (attributeNames.hasMoreElements()) {
            String attributeName = (String)attributeNames.nextElement();
            Object value = this.request.getAttribute(attributeName);
            if (value != null) {
                map.put((Object)attributeName, (Object)value.toString());
                continue;
            }
            map.put((Object)attributeName, (Object)"null");
        }
        return map.build();
    }

    private List<Map<String, Object>> getLoggingEvents() {
        return new ObjectToMapConverter<DatedLoggingEvent>(){

            @Override
            public void append(DatedLoggingEvent input, Map<String, Object> map) {
                LoggingEvent event = input.getEvent();
                map.put("loggerName", event.getLoggerName());
                map.put("level", event.getLevel());
                map.put("date", input.getDate().toString());
                map.put("message", event.getRenderedMessage());
                map.put("throwableStrRep", event.getThrowableInformation() != null ? event.getThrowableStrRep() : Collections.emptyList());
            }
        }.build(ThreadLocalErrorCollection.getList());
    }

    private List<Map<String, Object>> getListeners() {
        return new ObjectToMapConverter<GenericValue>(){

            @Override
            public void append(GenericValue input, Map<String, Object> map) {
                map.put("name", input.getString("name"));
                map.put("clazz", input.getString("clazz"));
                PropertySet propset = OFBizPropertyUtils.getPropertySet(input);
                List<String> keys = propset.getKeys(5);
                if (keys == null) {
                    keys = Collections.emptyList();
                }
                HashMap values = Maps.newHashMapWithExpectedSize((int)keys.size());
                for (String key : keys) {
                    values.put(key, propset.getString(key));
                }
                map.put("properties", InternalServerErrorDataSource.this.arrarify(values));
            }
        }.build(this.extendedSystemInfoUtils.getListeners());
    }

    private List<Map<String, Object>> getServices() {
        return new ObjectToMapConverter<JiraServiceContainer>(){

            @Override
            public void append(JiraServiceContainer input, Map<String, Object> map) {
                map.put("name", input.getName());
                map.put("class", input.getServiceClass());
                map.put("delay", InternalServerErrorDataSource.this.extendedSystemInfoUtils.getMillisecondsToMinutes(input.getDelay()));
                map.put("properties", InternalServerErrorDataSource.this.arrarify(InternalServerErrorDataSource.translateValues(InternalServerErrorDataSource.this.extendedSystemInfoUtils.getServicePropertyMap(input), InternalServerErrorDataSource.this.i18nBean)));
            }
        }.build(this.extendedSystemInfoUtils.getServices());
    }

    private List<Map<String, Object>> getPlugins() {
        return new ObjectToMapConverter<Plugin>(){

            @Override
            public void append(Plugin input, Map<String, Object> map) {
                PluginInformation info = input.getPluginInformation();
                map.put("name", input.getName());
                map.put("version", info.getVersion());
                map.put("vendor", info.getVendorName());
                map.put("enabled", InternalServerErrorDataSource.this.extendedSystemInfoUtils.isPluginEnabled(input));
                map.put("parameters", InternalServerErrorDataSource.this.arrarify(info.getParameters()));
            }
        }.build(this.extendedSystemInfoUtils.getPlugins());
    }

    public void notForSoy() {
        this.prepareDataForSoy = false;
    }

    private static <T> Map<String, String> filterKeys(Map<String, String> sourceMap, final Set<String> keysToRemove, final String replacementValue) {
        if (replacementValue == null) {
            return Maps.filterKeys(sourceMap, (Predicate)new Predicate<String>(){

                public boolean apply(@Nullable String input) {
                    return !keysToRemove.contains(input);
                }
            });
        }
        return Maps.transformEntries(sourceMap, (Maps.EntryTransformer)new Maps.EntryTransformer<String, String, String>(){

            public String transformEntry(@Nullable String key, @Nullable String value) {
                if (keysToRemove.contains(key)) {
                    return replacementValue;
                }
                return value;
            }
        });
    }

    private static <T> Map<String, T> translateKeys(Map<String, T> sourceMap, I18nHelper i18n) {
        HashMap resultMap = Maps.newHashMapWithExpectedSize((int)sourceMap.size());
        for (Map.Entry<String, T> entry : sourceMap.entrySet()) {
            resultMap.put(i18n.getText(entry.getKey()), entry.getValue());
        }
        return resultMap;
    }

    private static Map<String, String> translateValues(Map<String, String> sourceMap, final I18nHelper i18n) {
        return Maps.transformValues(sourceMap, (Function)new Function<String, String>(){

            public String apply(@Nullable String input) {
                return i18n.getText(input);
            }
        });
    }

    private <T> Object arrarify(Map<String, T> values) {
        if (this.prepareDataForSoy) {
            return InternalServerErrorDataSource.listifyMap(values);
        }
        return values;
    }

    private static <T> List<Map<String, Object>> listifyMap(Map<String, T> values) {
        return ImmutableList.copyOf((Iterable)Iterables.transform(values.entrySet(), (Function)new Function<Map.Entry<String, T>, Map<String, Object>>(){

            public Map<String, Object> apply(@Nullable Map.Entry<String, T> input) {
                HashMap result = Maps.newHashMapWithExpectedSize((int)2);
                result.put("key", input.getKey());
                result.put("value", input.getValue());
                return result;
            }
        }));
    }

    private static <T> Map<String, T> underscorify(Map<String, T> values) {
        HashMap result = Maps.newHashMapWithExpectedSize((int)values.size());
        for (Map.Entry<String, T> entry : values.entrySet()) {
            result.put(entry.getKey().replace(".", "_"), entry.getValue());
        }
        return result;
    }

    private static abstract class ObjectToMapConverter<T> {
        private ObjectToMapConverter() {
        }

        public List<Map<String, Object>> build(Iterable<T> input) {
            if (input == null) {
                return Collections.emptyList();
            }
            return ImmutableList.copyOf((Iterable)Iterables.transform(input, (Function)new Function<T, Map<String, Object>>(){

                public Map<String, Object> apply(@Nullable T input) {
                    HashMap map = Maps.newHashMap();
                    ObjectToMapConverter.this.append(input, map);
                    return map;
                }
            }));
        }

        public abstract void append(T var1, Map<String, Object> var2);
    }
}

