/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.util;

import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.plugin.elements.ResourceLocation;
import com.atlassian.plugin.servlet.DownloadableResource;
import com.atlassian.plugin.webresource.transformer.CharSequenceDownloadableResource;
import com.atlassian.plugin.webresource.transformer.SearchAndReplacer;
import com.atlassian.plugin.webresource.transformer.WebResourceTransformer;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import java.text.DateFormatSymbols;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.dom4j.Element;
import org.springframework.util.StringUtils;

public class DateFormatTransformer
implements WebResourceTransformer {
    private static final Pattern PATTERN = Pattern.compile("JIRA\\.getDateFormatSymbol\\(\\s*['\"]([^'\"]+)['\"]\\s*\\)");
    private final SearchAndReplacer grep;

    public DateFormatTransformer(final JiraAuthenticationContext jiraAuthenticationContext) {
        this.grep = SearchAndReplacer.create((Pattern)PATTERN, (Function)new Function<Matcher, CharSequence>(){

            public String apply(Matcher matcher) {
                String key = matcher.group(1);
                DateFormatSymbols dateFormatSymbols = DateFormatSymbols.getInstance(jiraAuthenticationContext.getLocale());
                List<String> values = key.equals("amPmStrings") ? Arrays.asList(dateFormatSymbols.getAmPmStrings()) : (key.equals("eras") ? Arrays.asList(dateFormatSymbols.getEras()) : (key.equals("months") ? Arrays.asList(dateFormatSymbols.getMonths()).subList(0, 12) : (key.equals("shortMonths") ? Arrays.asList(dateFormatSymbols.getShortMonths()).subList(0, 12) : (key.equals("shortWeekdays") ? Arrays.asList(dateFormatSymbols.getShortWeekdays()).subList(1, 8) : (key.equals("weekdays") ? Arrays.asList(dateFormatSymbols.getWeekdays()).subList(1, 8) : Collections.emptyList())))));
                return '[' + Joiner.on((char)',').join((Iterable)Lists.transform(values, (Function)new Function<String, String>(){

                    public String apply(String value) {
                        return StringUtils.quote((String)value);
                    }
                })) + ']';
            }
        });
    }

    public DownloadableResource transform(Element configElement, ResourceLocation location, String filePath, DownloadableResource nextResource) {
        return new CharSequenceDownloadableResource(nextResource){

            public CharSequence transform(CharSequence originalContent) {
                return DateFormatTransformer.this.grep.replaceAll(originalContent);
            }
        };
    }
}

