/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.tags;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.plugin.userformat.UserFormats;
import com.atlassian.jira.plugin.userformat.UserFormatter;
import com.atlassian.jira.user.ApplicationUser;
import java.util.Collections;
import java.util.Map;
import javax.servlet.jsp.JspException;
import org.apache.log4j.Logger;
import webwork.view.taglib.WebWorkBodyTagSupport;

public class FormatUserTag
extends WebWorkBodyTagSupport {
    private static final Logger log = Logger.getLogger(FormatUserTag.class);
    private String user;
    private String userKey;
    private String userName;
    private String type;
    private String id;
    private Boolean escape;

    public void setUser(String user) {
        this.user = user;
    }

    public void setUserKey(String userKey) {
        this.userKey = userKey;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setEscape(Boolean escape) {
        this.escape = escape;
    }

    private void checkUserArgs() {
        int count = 0;
        if (this.user != null) {
            ++count;
        }
        if (this.userKey != null) {
            ++count;
        }
        if (this.userName != null) {
            ++count;
        }
        if (count != 1) {
            throw new IllegalArgumentException("Exactly one 'user', 'userKey', or 'userName' attribute is required, but " + count + " of them were provided.");
        }
    }

    private UserFormatter formatter() {
        return ((UserFormats)ComponentAccessor.getComponentOfType(UserFormats.class)).formatter(this.findString(this.type));
    }

    private Map<String, Object> params() {
        return Collections.singletonMap("escape", this.escape);
    }

    private String formatUsername(String userName) {
        String idVal = this.findString(this.id);
        return this.formatter().formatUsername(userName, idVal, this.params());
    }

    private String formatUserkey(String userKey) {
        String idVal = this.findString(this.id);
        return this.formatter().formatUserkey(userKey, idVal, this.params());
    }

    public int doEndTag() throws JspException {
        String lookup = null;
        boolean isKey = false;
        try {
            String formattedUser;
            this.checkUserArgs();
            if (this.userKey != null) {
                lookup = this.findString(this.userKey);
                isKey = true;
            } else if (this.userName != null) {
                lookup = this.findString(this.userName);
            } else {
                Object value = this.findValue(this.user);
                if (value instanceof String) {
                    lookup = (String)value;
                    throw new IllegalArgumentException("Ambiguous 'user' argument.  Use 'userName' or 'userKey' as appropriate, instead.");
                }
                if (value instanceof User) {
                    lookup = ((User)value).getName();
                } else if (value instanceof ApplicationUser) {
                    lookup = ((ApplicationUser)value).getKey();
                    isKey = true;
                } else {
                    lookup = this.user;
                }
            }
            String string = formattedUser = isKey ? this.formatUserkey(lookup) : this.formatUsername(lookup);
            if (formattedUser != null) {
                this.pageContext.getOut().write(formattedUser);
            }
        }
        catch (Exception e) {
            log.error((Object)("Unexpected error occurred formatting user '" + lookup + "'"), (Throwable)e);
            throw new JspException((Throwable)e);
        }
        return 6;
    }
}

