/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.servlet;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.exception.AttachmentNotFoundException;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.exception.PermissionException;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.attachment.Attachment;
import com.atlassian.jira.user.UserUtils;
import com.atlassian.jira.util.AttachmentUtils;
import com.atlassian.jira.web.servlet.AbstractViewFileServlet;
import com.atlassian.jira.web.servlet.HttpResponseHeaders;
import com.atlassian.jira.web.servlet.MimeSniffingKit;
import java.io.File;
import java.io.IOException;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ViewAttachmentServlet
extends AbstractViewFileServlet {
    private MimeSniffingKit mimeSniffingKit;

    public void init(ServletConfig servletConfig) throws ServletException {
        super.init(servletConfig);
    }

    MimeSniffingKit getMimeSniffingKit() {
        if (this.mimeSniffingKit == null) {
            this.mimeSniffingKit = (MimeSniffingKit)ComponentAccessor.getComponent(MimeSniffingKit.class);
        }
        return this.mimeSniffingKit;
    }

    ApplicationProperties getApplicationProperties() {
        return (ApplicationProperties)ComponentAccessor.getComponentOfType(ApplicationProperties.class);
    }

    @Override
    protected File getFileName(HttpServletRequest request, HttpServletResponse response) throws DataAccessException, PermissionException {
        Attachment attachment = this.getAttachment(this.attachmentPath(request));
        if (!this.hasPermissionToViewAttachment(this.getUserName(), attachment)) {
            throw new PermissionException("You do not have permissions to view this issue");
        }
        return AttachmentUtils.getAttachmentFile((Attachment)attachment);
    }

    protected Attachment getAttachment(String query) {
        Long id;
        int x = query.indexOf(47, 1);
        String idStr = query.substring(1, x);
        try {
            id = new Long(idStr);
        }
        catch (NumberFormatException e) {
            throw new AttachmentNotFoundException((Object)idStr);
        }
        if (query.indexOf(47, x + 1) != -1) {
            throw new AttachmentNotFoundException((Object)idStr);
        }
        return ComponentAccessor.getAttachmentManager().getAttachment(id);
    }

    @Override
    protected void setResponseHeaders(HttpServletRequest request, HttpServletResponse response) throws AttachmentNotFoundException, IOException {
        Attachment attachment = this.getAttachment(this.attachmentPath(request));
        response.setContentType(attachment.getMimetype());
        response.setContentLength(attachment.getFilesize().intValue());
        this.getMimeSniffingKit().setAttachmentResponseHeaders(attachment, request.getHeader("USER-AGENT"), response);
        HttpResponseHeaders.cachePrivatelyForAboutOneYear(response);
    }

    protected boolean hasPermissionToViewAttachment(String username, Attachment attachment) throws DataAccessException {
        Issue issue = attachment.getIssueObject();
        if (username == null) {
            return ComponentAccessor.getPermissionManager().hasPermission(10, issue, (User)null);
        }
        User user = UserUtils.getUser((String)username);
        if (user == null) {
            throw new DataAccessException("User '" + username + "' not found");
        }
        return ComponentAccessor.getPermissionManager().hasPermission(10, issue, user);
    }
}

