/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.filters.accesslog;

import com.atlassian.jira.util.http.request.CapturingRequestWrapper;
import com.atlassian.jira.util.http.response.CapturingResponseWrapper;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.util.Enumeration;
import java.util.List;
import javax.servlet.http.Cookie;
import org.apache.commons.lang.StringUtils;

class AccessLogDumpUtil {
    AccessLogDumpUtil() {
    }

    static String dumpRequestResponse(CapturingRequestWrapper request, CapturingResponseWrapper response, String logMsg, long responseContentLen, Exception requestException) {
        String value;
        String name;
        StringBuilder sb = new StringBuilder();
        if (requestException != null) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            requestException.printStackTrace(pw);
            sb.append("\t___ Exception ___________________________________________\n");
            sb.append(AccessLogDumpUtil.indentVal(sw.toString()));
        }
        sb.append("\t___ Request _____________________________________________________\n");
        Enumeration parameterNames = request.getParameterNames();
        int i = 0;
        if (parameterNames != null) {
            while (parameterNames.hasMoreElements()) {
                String[] values;
                if (i == 0) {
                    sb.append("\tRequest URL Parameters : \n");
                }
                String name2 = (String)parameterNames.nextElement();
                for (String string : values = request.getParameterValues(name2)) {
                    AccessLogDumpUtil.printNameValue(sb, name2, string);
                }
                ++i;
            }
        }
        i = 0;
        Enumeration headerNames = request.getHeaderNames();
        if (headerNames != null) {
            while (headerNames.hasMoreElements()) {
                if (i == 0) {
                    sb.append("\tRequest HTTP Headers : \n");
                }
                String name3 = (String)headerNames.nextElement();
                Enumeration headerValues = request.getHeaders(name3);
                while (headerValues.hasMoreElements()) {
                    String value3 = (String)headerValues.nextElement();
                    AccessLogDumpUtil.printNameValue(sb, name3, AccessLogDumpUtil.indentVal(value3));
                }
                ++i;
            }
        }
        i = 0;
        Cookie[] cookies = request.getCookies();
        if (cookies != null) {
            for (String string : cookies) {
                if (i == 0) {
                    sb.append("\tRequest Cookies : \n");
                }
                name = string.getName();
                value = AccessLogDumpUtil.formatCookieValue((Cookie)string);
                AccessLogDumpUtil.printNameValue(sb, name, value);
                ++i;
            }
        }
        i = 0;
        Enumeration attributeNames = request.getAttributeNames();
        if (attributeNames != null) {
            while (attributeNames.hasMoreElements()) {
                if (i == 0) {
                    sb.append("\tRequest Attributes : \n");
                }
                String name4 = (String)attributeNames.nextElement();
                String value4 = String.valueOf(request.getAttribute(name4));
                AccessLogDumpUtil.printNameValue(sb, name4, value4);
                ++i;
            }
        }
        AccessLogDumpUtil.appendByteDump(sb, "Request Data", request.getBytes(), request.getCharacterEncoding(), request.getContentLength());
        sb.append("\t___ Response ____________________________________________________\n");
        i = 0;
        List cookieList = response.getCookieList();
        if (cookieList != null) {
            for (Cookie cookie : cookieList) {
                if (i == 0) {
                    sb.append("\tResponse Cookies : \n");
                }
                name = cookie.getName();
                value = AccessLogDumpUtil.formatCookieValue(cookie);
                AccessLogDumpUtil.printNameValue(sb, name, value);
                ++i;
            }
        }
        i = 0;
        List headerList = response.getHeaderList();
        if (headerList != null) {
            for (CapturingResponseWrapper.HttpHeader httpHeader : headerList) {
                if (i == 0) {
                    sb.append("\tResponse HTTP Headers : \n");
                }
                String name5 = httpHeader.getName();
                String value5 = String.valueOf(httpHeader.getValue());
                AccessLogDumpUtil.printNameValue(sb, name5, value5);
                ++i;
            }
        }
        AccessLogDumpUtil.appendByteDump(sb, "Response Data", response.getBytes(), response.getCharacterEncoding(), responseContentLen);
        return logMsg + "\n\t" + sb.toString().trim();
    }

    private static void appendByteDump(StringBuilder sb, String desc, byte[] bytes, String characterEncoding, long contentLen) {
        if (bytes.length > 0) {
            sb.append("\t").append(desc);
            if ((long)bytes.length < contentLen) {
                sb.append(" (first ").append(bytes.length).append(" of ").append(contentLen).append(" bytes) : \n");
            } else {
                sb.append(" (total ").append(bytes.length).append(" bytes) : \n");
            }
            String capturedOutput = "";
            try {
                capturedOutput = new String(bytes, characterEncoding);
            }
            catch (UnsupportedEncodingException ignore) {
                // empty catch block
            }
            sb.append("\n").append(AccessLogDumpUtil.indentVal(capturedOutput));
        } else {
            sb.append("\t").append(desc).append(" (0 bytes).\n");
        }
    }

    private static String formatCookieValue(Cookie cookie) {
        return cookie.getValue() + " path:" + cookie.getPath() + " domain:" + cookie.getDomain() + " version:" + cookie.getVersion() + " maxAge:" + cookie.getMaxAge();
    }

    private static void printNameValue(StringBuilder sb, String name, String value) {
        sb.append("\t\t");
        sb.append(name).append("=").append(AccessLogDumpUtil.indentVal(value)).append("\n");
    }

    private static String indentVal(String s) {
        return StringUtils.replace((String)s, (String)"\n", (String)"\n\t\t\t");
    }
}

