/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.dispatcher;

import com.atlassian.fugue.Option;
import com.atlassian.jira.util.lang.Pair;
import com.atlassian.jira.web.action.ActionViewData;
import com.atlassian.jira.web.action.ActionViewDataMappings;
import com.google.common.base.Function;
import com.google.common.collect.Maps;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.springframework.util.ReflectionUtils;

class ActionViewDataAnnotationSupport {
    ActionViewDataAnnotationSupport() {
    }

    public Map<String, Object> getData(String actionResult, final Object targetObject) {
        if (targetObject == null) {
            return Collections.emptyMap();
        }
        final HashMap data = Maps.newHashMap();
        ReflectionUtils.doWithMethods(targetObject.getClass(), (ReflectionUtils.MethodCallback)new ReflectionUtils.MethodCallback(){

            public void doWith(Method method) throws IllegalArgumentException, IllegalAccessException {
                Option pair = ActionViewDataAnnotationSupport.this.invoke(targetObject, method);
                for (Pair tuple : pair) {
                    Object value = tuple.second();
                    if (value instanceof Map) {
                        data.putAll((Map)value);
                        continue;
                    }
                    data.put(tuple.first(), value);
                }
            }
        }, (ReflectionUtils.MethodFilter)new AnnotatedGetterLikeMethods(actionResult));
        return data;
    }

    private Option<Pair<String, Object>> invoke(Object targetObject, Method method) {
        try {
            Object value = method.invoke(targetObject, new Object[0]);
            Pair pair = Pair.nicePairOf((Object)this.getKey(method), (Object)value);
            return Option.some((Object)pair);
        }
        catch (IllegalAccessException e) {
            return Option.none();
        }
        catch (InvocationTargetException e) {
            return Option.none();
        }
    }

    private String getKey(Method method) {
        String name = this.getAnnotatedName(method);
        if (StringUtils.isNotEmpty((String)name)) {
            return name;
        }
        name = method.getName();
        if (name.length() > 2 && name.startsWith("is")) {
            return StringUtils.substring((String)name, (int)2, (int)3).toLowerCase() + StringUtils.substring((String)name, (int)3);
        }
        if (name.length() > 3 && name.startsWith("get")) {
            return StringUtils.substring((String)name, (int)3, (int)4).toLowerCase() + StringUtils.substring((String)name, (int)4);
        }
        return name;
    }

    private String getAnnotatedName(Method method) {
        ActionViewData viewData = method.getAnnotation(ActionViewData.class);
        if (viewData != null && !"*".equals(viewData.key())) {
            return viewData.key();
        }
        ActionViewDataMappings viewDataMappings = method.getAnnotation(ActionViewDataMappings.class);
        if (viewDataMappings != null && !"*".equals(viewDataMappings.key())) {
            return viewDataMappings.key();
        }
        return null;
    }

    private static class AnnotatedGetterLikeMethods
    implements ReflectionUtils.MethodFilter {
        private final String actionResult;

        private AnnotatedGetterLikeMethods(String actionResult) {
            this.actionResult = actionResult;
        }

        public boolean matches(Method method) {
            int modifiers = method.getModifiers();
            return (this.hasSingleAnnotation(method) || this.hasMultiAnnotation(method)) && Modifier.isPublic(modifiers) && !Modifier.isStatic(modifiers) && method.getParameterTypes().length == 0 && !method.getReturnType().equals(Void.class);
        }

        private boolean hasSingleAnnotation(Method method) {
            return (Boolean)Option.option((Object)method.getAnnotation(ActionViewData.class)).flatMap((Function)new Function<ActionViewData, Option<String>>(){

                public Option<String> apply(ActionViewData input) {
                    return Option.option((Object)input.value());
                }
            }).flatMap((Function)new Function<String, Option<Boolean>>(){

                public Option<Boolean> apply(@Nullable String value) {
                    return Option.option((Object)(AnnotatedGetterLikeMethods.this.actionResult.equals(value) || "*".equals(value) ? 1 : 0));
                }
            }).getOrElse((Object)false);
        }

        private boolean hasMultiAnnotation(Method method) {
            return (Boolean)Option.option((Object)method.getAnnotation(ActionViewDataMappings.class)).flatMap((Function)new Function<ActionViewDataMappings, Option<String[]>>(){

                public Option<String[]> apply(ActionViewDataMappings input) {
                    return Option.option((Object)input.value());
                }
            }).flatMap((Function)new Function<String[], Option<Boolean>>(){

                public Option<Boolean> apply(String[] input) {
                    for (String s : input) {
                        if (!AnnotatedGetterLikeMethods.this.actionResult.equals(s)) continue;
                        return Option.option((Object)true);
                    }
                    return Option.option((Object)false);
                }
            }).getOrElse((Object)false);
        }
    }
}

