/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.component.multiuserpicker;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.UserManager;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import org.apache.commons.lang.StringUtils;

public class UserBean {
    private final String username;
    private final String fullName;
    private final boolean isReal;

    public static List<UserBean> convertUsernamesToUserBeans(Locale userLocale, Collection<String> usernames) {
        UserManager userManager = ComponentAccessor.getUserManager();
        ArrayList<UserBean> userBeans = new ArrayList<UserBean>(usernames.size());
        for (String username : usernames) {
            ApplicationUser user = userManager.getUserByName(username);
            if (user == null) {
                userBeans.add(new UserBean(username));
                continue;
            }
            userBeans.add(new UserBean(username, user.getDisplayName()));
        }
        Collections.sort(userBeans, new UserBeanComparator(userLocale));
        return userBeans;
    }

    public static List<UserBean> convertUsersToUserBeans(Locale userLocale, Collection<User> users) {
        ArrayList<UserBean> userBeans = new ArrayList<UserBean>(users.size());
        for (User user : users) {
            userBeans.add(new UserBean(user.getName(), user.getDisplayName()));
        }
        Collections.sort(userBeans, new UserBeanComparator(userLocale));
        return userBeans;
    }

    public UserBean(String username, String fullName) {
        this.username = username;
        this.fullName = fullName;
        this.isReal = true;
    }

    public UserBean(String username) {
        this.username = username;
        this.fullName = "";
        this.isReal = false;
    }

    public String getName() {
        return this.username;
    }

    public String getFullName() {
        return this.fullName;
    }

    public boolean isReal() {
        return this.isReal;
    }

    static class UserBeanComparator
    implements Comparator<UserBean> {
        private Collator collator;

        UserBeanComparator(Locale userLocale) {
            this.collator = Collator.getInstance(userLocale);
            this.collator.setStrength(1);
        }

        @Override
        public int compare(UserBean bean1, UserBean bean2) {
            String name1 = bean1.getFullName();
            String name2 = bean2.getFullName();
            if (StringUtils.isBlank((String)name1)) {
                name1 = bean1.getName();
            }
            if (StringUtils.isBlank((String)name2)) {
                name2 = bean2.getName();
            }
            if (name1 == null || name2 == null) {
                throw new RuntimeException("Null user name");
            }
            int fullNameComparison = this.collator.compare(name1, name2);
            if (fullNameComparison == 0) {
                return this.collator.compare(bean1.getName(), bean2.getName());
            }
            return fullNameComparison;
        }
    }
}

