/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.component.multigrouppicker;

import com.atlassian.core.util.map.EasyMap;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.template.VelocityTemplatingEngine;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.JiraVelocityUtils;
import com.atlassian.jira.web.component.AbstractWebComponent;
import com.atlassian.jira.web.component.PickerLayoutBean;
import com.atlassian.jira.web.component.WebComponentUtils;
import com.atlassian.plugin.webresource.WebResourceManager;
import com.atlassian.util.profiling.UtilTimerStack;
import java.util.Collection;
import java.util.Map;

public class GroupPickerWebComponent
extends AbstractWebComponent {
    private final JiraAuthenticationContext authenticationContext = (JiraAuthenticationContext)ComponentAccessor.getComponentOfType(JiraAuthenticationContext.class);

    public GroupPickerWebComponent() {
        super((VelocityTemplatingEngine)ComponentAccessor.getComponent(VelocityTemplatingEngine.class), ComponentAccessor.getApplicationProperties());
    }

    public String getHtml(PickerLayoutBean layoutBean, Collection currentGroups, boolean canEdit, Long id, Map startingParams) {
        return this.getHtml(layoutBean, currentGroups, canEdit, id, startingParams, this.authenticationContext.getI18nHelper());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getHtml(PickerLayoutBean layoutBean, Collection currentGroups, boolean canEdit, Long id, Map startingParams, I18nHelper i18n) {
        try {
            UtilTimerStack.push((String)"GroupPickerHtml");
            boolean canPickGroups = ComponentAccessor.getPermissionManager().hasPermission(27, this.authenticationContext.getLoggedInUser());
            startingParams.putAll(EasyMap.build((Object)"layout", (Object)layoutBean, (Object)"currentSelections", (Object)currentGroups, (Object)"i18n", (Object)i18n, (Object)"canEdit", (Object)canEdit, (Object)"id", (Object)id, (Object)"canPick", (Object)canPickGroups, (Object)"windowName", (Object)"GroupPicker"));
            Map<String, Object> params = JiraVelocityUtils.getDefaultVelocityParams(startingParams, this.authenticationContext);
            WebResourceManager webResourceManager = ComponentAccessor.getWebResourceManager();
            webResourceManager.requireResource("jira.webresources:autocomplete");
            String string = this.getHtml("templates/jira/multipicker/pickertable.vm", params);
            return string;
        }
        finally {
            UtilTimerStack.pop((String)"GroupPickerHtml");
        }
    }

    public static Collection<String> getGroupNamesToRemove(Map params, String paramPrefix) {
        return WebComponentUtils.getRemovalValues(params, paramPrefix);
    }

    public static Collection<String> getGroupNamesToAdd(String rawGroupNames) {
        return WebComponentUtils.convertStringToCollection(rawGroupNames);
    }
}

