/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.component;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.plugin.webfragment.SimpleLinkManager;
import com.atlassian.jira.plugin.webfragment.model.JiraHelper;
import com.atlassian.jira.plugin.webfragment.model.SimpleLink;
import com.atlassian.jira.plugin.webfragment.model.SimpleLinkSection;
import com.atlassian.jira.plugin.webfragment.model.SimpleLinkSectionImpl;
import com.atlassian.jira.web.component.ModuleWebComponentFields;
import com.atlassian.plugin.web.WebInterfaceManager;
import com.atlassian.plugin.web.descriptors.WebPanelModuleDescriptor;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class ModuleWebComponentFieldsImpl
implements ModuleWebComponentFields {
    private final SimpleLinkManager simpleLinkManager;
    private final WebInterfaceManager webInterfaceManager;

    public ModuleWebComponentFieldsImpl(SimpleLinkManager simpleLinkManager, WebInterfaceManager webInterfaceManager) {
        this.simpleLinkManager = simpleLinkManager;
        this.webInterfaceManager = webInterfaceManager;
    }

    @Override
    public List<SimpleLink> getHeaderItems(String key, User user, JiraHelper helper) {
        return this.simpleLinkManager.getLinksForSection(key + "/header", user, helper);
    }

    @Override
    public List<WebPanelModuleDescriptor> getPanels(String key, Map<String, Object> params) {
        return this.webInterfaceManager.getDisplayableWebPanelDescriptors(key + "/panels", params);
    }

    @Override
    public List<ModuleWebComponentFields.SectionsAndLinks> getDropdownSections(String key, User user, JiraHelper helper) {
        return this.getSections(key + "/drop", user, helper);
    }

    private List<ModuleWebComponentFields.SectionsAndLinks> getSections(String key, User user, JiraHelper helper) {
        ArrayList<ModuleWebComponentFields.SectionsAndLinks> sections = new ArrayList<ModuleWebComponentFields.SectionsAndLinks>();
        List defaultLinks = this.simpleLinkManager.getLinksForSection(key + "/default", user, helper);
        if (!defaultLinks.isEmpty()) {
            sections.add(new ModuleWebComponentFields.SectionsAndLinks((SimpleLinkSection)new SimpleLinkSectionImpl("", null, null, null, "module-drop-default-section", null), defaultLinks));
        }
        List sectionsForLocation = this.simpleLinkManager.getSectionsForLocation(key, user, helper);
        for (SimpleLinkSection simpleLinkSection : sectionsForLocation) {
            List linksForSection = this.simpleLinkManager.getLinksForSection(key + "/" + simpleLinkSection.getId(), user, helper);
            if (linksForSection.isEmpty()) continue;
            sections.add(new ModuleWebComponentFields.SectionsAndLinks(simpleLinkSection, linksForSection));
        }
        return sections;
    }
}

