/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.bean;

import com.atlassian.crowd.embedded.api.Group;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.security.groups.GroupManager;
import com.atlassian.jira.user.util.UserUtil;
import com.opensymphony.util.TextUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.SequencedCollection;

public class FilterUtils {
    public static String verifyString(String s) {
        if (TextUtils.stringSet((String)TextUtils.noNull((String)s).trim())) {
            return s;
        }
        return null;
    }

    public static String[] verifyStringArray(String[] sa) {
        ArrayList<String> result = new ArrayList<String>();
        for (String string : sa) {
            String s = FilterUtils.verifyString(string);
            if (s == null) continue;
            result.add(s);
        }
        if (result.size() == 0) {
            return null;
        }
        String[] resultSa = new String[result.size()];
        int count = 0;
        for (Object e : result) {
            resultSa[count++] = (String)e;
        }
        return resultSa;
    }

    public static Long verifyLong(Long id) {
        if (id != null && id > 0L) {
            return id;
        }
        return null;
    }

    public static Collection getGroups(User user) {
        SequencedCollection<String> groups = new ArrayList();
        if (user == null) {
            return null;
        }
        UserUtil userUtil = (UserUtil)ComponentAccessor.getComponent(UserUtil.class);
        GroupManager groupManager = (GroupManager)ComponentAccessor.getComponent(GroupManager.class);
        if (ComponentAccessor.getPermissionManager().hasPermission(0, user)) {
            for (Group group : groupManager.getAllGroups()) {
                groups.add(group.getName());
            }
        } else {
            groups = userUtil.getGroupNamesForUser(user.getName());
        }
        return groups;
    }
}

