/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.user;

import com.atlassian.crowd.embedded.api.CrowdService;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.crowd.exception.FailedAuthenticationException;
import com.atlassian.crowd.exception.InactiveAccountException;
import com.atlassian.crowd.exception.OperationNotPermittedException;
import com.atlassian.crowd.model.user.UserTemplate;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.event.user.UserProfileUpdatedEvent;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.web.action.JiraWebActionSupport;
import org.apache.commons.lang.StringUtils;

public class EditProfile
extends JiraWebActionSupport {
    private static final int MAX_LENGTH = 255;
    private final CrowdService crowdService;
    private final EventPublisher eventPublisher;
    private String username;
    private String fullName;
    private String email;
    private String password;

    public EditProfile(CrowdService crowdService, EventPublisher eventPublisher) {
        this.crowdService = crowdService;
        this.eventPublisher = eventPublisher;
    }

    public String doDefault() throws Exception {
        User current = this.getLoggedInUser();
        if (current == null || !current.getName().equals(this.username)) {
            return "error";
        }
        this.fullName = current.getDisplayName();
        this.email = current.getEmailAddress();
        return super.doDefault();
    }

    protected void doValidation() {
        User current = this.getLoggedInUser();
        if (current == null) {
            this.addErrorMessage("generic.notloggedin.title");
            return;
        }
        if (StringUtils.isBlank((String)this.fullName)) {
            this.addError("fullName", this.getText("admin.errors.invalid.full.name.specified"));
        } else if (this.fullName.length() > 255) {
            this.addError("fullName", this.getText("signup.error.full.name.greater.than.max.chars"));
        }
        if (StringUtils.isBlank((String)this.email)) {
            this.addError("email", this.getText("admin.errors.invalid.email"));
        } else if (this.email.length() > 255) {
            this.addError("email", this.getText("signup.error.email.greater.than.max.chars"));
        }
        if (this.detailsHaveChanged(current) && !this.validatePassword(current)) {
            this.addError("password", this.getText("user.profile.password.mismatch"));
        }
    }

    private boolean validatePassword(User current) {
        try {
            this.crowdService.authenticate(current.getName(), this.password);
        }
        catch (InactiveAccountException e) {
            return false;
        }
        catch (FailedAuthenticationException e) {
            return false;
        }
        return true;
    }

    @RequiresXsrfCheck
    protected String doExecute() throws Exception {
        User current = this.getLoggedInUser();
        if (current == null || !current.getName().equals(this.username)) {
            return "error";
        }
        if (this.detailsHaveChanged(current)) {
            UserTemplate user = new UserTemplate(current);
            user.setDisplayName(this.fullName);
            user.setEmailAddress(this.email);
            try {
                this.crowdService.updateUser((User)user);
                this.eventPublisher.publish((Object)new UserProfileUpdatedEvent((User)user, this.getLoggedInUser()));
            }
            catch (OperationNotPermittedException e) {
                this.addErrorMessage(this.getText("admin.errors.cannot.edit.user.directory.read.only"));
            }
        }
        return this.returnComplete("ViewProfile.jspa");
    }

    private boolean detailsHaveChanged(User current) {
        return !this.eq(current.getDisplayName(), this.fullName) || !this.eq(current.getEmailAddress(), this.email);
    }

    private boolean eq(String s, String s1) {
        return StringUtils.defaultString((String)s).equals(StringUtils.defaultString((String)s1));
    }

    public String getFullName() {
        return this.fullName;
    }

    public String getEmail() {
        return this.email;
    }

    public void setFullName(String fullName) {
        this.fullName = fullName;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }
}

