/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.user;

import com.atlassian.jira.bc.JiraServiceContext;
import com.atlassian.jira.bc.favourites.FavouritesService;
import com.atlassian.jira.bc.portal.PortalPageService;
import com.atlassian.jira.portal.PortalPage;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.sharing.SharedEntity;
import com.atlassian.jira.web.action.JiraWebActionSupport;
import webwork.action.ActionContext;

public class DeletePortalPage
extends JiraWebActionSupport {
    private final PortalPageService portalPageService;
    private final FavouritesService favouritesService;
    private Long pageId = null;
    private Long otherFavouriteCount;
    private PortalPage portalPage;

    public DeletePortalPage(PortalPageService portalPageService, FavouritesService favouritesService) {
        this.portalPageService = portalPageService;
        this.favouritesService = favouritesService;
    }

    public String doDefault() throws Exception {
        this.doValidation();
        return this.hasAnyErrors() ? "error" : "input";
    }

    @RequiresXsrfCheck
    public String doExecute() throws Exception {
        JiraServiceContext serviceContext = this.getJiraServiceContext();
        this.portalPageService.deletePortalPage(serviceContext, this.pageId);
        return this.returnComplete("secure/ConfigurePortalPages!default.jspa");
    }

    public void doValidation() {
        if (this.pageId == null) {
            this.addErrorMessage(this.getText("admin.errors.user.page.id.must.be.set"));
            return;
        }
        JiraServiceContext serviceContext = this.getJiraServiceContext();
        this.portalPageService.validateForDelete(serviceContext, this.pageId);
    }

    public boolean canDelete() {
        return !this.hasAnyErrors();
    }

    public int getOtherFavouriteCount() {
        if (this.otherFavouriteCount == null) {
            PortalPage page = this.getPortalPage();
            boolean isFavourite = this.favouritesService.isFavourite(this.getLoggedInApplicationUser(), (SharedEntity)page);
            int count = isFavourite ? page.getFavouriteCount().intValue() - 1 : page.getFavouriteCount().intValue();
            this.otherFavouriteCount = new Long(count);
        }
        return this.otherFavouriteCount.intValue();
    }

    private PortalPage getPortalPage() {
        if (this.portalPage == null) {
            this.portalPage = this.portalPageService.getPortalPage(this.getJiraServiceContext(), this.pageId);
        }
        return this.portalPage;
    }

    public String getPageName() {
        PortalPage page = this.getPortalPage();
        return page != null ? page.getName() : null;
    }

    public Long getPageId() {
        return this.pageId;
    }

    public void setPageId(Long pageId) {
        this.pageId = pageId;
    }

    public String getTargetUrl() {
        return ActionContext.getRequest().getContextPath() + "/secure/Dashboard.jspa";
    }
}

