/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.user;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.issue.RendererManager;
import com.atlassian.jira.mail.JiraMailQueueUtils;
import com.atlassian.jira.mail.TemplateContextFactory;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.template.TemplateSources;
import com.atlassian.jira.template.VelocityTemplatingEngine;
import com.atlassian.jira.user.UserPropertyManager;
import com.atlassian.jira.user.util.UserUtil;
import com.atlassian.jira.util.JiraContactHelper;
import com.atlassian.jira.web.action.ActionViewData;
import com.atlassian.jira.web.action.ActionViewDataMappings;
import com.atlassian.jira.web.action.JiraWebActionSupport;
import com.atlassian.jira.web.bean.I18nBean;
import com.atlassian.mail.Email;
import com.atlassian.mail.MailException;
import com.atlassian.mail.queue.MailQueue;
import com.atlassian.mail.queue.MailQueueItem;
import com.atlassian.mail.queue.SingleMailQueueItem;
import com.google.common.collect.Maps;
import com.opensymphony.util.TextUtils;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class ContactAdministrators
extends JiraWebActionSupport {
    private static final String EMAIL_TEMPLATES = "templates/email";
    private static final String EMAIL_TEMPLATE = "contactadministrator.vm";
    private static final String ENCODING_UTF8 = "UTF-8";
    private static final Integer PADSIZE = 20;
    private final UserPropertyManager userPropertyManager;
    private final VelocityTemplatingEngine velocityManager;
    private final TemplateContextFactory templateContextFactory;
    private final RendererManager rendererManager;
    private final MailQueue mailQueue;
    private final UserUtil userUtil;
    private final JiraContactHelper jiraContactHelper;
    private String to;
    private String replyTo;
    private String subject;
    private String details;

    public ContactAdministrators(RendererManager rendererManager, MailQueue mailQueue, UserUtil userUtil, UserPropertyManager userPropertyManager, VelocityTemplatingEngine templatingEngine, TemplateContextFactory templateContextFactory, JiraContactHelper jiraContactHelper) {
        this.rendererManager = rendererManager;
        this.mailQueue = mailQueue;
        this.userUtil = userUtil;
        this.userPropertyManager = userPropertyManager;
        this.velocityManager = templatingEngine;
        this.templateContextFactory = templateContextFactory;
        this.jiraContactHelper = jiraContactHelper;
        this.to = this.getText("admin.global.permissions.administer");
        if (this.getLoggedInUser() != null) {
            this.replyTo = this.getLoggedInUser().getEmailAddress();
        }
    }

    public String doDefault() throws Exception {
        return super.doDefault();
    }

    protected void doValidation() {
        if (StringUtils.isEmpty((String)this.replyTo) || !TextUtils.verifyEmail((String)this.replyTo)) {
            this.addError("from", this.getText("admin.errors.must.specify.valid.from.address"));
        }
        if (StringUtils.isEmpty((String)this.subject)) {
            this.addError("subject", this.getText("admin.errors.must.specify.subject"));
        }
        if (StringUtils.isEmpty((String)this.details)) {
            this.addError("details", this.getText("admin.errors.must.specify.request.details"));
        }
    }

    @RequiresXsrfCheck
    protected String doExecute() throws Exception {
        if (this.getShouldDisplayForm()) {
            this.send();
        }
        return this.getRedirect("/secure/MyJiraHome.jspa");
    }

    public String getTo() {
        return this.to;
    }

    public void setTo(String to) {
        this.to = to;
    }

    public String getFrom() {
        return this.replyTo;
    }

    public void setFrom(String from) {
        this.replyTo = from;
    }

    public String getSubject() {
        return this.subject;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public String getDetails() {
        return this.details;
    }

    public void setDetails(String details) {
        this.details = details;
    }

    @ActionViewData
    public boolean getShouldDisplayForm() {
        return this.jiraContactHelper.isAdministratorContactFormEnabled();
    }

    public String getRenderedMessage() {
        String message = this.getApplicationProperties().getDefaultBackedText("jira.contact.administrators.message");
        if (StringUtils.isEmpty((String)message) || !this.getShouldDisplayForm()) {
            message = this.getText("admin.generalconfiguration.contact.administrators.message.default");
        }
        return this.rendererManager.getRendererForType("atlassian-wiki-renderer").render(message, null);
    }

    @ActionViewData
    public boolean hasCustomMessage() {
        String message = this.getApplicationProperties().getDefaultBackedText("jira.contact.administrators.message");
        return !StringUtils.isEmpty((String)message);
    }

    @ActionViewDataMappings(value={"input", "error"})
    public Map<String, Object> getDataMap() {
        HashMap data = Maps.newHashMap();
        data.put("to", this.getTo());
        data.put("from", this.getFrom());
        data.put("subject", this.getSubject());
        data.put("details", this.getDetails());
        data.put("errors", this.getErrors());
        data.put("renderedMessageContent", this.getRenderedMessage());
        data.put("atlToken", this.getXsrfToken());
        return data;
    }

    public void send() throws MailException {
        Collection administrators = this.userUtil.getJiraAdministrators();
        for (User administrator : administrators) {
            this.sendTo(administrator);
        }
    }

    private void sendTo(User administrator) throws MailException {
        try {
            Map<String, Object> velocityParams = this.templateContextFactory.getTemplateContext(I18nBean.getLocaleFromUser(administrator)).getTemplateParams();
            velocityParams.put("from", this.replyTo);
            velocityParams.put("content", this.details);
            velocityParams.put("padSize", PADSIZE);
            com.atlassian.jira.mail.Email email = new com.atlassian.jira.mail.Email(administrator.getEmailAddress());
            email.setReplyTo(this.replyTo);
            email.setSubject(this.subject);
            email.setMimeType(this.getMimeType(administrator));
            email.setEncoding(ENCODING_UTF8);
            email.setBody(this.renderEmailBody(administrator, JiraMailQueueUtils.getContextParamsBody(velocityParams)));
            this.mailQueue.addItem((MailQueueItem)new SingleMailQueueItem((Email)email));
        }
        catch (Exception e) {
            this.log.error((Object)"Error sending JIRA Administrator email", (Throwable)e);
        }
    }

    private String renderEmailBody(User administrator, Map<String, Object> velocityParams) {
        if (this.getMimeType(administrator).equals("text/html")) {
            String content = (String)velocityParams.get("content");
            velocityParams.put("content", content.replaceAll("\n", "<br>"));
            return this.velocityManager.render(TemplateSources.file((String)(this.getTemplateDirectory(administrator) + EMAIL_TEMPLATE))).applying(velocityParams).asHtml();
        }
        return this.velocityManager.render(TemplateSources.file((String)(this.getTemplateDirectory(administrator) + EMAIL_TEMPLATE))).applying(velocityParams).asPlainText();
    }

    private String getTemplateDirectory(User to) {
        return "templates/email/" + this.getFormat(to) + "/";
    }

    private String getMimeType(User to) {
        if (this.getFormat(to).equals("html")) {
            return "text/html";
        }
        return "text/plain";
    }

    public String getFormat(User user) {
        String prefFormat = this.userPropertyManager.getPropertySet(user).getString("user.notifications.mimetype");
        if (StringUtils.isNotBlank((String)prefFormat) && (prefFormat.equals("html") || prefFormat.equals("text"))) {
            return prefFormat;
        }
        return "html";
    }

    private static class MimeTypes {
        static final String TEXT_HTML = "text/html";
        static final String TEXT_PLAIN = "text/plain";

        private MimeTypes() {
        }
    }
}

