/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.user;

import com.atlassian.crowd.embedded.api.CrowdService;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.crowd.exception.FailedAuthenticationException;
import com.atlassian.jira.plugin.user.PasswordPolicyManager;
import com.atlassian.jira.plugin.user.WebErrorMessage;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.jira.user.util.UserUtil;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.jira.web.action.JiraWebActionSupport;
import com.atlassian.jira.web.action.admin.user.UserPasswordActionHelper;
import com.opensymphony.util.TextUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ChangePassword
extends JiraWebActionSupport {
    private String current;
    private String password;
    private String confirm;
    private String username;
    private final UserUtil userUtil;
    private final UserManager userManager;
    private final CrowdService crowdService;
    private final PasswordPolicyManager passwordPolicyManager;
    private final List<WebErrorMessage> passwordErrors = new ArrayList<WebErrorMessage>();

    public ChangePassword(UserUtil userUtil, UserManager userManager, CrowdService crowdService, PasswordPolicyManager passwordPolicyManager) {
        this.userUtil = userUtil;
        this.userManager = userManager;
        this.crowdService = crowdService;
        this.passwordPolicyManager = passwordPolicyManager;
    }

    public String doDefault() throws Exception {
        User current = this.getLoggedInUser();
        if (current == null || !current.getName().equals(this.username)) {
            return "error";
        }
        return super.doDefault();
    }

    protected void doValidation() {
        ApplicationUser user = (ApplicationUser)Assertions.notNull((String)"user", (Object)this.getLoggedInApplicationUser());
        if (user == null) {
            this.addErrorMessage(this.getText("changepassword.could.not.find.user"));
            return;
        }
        try {
            this.crowdService.authenticate(user.getUsername(), this.current);
        }
        catch (FailedAuthenticationException e) {
            this.addError("current", this.getText("changepassword.current.password.incorrect"));
        }
        catch (Exception e) {
            this.addErrorMessage(this.getText("changepassword.could.not.find.user"));
        }
        if (!TextUtils.stringSet((String)this.password)) {
            this.addError("password", this.getText("changepassword.new.password.required"));
        } else if (!this.password.equals(this.confirm)) {
            this.addError("confirm", this.getText("changepassword.new.password.confirmation.does.not.match"));
        } else {
            Collection<WebErrorMessage> messages = this.passwordPolicyManager.checkPolicy(user, this.current, this.password);
            if (!messages.isEmpty()) {
                this.addError("password", this.getText("changepassword.new.password.rejected"));
                for (WebErrorMessage message : messages) {
                    this.passwordErrors.add(message);
                }
            }
        }
    }

    @RequiresXsrfCheck
    protected String doExecute() throws Exception {
        User currentUSer = this.getLoggedInUser();
        if (currentUSer == null || !currentUSer.getName().equals(this.username)) {
            return "error";
        }
        new UserPasswordActionHelper(this, this.userUtil).setPassword(currentUSer, this.password);
        if (this.invalidInput()) {
            return "error";
        }
        return this.returnComplete();
    }

    public boolean canUpdateUserPassword() {
        return this.userManager.canUpdateUserPassword(this.getLoggedInUser());
    }

    public String doSuccess() {
        return "success";
    }

    public void setCurrent(String current) {
        this.current = current;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public List<WebErrorMessage> getPasswordErrors() {
        return this.passwordErrors;
    }

    public void setConfirm(String confirm) {
        this.confirm = confirm;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }
}

