/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.project;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.action.component.ComponentUtils;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectAssigneeTypes;
import com.atlassian.jira.project.ProjectImpl;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.ApplicationUsers;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.jira.user.util.UserUtil;
import com.atlassian.jira.util.JiraUtils;
import com.atlassian.jira.util.velocity.VelocityRequestContext;
import com.atlassian.jira.util.velocity.VelocityRequestContextFactory;
import com.atlassian.jira.util.velocity.VelocityRequestSession;
import com.atlassian.jira.web.action.JiraWebActionSupport;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import com.opensymphony.util.TextUtils;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;

public class ViewProjects
extends JiraWebActionSupport {
    private final UserUtil userUtil;
    private final UserManager userManager;
    private final VelocityRequestContextFactory velocityRequestContextFactory;

    public ViewProjects(UserUtil userUtil, UserManager userManager, VelocityRequestContextFactory velocityRequestContextFactory) {
        this.userUtil = userUtil;
        this.userManager = userManager;
        this.velocityRequestContextFactory = velocityRequestContextFactory;
    }

    protected String doExecute() throws Exception {
        VelocityRequestContext requestContext = this.velocityRequestContextFactory.getJiraVelocityRequestContext();
        VelocityRequestSession session = requestContext.getSession();
        session.removeAttribute("atl.jira.admin.current.project");
        session.removeAttribute("atl.jira.admin.current.project.tab");
        return super.doExecute();
    }

    public boolean isAdmin() throws GenericEntityException {
        return ComponentAccessor.getPermissionManager().hasPermission(0, this.getLoggedInUser());
    }

    public boolean isProjectAdmin(GenericValue project) throws GenericEntityException {
        return this.isProjectAdmin(new ProjectImpl(project));
    }

    public boolean isProjectAdmin(Project project) {
        return ComponentAccessor.getPermissionManager().hasPermission(23, project, this.getLoggedInUser());
    }

    public boolean hasAdminPermission(GenericValue project) throws GenericEntityException {
        return this.hasAdminPermission(new ProjectImpl(project));
    }

    public boolean hasAdminPermission(Project project) {
        return ComponentAccessor.getPermissionManager().hasPermission(0, project, this.getLoggedInUser());
    }

    public List<Project> getProjectObjects() {
        final ApplicationUser user = this.getLoggedInApplicationUser();
        List projects = ComponentAccessor.getProjectManager().getProjectObjects();
        return Lists.newArrayList((Iterable)Collections2.filter((Collection)projects, (Predicate)new Predicate<Project>(){

            public boolean apply(@Nullable Project input) {
                return ComponentAccessor.getPermissionManager().hasPermission(0, user) || ComponentAccessor.getPermissionManager().hasPermission(23, input, user);
            }
        }));
    }

    public List<GenericValue> getProjects() {
        return Lists.transform(this.getProjectObjects(), (Function)new Function<Project, GenericValue>(){

            public GenericValue apply(@Nullable Project input) {
                return null != input ? input.getGenericValue() : null;
            }
        });
    }

    public boolean isDefaultAssigneeAssignable(GenericValue project) throws GenericEntityException {
        return this.isDefaultAssigneeAssignable(new ProjectImpl(project));
    }

    public boolean isDefaultAssigneeAssignable(Project project) {
        Long assigneeType = project.getAssigneeType();
        if (assigneeType == null) {
            return true;
        }
        if (2L == assigneeType) {
            return ComponentUtils.isProjectLeadAssignable(project.getGenericValue());
        }
        return true;
    }

    public String abbreviateString(String str, int length) {
        return StringUtils.abbreviate((String)str, (int)length);
    }

    public User getUser(GenericValue project) {
        return ApplicationUsers.toDirectoryUser((ApplicationUser)this.userUtil.getUserByKey(project.getString("lead")));
    }

    public boolean getStringSet(GenericValue gv, String value) {
        return TextUtils.stringSet((String)gv.getString(value));
    }

    public String getPrettyAssigneeType(Long assigneeType) {
        return ProjectAssigneeTypes.getPrettyAssigneeType((Long)assigneeType);
    }

    public String getPrettyAssigneeType(Project project) {
        return this.getPrettyAssigneeType(project.getAssigneeType());
    }

    public boolean isAllowSignUp() {
        return this.userManager.hasPasswordWritableDirectory() && JiraUtils.isPublicMode();
    }
}

