/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.project;

import com.atlassian.jira.action.component.ComponentUtils;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectFactory;
import com.atlassian.jira.web.action.project.AbstractProjectAction;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;

public class ViewProject
extends AbstractProjectAction {
    Long pid;
    GenericValue project;
    private final ProjectFactory projectFactory;

    public ViewProject(ProjectFactory projectFactory) {
        this.projectFactory = projectFactory;
    }

    public ViewProject() {
        this(ComponentAccessor.getProjectFactory());
    }

    public String doDefault() throws Exception {
        Project projectObject = this.getProjectObject();
        if (projectObject != null) {
            return this.getRedirect("/plugins/servlet/project-config/" + projectObject.getKey() + "/summary");
        }
        return this.getRedirect("/plugins/servlet/project-config/UNKNOWN/summary");
    }

    protected void doValidation() {
    }

    protected String doExecute() throws Exception {
        Project projectObject = this.getProjectObject();
        if (projectObject != null) {
            return this.getRedirect("/plugins/servlet/project-config/" + projectObject.getKey() + "/summary");
        }
        return this.getRedirect("/plugins/servlet/project-config/UNKNOWN/summary");
    }

    public boolean hasProjectAdminPermission() {
        return this.hasAdminPermission() || ComponentAccessor.getPermissionManager().hasPermission(23, this.getProjectObject(), this.getLoggedInUser());
    }

    public boolean hasAdminPermission() {
        return ComponentAccessor.getPermissionManager().hasPermission(0, this.getLoggedInUser());
    }

    public boolean hasAssociateRolesPermission() throws Exception {
        return this.hasAdminPermission() || this.hasProjectAdminPermission();
    }

    public GenericValue getProject() {
        if (this.project == null) {
            this.project = this.getProjectManager().getProject(this.getPid());
        }
        return this.project;
    }

    public Project getProjectObject() {
        return this.projectFactory.getProject(this.getProject());
    }

    public boolean isDefaultAssigneeAssignable() throws GenericEntityException {
        Long assigneeType = this.getProject().getLong("assigneetype");
        if (assigneeType != null && 2L == assigneeType) {
            return ComponentUtils.isProjectLeadAssignable(this.getProject());
        }
        return true;
    }

    public void setPid(Long pid) {
        this.pid = pid;
    }

    public Long getPid() {
        return this.pid;
    }
}

