/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin.permission;

import com.atlassian.jira.permission.Permission;
import com.atlassian.jira.permission.PermissionSchemeManager;
import com.atlassian.jira.permission.PermissionTypeManager;
import com.atlassian.jira.permission.SchemePermissions;
import com.atlassian.jira.scheme.SchemeEntity;
import com.atlassian.jira.scheme.SchemeType;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.user.UserKeyService;
import com.atlassian.jira.web.action.admin.permission.SchemeAwarePermissionAction;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import com.opensymphony.util.TextUtils;
import java.util.Map;
import org.ofbiz.core.entity.GenericEntityException;
import webwork.action.ActionContext;

@WebSudoRequired
public class AddPermission
extends SchemeAwarePermissionAction {
    private String type;
    private Long[] permissions;
    private final SchemePermissions schemePermissions;
    private final PermissionSchemeManager permissionSchemeManager;
    private final PermissionTypeManager permissionTypeManager;
    private final UserKeyService userKeyService;

    public AddPermission(SchemePermissions schemePermissions, PermissionSchemeManager permissionSchemeManager, PermissionTypeManager permissionTypeManager, UserKeyService userKeyService) {
        this.schemePermissions = schemePermissions;
        this.permissionSchemeManager = permissionSchemeManager;
        this.permissionTypeManager = permissionTypeManager;
        this.userKeyService = userKeyService;
    }

    public String doDefault() throws Exception {
        return super.doDefault();
    }

    protected void doValidation() {
        try {
            String permType = this.getType();
            SchemeType schemeType = (SchemeType)this.permissionTypeManager.getSchemeType(permType);
            if (this.getSchemeId() == null || this.getScheme() == null) {
                this.addErrorMessage(this.getText("admin.permissions.errors.mustselectscheme"));
            }
            if (this.getPermissions() == null || this.getPermissions().length == 0) {
                this.addError("permissions", this.getText("admin.permissions.errors.mustselectpermission"));
            }
            if (!TextUtils.stringSet((String)permType)) {
                this.addErrorMessage(this.getText("admin.permissions.errors.mustselecttype"));
            } else if (schemeType != null) {
                schemeType.doValidation(permType, this.getParameters(), this.getJiraServiceContext());
            }
            if (this.getPermissions() != null) {
                for (int i = 0; i < this.getPermissions().length; ++i) {
                    Long permission = this.getPermissions()[i];
                    if (schemeType == null || permission == null || schemeType.isValidForPermission(permission.intValue())) continue;
                    String permName = this.getPermissionName(permission.intValue());
                    this.addErrorMessage(this.getText("admin.permissions.errors.invalid.combination", permName, schemeType.getDisplayName()));
                }
            }
        }
        catch (GenericEntityException e) {
            this.addErrorMessage(this.getText("admin.errors.permissions.error.occured.adding", "\n") + e.getMessage());
        }
    }

    private String getPermissionName(int permissionId) {
        return ((Permission)this.getAllPermissions().get(new Integer(permissionId))).getName();
    }

    @RequiresXsrfCheck
    protected String doExecute() throws Exception {
        String permissionType = this.getType();
        String parameter = this.getParameter(permissionType);
        for (Long permission : this.permissions) {
            if (this.permissionExists(permission, permissionType, parameter)) continue;
            SchemeEntity schemeEntity = new SchemeEntity(permissionType, parameter, (Object)permission);
            this.permissionSchemeManager.createSchemeEntity(this.getScheme(), schemeEntity);
        }
        return this.getRedirect(this.getRedirectURL() + this.getSchemeId());
    }

    private boolean permissionExists(Long permission, String type, String parameter) throws GenericEntityException {
        return !this.permissionSchemeManager.getEntities(this.getScheme(), permission, type, parameter).isEmpty();
    }

    public Map getTypes() {
        return this.permissionTypeManager.getTypes();
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public Map getParameters() {
        return ActionContext.getSingleValueParameters();
    }

    public String getParameter(String key) {
        String param = (String)this.getParameters().get(key);
        if (key.equals("user")) {
            param = this.userKeyService.getKeyForUsername(param);
        }
        return TextUtils.stringSet((String)param) ? param : null;
    }

    @Override
    public String getRedirectURL() {
        return "EditPermissions!default.jspa?schemeId=";
    }

    public Map getAllPermissions() {
        return this.schemePermissions.getSchemePermissions();
    }

    public Long[] getPermissions() {
        return this.permissions;
    }

    public void setPermissions(Long[] permissions) {
        this.permissions = permissions;
    }
}

