/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin.issuetypes;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.bulkedit.operation.BulkMoveOperation;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.fields.ConfigurableField;
import com.atlassian.jira.issue.fields.FieldManager;
import com.atlassian.jira.issue.fields.config.FieldConfigScheme;
import com.atlassian.jira.issue.fields.config.manager.FieldConfigSchemeManager;
import com.atlassian.jira.issue.fields.config.manager.IssueTypeSchemeManager;
import com.atlassian.jira.issue.fields.option.OptionSetManager;
import com.atlassian.jira.issue.search.SearchProvider;
import com.atlassian.jira.issue.search.managers.IssueSearcherManager;
import com.atlassian.jira.jql.builder.JqlClauseBuilder;
import com.atlassian.jira.jql.builder.JqlQueryBuilder;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.web.action.JiraWebActionSupport;
import com.atlassian.jira.web.action.admin.issuetypes.ExecutableAction;
import com.atlassian.jira.web.action.admin.issuetypes.IssueTypeManageableOption;
import com.atlassian.jira.web.action.admin.issuetypes.ManageableOptionType;
import com.atlassian.jira.web.bean.BulkEditBeanImpl;
import com.atlassian.jira.web.bean.BulkEditBeanSessionHelper;
import com.atlassian.jira.web.bean.MultiBulkMoveBean;
import com.atlassian.query.Query;
import com.atlassian.query.order.SortOrder;
import java.util.Collection;
import org.apache.commons.collections.Predicate;

public class AbstractManageIssueTypeOptionsAction
extends JiraWebActionSupport {
    protected String fieldId;
    protected FieldConfigScheme configScheme;
    protected Long schemeId;
    protected final FieldConfigSchemeManager configSchemeManager;
    protected final IssueTypeSchemeManager issueTypeSchemeManager;
    protected final FieldManager fieldManager;
    protected final OptionSetManager optionSetManager;
    protected final ManageableOptionType manageableOptionType;
    protected final BulkMoveOperation bulkMoveOperation;
    protected final SearchProvider searchProvider;
    protected final IssueManager issueManager;
    protected final IssueSearcherManager searcherManager;

    public AbstractManageIssueTypeOptionsAction(FieldConfigSchemeManager configSchemeManager, IssueTypeSchemeManager issueTypeSchemeManager, FieldManager fieldManager, OptionSetManager optionSetManager, IssueTypeManageableOption manageableOptionType, BulkMoveOperation bulkMoveOperation, SearchProvider searchProvider, IssueManager issueManager) {
        this.configSchemeManager = configSchemeManager;
        this.issueTypeSchemeManager = issueTypeSchemeManager;
        this.fieldManager = fieldManager;
        this.optionSetManager = optionSetManager;
        this.manageableOptionType = manageableOptionType;
        this.bulkMoveOperation = bulkMoveOperation;
        this.searchProvider = searchProvider;
        this.issueManager = issueManager;
        this.searcherManager = (IssueSearcherManager)ComponentAccessor.getComponent(IssueSearcherManager.class);
    }

    public ManageableOptionType getManageableOption() {
        return this.manageableOptionType;
    }

    protected ConfigurableField getConfigurableField() {
        return this.fieldManager.getConfigurableField(this.getManageableOption().getFieldId());
    }

    protected String getRedirect(FieldConfigScheme configScheme) {
        return this.getRedirect("ManageIssueTypeSchemes!default.jspa?actionedSchemeId=" + configScheme.getId());
    }

    public FieldConfigScheme getConfigScheme() {
        if (this.configScheme == null && this.schemeId != null) {
            this.configScheme = this.configSchemeManager.getFieldConfigScheme(this.schemeId);
        }
        return this.configScheme;
    }

    protected void setConfigScheme(FieldConfigScheme configScheme) {
        this.configScheme = configScheme;
    }

    public String getFieldId() {
        return this.fieldId;
    }

    public void setFieldId(String fieldId) {
        this.fieldId = fieldId;
    }

    public Long getSchemeId() {
        return this.schemeId;
    }

    public void setSchemeId(Long schemeId) {
        this.schemeId = schemeId;
    }

    protected Query getQuery(Collection<Long> projectIds, Collection<String> obseleteIssueTypeIds) {
        User remoteUser = this.getLoggedInUser();
        if (remoteUser == null) {
            return null;
        }
        JqlQueryBuilder builder = JqlQueryBuilder.newBuilder();
        JqlClauseBuilder whereBuilder = builder.where().defaultAnd();
        if (obseleteIssueTypeIds != null && !obseleteIssueTypeIds.isEmpty()) {
            whereBuilder.issueType().inStrings(obseleteIssueTypeIds);
        }
        if (projectIds != null && !projectIds.isEmpty()) {
            whereBuilder.project().inNumbers(projectIds);
        }
        builder.orderBy().project(SortOrder.ASC).issueType(SortOrder.ASC);
        return builder.buildQuery();
    }

    protected String migrateIssues(ExecutableAction executableAction, Collection affectedIssues, Collection targetOptionIds) {
        FieldConfigScheme configScheme = this.getConfigScheme();
        BulkEditBeanImpl bulkEditBean = new BulkEditBeanImpl(this.issueManager);
        bulkEditBean.initSelectedIssues(affectedIssues);
        bulkEditBean.initMultiBulkBean();
        MultiBulkMoveBean multiBulkMoveBean = bulkEditBean.getRelatedMultiBulkMoveBean();
        multiBulkMoveBean.initOptionIds(targetOptionIds);
        multiBulkMoveBean.validate((ErrorCollection)this, this.bulkMoveOperation, this.getLoggedInUser());
        if (this.hasAnyErrors()) {
            return "input";
        }
        multiBulkMoveBean.setExecutableAction(executableAction);
        multiBulkMoveBean.setFinalLocation("ManageIssueTypeSchemes!default.jspa?actionedSchemeId=" + configScheme.getId());
        BulkEditBeanSessionHelper.storeToSession(bulkEditBean);
        return this.forceRedirect("MigrateIssueTypes!default.jspa");
    }

    protected static class FieldConfigPredicate
    implements Predicate {
        private final Long id;
        private final String name;

        public FieldConfigPredicate(Long id, String name) {
            this.id = id;
            this.name = name;
        }

        public boolean evaluate(Object object) {
            FieldConfigScheme configScheme = (FieldConfigScheme)object;
            return configScheme.getName().equalsIgnoreCase(this.name) && !configScheme.getId().equals(this.id);
        }
    }
}

