/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin.issuefields.screens.enterprise;

import com.atlassian.jira.config.ConstantsManager;
import com.atlassian.jira.config.SubTaskManager;
import com.atlassian.jira.issue.fields.screen.FieldScreenSchemeManager;
import com.atlassian.jira.issue.fields.screen.issuetype.IssueTypeScreenScheme;
import com.atlassian.jira.issue.fields.screen.issuetype.IssueTypeScreenSchemeEntity;
import com.atlassian.jira.issue.fields.screen.issuetype.IssueTypeScreenSchemeManager;
import com.atlassian.jira.issue.fields.screen.issuetype.ProjectIssueTypeScreenSchemeHelper;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.web.action.JiraWebActionSupport;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.ofbiz.core.entity.GenericValue;

@WebSudoRequired
public class ConfigureIssueTypeScreenScheme
extends JiraWebActionSupport {
    private Long id;
    private String issueTypeId;
    private Long fieldScreenSchemeId;
    private final IssueTypeScreenSchemeManager issueTypeScreenSchemeManager;
    private final ConstantsManager constantsManager;
    private final FieldScreenSchemeManager fieldScreenSchemeManager;
    private final SubTaskManager subTaskManager;
    private final ProjectIssueTypeScreenSchemeHelper helper;
    private List addableIssueTypes;
    private boolean edited;
    private IssueTypeScreenScheme issueTypeScreenScheme;
    private Collection fieldScreenSchemes;
    private Collection allRelevantIssueTypes;
    private Collection allRelevantIssueTypeObjects;
    private List<Project> projects;

    public ConfigureIssueTypeScreenScheme(IssueTypeScreenSchemeManager issueTypeScreenSchemeManager, ConstantsManager constantsManager, FieldScreenSchemeManager fieldScreenSchemeManager, SubTaskManager subTaskManager, ProjectIssueTypeScreenSchemeHelper helper) {
        this.issueTypeScreenSchemeManager = issueTypeScreenSchemeManager;
        this.constantsManager = constantsManager;
        this.fieldScreenSchemeManager = fieldScreenSchemeManager;
        this.subTaskManager = subTaskManager;
        this.helper = helper;
    }

    protected void doValidation() {
        if (this.getId() == null) {
            this.addErrorMessage(this.getText("admin.errors.id.cannot.be.null"));
        }
    }

    protected String doExecute() throws Exception {
        return this.getResult();
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Collection getIssueTypeScreenSchemeEntities() {
        return this.getIssueTypeScreenScheme().getEntities();
    }

    public IssueTypeScreenScheme getIssueTypeScreenScheme() {
        if (this.issueTypeScreenScheme == null) {
            this.issueTypeScreenScheme = this.issueTypeScreenSchemeManager.getIssueTypeScreenScheme(this.getId());
        }
        return this.issueTypeScreenScheme;
    }

    public Collection getAddableIssueTypes() {
        if (this.addableIssueTypes == null) {
            this.addableIssueTypes = new LinkedList(this.getAllRelevantIssueTypeObjects());
            Iterator iterator = this.addableIssueTypes.iterator();
            while (iterator.hasNext()) {
                IssueType issueType = (IssueType)iterator.next();
                GenericValue issueTypeGV = issueType.getGenericValue();
                if (this.getIssueTypeScreenScheme().getEntity(issueTypeGV.getString("id")) == null) continue;
                iterator.remove();
            }
        }
        return this.addableIssueTypes;
    }

    public String getIssueTypeId() {
        return this.issueTypeId;
    }

    public void setIssueTypeId(String issueTypeId) {
        this.issueTypeId = issueTypeId;
    }

    public Long getFieldScreenSchemeId() {
        return this.fieldScreenSchemeId;
    }

    public void setFieldScreenSchemeId(Long fieldScreenSchemeId) {
        this.fieldScreenSchemeId = fieldScreenSchemeId;
    }

    @RequiresXsrfCheck
    public String doDeleteIssueTypeScreenSchemeEntity() {
        if (this.getIssueTypeId() == null) {
            this.addErrorMessage(this.getText("admin.errors.screens.cannot.delete.default.screen"));
        }
        if (!this.invalidInput()) {
            this.getIssueTypeScreenScheme().removeEntity(this.getIssueTypeId());
            return this.redirectToView();
        }
        return this.getResult();
    }

    protected String redirectToView() {
        return this.getRedirect("ConfigureIssueTypeScreenScheme.jspa?id=" + this.getId());
    }

    public String doViewEditIssueTypeScreenSchemeEntity() {
        if (this.getId() == null) {
            this.addErrorMessage(this.getText("admin.errors.id.cannot.be.null"));
        }
        if (!this.invalidInput()) {
            IssueTypeScreenSchemeEntity issueTypeScreenSchemeEntity = this.getIssueTypeScreenScheme().getEntity(this.getIssueTypeId());
            this.setFieldScreenSchemeId(issueTypeScreenSchemeEntity.getFieldScreenScheme().getId());
        }
        return "input";
    }

    @RequiresXsrfCheck
    public String doEditIssueTypeScreenSchemeEntity() {
        if (this.getFieldScreenSchemeId() == null) {
            this.addError("fieldScreenSchemeId", this.getText("admin.errors.screens.please.select.screen.scheme"));
        }
        if (!this.invalidInput()) {
            IssueTypeScreenSchemeEntity issueTypeScreenSchemeEntity = this.getIssueTypeScreenScheme().getEntity(this.getIssueTypeId());
            issueTypeScreenSchemeEntity.setFieldScreenScheme(this.fieldScreenSchemeManager.getFieldScreenScheme(this.getFieldScreenSchemeId()));
            issueTypeScreenSchemeEntity.store();
            return this.redirectToView();
        }
        return "input";
    }

    private void validateForEdit() {
        if (this.getId() == null) {
            this.addErrorMessage(this.getText("admin.errors.id.cannot.be.null"));
        }
    }

    public boolean isEdited() {
        return this.edited;
    }

    public void setEdited(boolean edited) {
        this.edited = edited;
    }

    public GenericValue getIssueType() {
        return this.constantsManager.getIssueType(this.getIssueTypeId());
    }

    public boolean isDefault(IssueTypeScreenSchemeEntity issueTypeScreenSchemeEntity) {
        return issueTypeScreenSchemeEntity.getIssueTypeId() == null;
    }

    public Collection getFieldScreenSchemes() {
        if (this.fieldScreenSchemes == null) {
            this.fieldScreenSchemes = this.fieldScreenSchemeManager.getFieldScreenSchemes();
        }
        return this.fieldScreenSchemes;
    }

    public boolean isShouldDisplay(IssueTypeScreenSchemeEntity issueTypeScreenSchemeEntity) {
        if (issueTypeScreenSchemeEntity.getIssueTypeId() == null) {
            return true;
        }
        return this.getAllRelevantIssueTypes().contains(issueTypeScreenSchemeEntity.getIssueType());
    }

    private Collection getAllRelevantIssueTypes() {
        if (this.allRelevantIssueTypes == null) {
            this.allRelevantIssueTypes = this.subTaskManager.isSubTasksEnabled() ? this.constantsManager.getAllIssueTypes() : this.constantsManager.getIssueTypes();
        }
        return this.allRelevantIssueTypes;
    }

    private Collection getAllRelevantIssueTypeObjects() {
        if (this.allRelevantIssueTypeObjects == null) {
            this.allRelevantIssueTypeObjects = this.subTaskManager.isSubTasksEnabled() ? this.constantsManager.getAllIssueTypeObjects() : this.constantsManager.getRegularIssueTypeObjects();
        }
        return this.allRelevantIssueTypeObjects;
    }

    public List<Project> getUsedIn() {
        if (this.projects == null) {
            IssueTypeScreenScheme issueTypeScreenScheme = this.getIssueTypeScreenScheme();
            this.projects = this.helper.getProjectsForScheme(issueTypeScreenScheme);
        }
        return this.projects;
    }
}

