/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin.importer.project;

import com.atlassian.core.util.DateUtils;
import com.atlassian.jira.imports.project.core.ProjectImportResults;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectAssigneeTypes;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.system.ExtendedSystemInfoUtilsImpl;
import com.atlassian.jira.web.action.JiraWebActionSupport;
import com.atlassian.jira.web.action.admin.importer.project.ProjectImportBean;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import java.util.Iterator;
import java.util.Map;
import java.util.ResourceBundle;
import org.apache.log4j.Logger;

@WebSudoRequired
public class ProjectImportResultsAction
extends JiraWebActionSupport {
    private static final Logger log = Logger.getLogger((String)"com.atlassian.jira.imports.project.ProjectImportResultsAction");
    ProjectImportResults projectImportResults;

    protected void doValidation() {
        super.doValidation();
        if (log.isDebugEnabled()) {
            System.gc();
            Map<String, String> stats = new ExtendedSystemInfoUtilsImpl((I18nHelper)this).getJvmStats();
            Iterator<String> i$ = stats.keySet().iterator();
            while (i$.hasNext()) {
                String o;
                String key = o = i$.next();
                String value = stats.get(key);
                log.debug((Object)(key + " " + value));
            }
        }
        ProjectImportBean projectImportBean = ProjectImportBean.getProjectImportBeanFromSession();
        projectImportBean.setBackupOverview(null);
        projectImportBean.setProjectImportData(null);
        projectImportBean.setProjectImportOptions(null);
        projectImportBean.setMappingResult(null);
        projectImportBean.getTaskProgressInformation().setTaskId(null);
        if (projectImportBean.getTaskProgressInformation().getErrorCollection() != null) {
            this.addErrorCollection(projectImportBean.getTaskProgressInformation().getErrorCollection());
        }
    }

    public String doViewNewProject() {
        Project importedProject = this.getProjectImportResults().getImportedProject();
        Long projectID = importedProject.getId();
        return this.getRedirect("/plugins/servlet/project-config/" + importedProject.getKey() + "/summary");
    }

    public ProjectImportResults getProjectImportResults() {
        if (this.projectImportResults == null) {
            this.projectImportResults = ProjectImportBean.getProjectImportBeanFromSession().getProjectImportResults();
        }
        return this.projectImportResults;
    }

    public String getAssigneeTypeString(Long assigneeType) {
        return this.getText(ProjectAssigneeTypes.getPrettyAssigneeType((Long)assigneeType));
    }

    public String getProjectEmail(Project project) throws Exception {
        return project.getEmail();
    }

    public String getPrettyImportDuration() {
        long durationInSeconds = this.getProjectImportResults().getImportDuration() / 1000L;
        return DateUtils.getDurationPretty((long)durationInSeconds, (ResourceBundle)this.getJiraServiceContext().getI18nBean().getDefaultResourceBundle());
    }
}

