/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin.importer.project;

import com.atlassian.jira.task.TaskDescriptor;
import com.atlassian.jira.task.TaskManager;
import com.atlassian.jira.web.action.JiraWebActionSupport;
import com.atlassian.jira.web.action.admin.importer.project.ProjectImportBean;
import com.atlassian.jira.web.bean.TaskDescriptorBean;
import java.util.concurrent.ExecutionException;

public abstract class AbstractProjectImportProgress<V>
extends JiraWebActionSupport {
    private String redirectOnComplete;
    private TaskDescriptorBean<V> ourTask;
    private final TaskManager taskManager;
    private final TaskDescriptorBean.Factory taskBeanFactory;

    public AbstractProjectImportProgress(TaskManager taskManager, TaskDescriptorBean.Factory factory) {
        this.taskManager = taskManager;
        this.taskBeanFactory = factory;
    }

    public void doValidation() {
        Long taskId = ProjectImportBean.getProjectImportBeanFromSession().getTaskProgressInformation().getTaskId();
        TaskDescriptor descriptor = this.taskManager.getTask(taskId);
        if (taskId == null || descriptor == null) {
            if (!this.taskIsComplete()) {
                this.addErrorMessage(this.getText("admin.project.import.progress.no.task.id"));
            }
        } else {
            this.ourTask = this.taskBeanFactory.create(descriptor);
        }
    }

    public String doExecute() throws Exception {
        if (this.ourTask == null && this.taskIsComplete()) {
            return this.getRedirect(this.getRedirectOnComplete());
        }
        if (this.ourTask.isFinished()) {
            return this.handleFinishedTask(this.ourTask);
        }
        return "input";
    }

    protected abstract boolean taskIsComplete();

    protected abstract String handleFinishedTask(TaskDescriptorBean<V> var1) throws ExecutionException, InterruptedException;

    protected abstract String getSubmitUrl();

    public String getRedirectOnComplete() {
        return this.redirectOnComplete;
    }

    public void setRedirectOnComplete(String redirectOnComplete) {
        this.redirectOnComplete = redirectOnComplete;
    }

    public TaskDescriptorBean<?> getOurTask() {
        return this.ourTask;
    }
}

