/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.util.Users;
import com.atlassian.jira.web.action.JiraWebActionSupport;
import com.atlassian.jira.web.action.SafeRedirectChecker;
import com.atlassian.jira.web.util.HelpUtil;
import com.google.common.collect.ImmutableSortedSet;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class XsrfErrorAction
extends JiraWebActionSupport {
    public static final String FORWARD_PATH = "/secure/" + XsrfErrorAction.class.getSimpleName() + ".jspa";
    private static final Logger log = Logger.getLogger(XsrfErrorAction.class);
    private final SafeRedirectChecker safeRedirectChecker;
    private int timeoutSeconds;

    public XsrfErrorAction(SafeRedirectChecker safeRedirectChecker) {
        this.safeRedirectChecker = safeRedirectChecker;
        User user = this.getAuthContext().getLoggedInUser();
        if (user != null) {
            this.request.setAttribute("loggedin", (Object)Boolean.TRUE);
        }
        this.request.setAttribute("xsrfToken", (Object)this.getXsrfToken());
        this.timeoutSeconds = this.request.getSession(true).getMaxInactiveInterval();
        this.request.setAttribute("maxInactiveIntervalMinutes", (Object)(this.request.getSession(true).getMaxInactiveInterval() / 60));
        this.request.setAttribute("contextpath", (Object)this.request.getContextPath());
        this.request.setAttribute("helpUtil", (Object)new HelpUtil());
        int parameterCount = this.getRequestParameters().size();
        log.info((Object)("The security token is missing for '" + (Users.isAnonymous((User)user) ? "anonymous" : user.getName()) + "'. " + (parameterCount == 0 ? "The browser has provided ZERO parameters.  Probably BUG! " : "") + "User-Agent : '" + this.getBrowserAgent(this.request) + "'"));
    }

    public String execute() throws Exception {
        return this.isSessionExpired() ? "session_expired" : "xsrf_missing";
    }

    public boolean isHasRedirectUrl() {
        return this.getReturnUrl() != null || this.safeRedirectChecker.canRedirectTo(this.getReferer());
    }

    public String getEncodedRedirectUrl() {
        if (this.getReturnUrl() != null) {
            try {
                return URLEncoder.encode(this.insertContextPath(this.getReturnUrl()), "utf-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.safeRedirectChecker.canRedirectTo(this.getReferer())) {
            return this.getReferer();
        }
        return this.insertContextPath("/");
    }

    private String getReferer() {
        return this.request.getHeader("Referer");
    }

    public String getSessionTimeoutDuration() {
        return String.valueOf(Math.round(this.timeoutSeconds > 3600 ? (double)this.timeoutSeconds / 3600.0 : Math.max(1.0, (double)this.timeoutSeconds / 60.0)));
    }

    public String getSessionTimeoutUnit() {
        boolean singular = "1".equals(this.getSessionTimeoutDuration());
        if (this.timeoutSeconds > 3600) {
            return singular ? this.getText("common.words.hour") : this.getText("common.words.hours");
        }
        return singular ? this.getText("common.words.minute") : this.getText("common.words.minutes");
    }

    private String getBrowserAgent(HttpServletRequest request) {
        return StringUtils.defaultIfEmpty((String)request.getHeader("User-Agent"), (String)"Not Provided");
    }

    private JiraAuthenticationContext getAuthContext() {
        return (JiraAuthenticationContext)ComponentAccessor.getComponentOfType(JiraAuthenticationContext.class);
    }

    public boolean isSessionExpired() {
        HttpSession session;
        String requestedSessionId = this.request.getRequestedSessionId();
        if (StringUtils.isNotBlank((String)requestedSessionId) && (session = this.request.getSession(false)) != null) {
            return !requestedSessionId.equals(session.getId());
        }
        return false;
    }

    public String getRequestURL() {
        String forwardRequestURI = (String)this.request.getAttribute("javax.servlet.forward.request_uri");
        if (forwardRequestURI != null) {
            return forwardRequestURI;
        }
        return this.request.getRequestURI();
    }

    public String getRequestMethod() {
        return this.request.getMethod();
    }

    public boolean getNoRequestParameters() {
        return this.request.getParameterMap().isEmpty();
    }

    public Set<Map.Entry<String, List<String>>> getRequestParameters() {
        HashMap<String, List<String>> allParams = new HashMap<String, List<String>>();
        Enumeration enumeration = this.request.getParameterNames();
        while (enumeration.hasMoreElements()) {
            String name = (String)enumeration.nextElement();
            String[] values = this.request.getParameterValues(name);
            allParams.put(name, Arrays.asList(values));
        }
        return ImmutableSortedSet.copyOf((Comparator)new BiggestValueFirstComparator(), allParams.entrySet());
    }

    private static class BiggestValueFirstComparator
    implements Comparator<Map.Entry<String, List<String>>> {
        private BiggestValueFirstComparator() {
        }

        @Override
        public int compare(Map.Entry<String, List<String>> entry1, Map.Entry<String, List<String>> entry2) {
            int valLen1 = 0;
            int valLen2 = 0;
            if (entry1.getValue() != null) {
                for (String s : entry1.getValue()) {
                    valLen1 += s != null ? s.length() : 0;
                }
            }
            if (entry2.getValue() != null) {
                for (String s : entry2.getValue()) {
                    valLen2 += s != null ? s.length() : 0;
                }
            }
            if (valLen1 == valLen2) {
                return entry1.getKey().compareTo(entry2.getKey());
            }
            return valLen2 - valLen1;
        }
    }
}

